/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.modules.decompiler.exps;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.java.decompiler.main.ClassesProcessor;
import org.jetbrains.java.decompiler.main.DecompilerContext;
import org.jetbrains.java.decompiler.main.TextBuffer;
import org.jetbrains.java.decompiler.main.collectors.BytecodeMappingTracer;
import org.jetbrains.java.decompiler.main.rels.MethodWrapper;
import org.jetbrains.java.decompiler.modules.decompiler.ExprProcessor;
import org.jetbrains.java.decompiler.modules.decompiler.exps.Exprent;
import org.jetbrains.java.decompiler.modules.decompiler.vars.CheckTypesResult;
import org.jetbrains.java.decompiler.struct.attr.StructExceptionsAttribute;
import org.jetbrains.java.decompiler.struct.gen.VarType;
import org.jetbrains.java.decompiler.struct.match.IMatchable;
import org.jetbrains.java.decompiler.struct.match.MatchEngine;
import org.jetbrains.java.decompiler.struct.match.MatchNode;
import org.jetbrains.java.decompiler.util.InterpreterUtil;

public class ExitExprent
extends Exprent {
    public static final int EXIT_RETURN = 0;
    public static final int EXIT_THROW = 1;
    private final int exitType;
    private Exprent value;
    private final VarType retType;

    public ExitExprent(int exitType, Exprent value, VarType retType, Set<Integer> bytecodeOffsets) {
        super(4);
        this.exitType = exitType;
        this.value = value;
        this.retType = retType;
        this.addBytecodeOffsets(bytecodeOffsets);
    }

    @Override
    public Exprent copy() {
        return new ExitExprent(this.exitType, this.value == null ? null : this.value.copy(), this.retType, this.bytecode);
    }

    @Override
    public CheckTypesResult checkExprTypeBounds() {
        CheckTypesResult result = new CheckTypesResult();
        if (this.exitType == 0 && this.retType.type != 10) {
            result.addMinTypeExprent(this.value, VarType.getMinTypeInFamily(this.retType.typeFamily));
            result.addMaxTypeExprent(this.value, this.retType);
        }
        return result;
    }

    @Override
    public List<Exprent> getAllExprents() {
        ArrayList<Exprent> lst = new ArrayList<Exprent>();
        if (this.value != null) {
            lst.add(this.value);
        }
        return lst;
    }

    @Override
    public TextBuffer toJava(int indent, BytecodeMappingTracer tracer) {
        StructExceptionsAttribute attr;
        tracer.addMapping(this.bytecode);
        if (this.exitType == 0) {
            TextBuffer buffer = new TextBuffer("return");
            if (this.retType.type != 10) {
                buffer.append(' ');
                ExprProcessor.getCastedExprent(this.value, this.retType, buffer, indent, false, tracer);
            }
            return buffer;
        }
        MethodWrapper method = (MethodWrapper)DecompilerContext.getProperty("CURRENT_METHOD_WRAPPER");
        ClassesProcessor.ClassNode node = (ClassesProcessor.ClassNode)DecompilerContext.getProperty("CURRENT_CLASS_NODE");
        if (method != null && node != null && (attr = (StructExceptionsAttribute)method.methodStruct.getAttributes().getWithKey("Exceptions")) != null) {
            String classname = null;
            for (int i = 0; i < attr.getThrowsExceptions().size(); ++i) {
                String exClassName = attr.getExcClassname(i, node.classStruct.getPool());
                if ("java/lang/Throwable".equals(exClassName)) {
                    classname = exClassName;
                    break;
                }
                if (!"java/lang/Exception".equals(exClassName)) continue;
                classname = exClassName;
            }
            if (classname != null) {
                VarType exType = new VarType(classname, true);
                TextBuffer buffer = new TextBuffer("throw ");
                ExprProcessor.getCastedExprent(this.value, exType, buffer, indent, false, tracer);
                return buffer;
            }
        }
        return this.value.toJava(indent, tracer).prepend("throw ");
    }

    @Override
    public void replaceExprent(Exprent oldExpr, Exprent newExpr) {
        if (oldExpr == this.value) {
            this.value = newExpr;
        }
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o == null || !(o instanceof ExitExprent)) {
            return false;
        }
        ExitExprent et = (ExitExprent)o;
        return this.exitType == et.getExitType() && InterpreterUtil.equalObjects(this.value, et.getValue());
    }

    public int getExitType() {
        return this.exitType;
    }

    public Exprent getValue() {
        return this.value;
    }

    public VarType getRetType() {
        return this.retType;
    }

    @Override
    public boolean match(MatchNode matchNode, MatchEngine engine) {
        if (!super.match(matchNode, engine)) {
            return false;
        }
        Integer type = (Integer)matchNode.getRuleValue(IMatchable.MatchProperties.EXPRENT_EXITTYPE);
        return type == null || this.exitType == type;
    }
}

