/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;
import org.jetbrains.plugins.javaFX.fxml.refs.JavaFxPropertyReference;

public class JavaFxStaticPropertyReference
extends JavaFxPropertyReference<XmlAttribute> {
    private String myPropertyName;
    private PsiMethod myStaticMethod;

    public JavaFxStaticPropertyReference(@NotNull XmlAttribute xmlAttribute, @Nullable PsiClass psiClass, @NotNull String propertyName) {
        if (xmlAttribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlAttribute", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReference", "<init>"));
        }
        if (propertyName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "propertyName", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReference", "<init>"));
        }
        super(xmlAttribute, psiClass);
        this.myPropertyName = propertyName;
        this.myStaticMethod = JavaFxPsiUtil.findStaticPropertySetter(propertyName, psiClass);
    }

    @Nullable
    public PsiElement resolve() {
        return this.myStaticMethod;
    }

    @Override
    @Nullable
    public PsiMethod getGetter() {
        return null;
    }

    @Override
    @Nullable
    public PsiMethod getSetter() {
        return null;
    }

    @Override
    @Nullable
    public PsiField getField() {
        return null;
    }

    @Override
    @Nullable
    public PsiMethod getObservableGetter() {
        return null;
    }

    @Override
    @Nullable
    public PsiMethod getStaticSetter() {
        return this.myStaticMethod;
    }

    @Override
    public PsiType getType() {
        PsiParameter[] parameters;
        if (this.myStaticMethod != null && (parameters = this.myStaticMethod.getParameterList().getParameters()).length == 2) {
            return parameters[1].getType();
        }
        return null;
    }

    @Override
    public String getPropertyName() {
        return this.myPropertyName;
    }

    @NotNull
    public Object[] getVariants() {
        if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxStaticPropertyReference", "getVariants"));
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        String newPropertyName = JavaFxPsiUtil.getPropertyName(newElementName, true);
        return super.handleElementRename(newPropertyName);
    }
}

