/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

class JavaFxLocationReferenceProvider
extends PsiReferenceProvider {
    private boolean mySupportCommaInValue = false;
    private final Set<FileType> myAcceptedFileTypes;

    JavaFxLocationReferenceProvider() {
        this(false, new String[0]);
    }

    JavaFxLocationReferenceProvider(boolean supportCommaInValue, String ... acceptedFileExtensions) {
        this.mySupportCommaInValue = supportCommaInValue;
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        this.myAcceptedFileTypes = ContainerUtil.map2Set((Object[])acceptedFileExtensions, arg_0 -> ((FileTypeManager)fileTypeManager).getFileTypeByExtension(arg_0));
    }

    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
        }
        String value = ((XmlAttributeValue)element).getValue();
        if (this.mySupportCommaInValue && value.contains(",")) {
            int startIdx = 0;
            ArrayList refs = new ArrayList();
            while (true) {
                int endIdx;
                String item = (endIdx = value.indexOf(44, startIdx)) >= 0 ? value.substring(startIdx, endIdx) : value.substring(startIdx);
                Collections.addAll(refs, this.collectRefs(element, item, startIdx + 1));
                if (endIdx < 0) break;
                startIdx = endIdx + 1;
            }
            PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
            }
            return psiReferenceArray;
        }
        PsiReference[] psiReferenceArray = this.collectRefs(element, value, 1);
        if (psiReferenceArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "getReferencesByElement"));
        }
        return psiReferenceArray;
    }

    private PsiReference[] collectRefs(@NotNull PsiElement element, String value, int startInElement) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxLocationReferenceProvider", "collectRefs"));
        }
        int atSignIndex = value.indexOf(64);
        if (atSignIndex >= 0 && (atSignIndex == 0 || StringUtil.trimLeading((String)value).startsWith("@"))) {
            value = value.substring(atSignIndex + 1);
            startInElement += atSignIndex + 1;
        }
        FileReferenceSet set = new FileReferenceSet(value, element, startInElement, null, true){

            protected Condition<PsiFileSystemItem> getReferenceCompletionFilter() {
                return item -> {
                    if (item instanceof PsiDirectory) {
                        return true;
                    }
                    VirtualFile virtualFile = item.getVirtualFile();
                    if (virtualFile == null) {
                        return false;
                    }
                    FileType fileType = virtualFile.getFileType();
                    return JavaFxLocationReferenceProvider.this.myAcceptedFileTypes.contains(fileType);
                };
            }
        };
        if (value.startsWith("/")) {
            set.addCustomization(FileReferenceSet.DEFAULT_PATH_EVALUATOR_OPTION, (Object)FileReferenceSet.ABSOLUTE_TOP_LEVEL);
        }
        return set.getAllReferences();
    }
}

