/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.inspections;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionToolSession;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixOnPsiElement;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.codeInspection.ui.SingleCheckboxOptionsPanel;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.changeSignature.ChangeSignatureProcessor;
import com.intellij.refactoring.changeSignature.JavaChangeSignatureDialog;
import com.intellij.refactoring.changeSignature.ParameterInfoImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxFileTypeFactory;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxEventHandlerInspection
extends XmlSuppressableInspectionTool {
    public boolean myDetectNonVoidReturnType;

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly, @NotNull LocalInspectionToolSession session) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "buildVisitor"));
        }
        if (session == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "buildVisitor"));
        }
        if (!JavaFxFileTypeFactory.isFxml(session.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlAttributeValue(XmlAttributeValue xmlAttributeValue) {
                PsiClassType declaredType;
                super.visitXmlAttributeValue(xmlAttributeValue);
                PsiElement valueParent = xmlAttributeValue.getParent();
                if (!(valueParent instanceof XmlAttribute)) {
                    return;
                }
                XmlAttribute attribute = (XmlAttribute)valueParent;
                List eventHandlerMethods = JavaFxEventHandlerInspection.getEventHandlerMethods(attribute);
                if (eventHandlerMethods.size() == 0) {
                    return;
                }
                if (eventHandlerMethods.size() != 1) {
                    holder.registerProblem((PsiElement)xmlAttributeValue, "Ambiguous event handler name: more than one matching method found", new LocalQuickFix[0]);
                }
                if (JavaFxEventHandlerInspection.this.myDetectNonVoidReturnType) {
                    eventHandlerMethods.stream().map(PsiMethod::getReturnType).filter(returnType -> !PsiType.VOID.equals(returnType)).findAny().ifPresent(ignored -> {
                        if (holder == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$1", "lambda$visitXmlAttributeValue$1"));
                        }
                        holder.registerProblem((PsiElement)xmlAttributeValue, "Return type of event handler should be void", new LocalQuickFix[0]);
                    });
                }
                if ((declaredType = JavaFxPsiUtil.getDeclaredEventType(attribute)) == null) {
                    return;
                }
                for (PsiMethod method : eventHandlerMethods) {
                    PsiClassType expectedRawType;
                    PsiType actualType;
                    PsiParameter[] parameters = method.getParameterList().getParameters();
                    if (parameters.length != 1 || !((actualType = parameters[0].getType()) instanceof PsiClassType) || actualType.isAssignableFrom((PsiType)declaredType)) continue;
                    ChangeParameterTypeQuickFix parameterTypeFix = new ChangeParameterTypeQuickFix(attribute, method, (PsiType)declaredType);
                    PsiClassType actualRawType = ((PsiClassType)actualType).rawType();
                    if (actualRawType.isAssignableFrom((PsiType)(expectedRawType = declaredType.rawType()))) {
                        ArrayList<ChangeParameterTypeQuickFix> quickFixes = new ArrayList<ChangeParameterTypeQuickFix>();
                        quickFixes.add(parameterTypeFix);
                        JavaFxEventHandlerInspection.collectFieldTypeFixes(attribute, (PsiClassType)actualType, quickFixes);
                        holder.registerProblem((PsiElement)xmlAttributeValue, "Incompatible generic parameter of event handler argument: " + actualType.getCanonicalText() + " is not assignable from " + declaredType.getCanonicalText(), quickFixes.toArray(LocalQuickFix.EMPTY_ARRAY));
                        continue;
                    }
                    holder.registerProblem((PsiElement)xmlAttributeValue, "Incompatible event handler argument: " + actualRawType.getCanonicalText() + " is not assignable from " + expectedRawType.getCanonicalText(), new LocalQuickFix[]{parameterTypeFix});
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    @NotNull
    private static List<PsiMethod> getEventHandlerMethods(@NotNull XmlAttribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "getEventHandlerMethods"));
        }
        PsiClass controllerClass = JavaFxPsiUtil.getControllerClass(attribute.getContainingFile());
        if (controllerClass == null) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "getEventHandlerMethods"));
            }
            return list;
        }
        String valueText = attribute.getValue();
        if (valueText == null || !valueText.startsWith("#")) {
            List<PsiMethod> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "getEventHandlerMethods"));
            }
            return list;
        }
        String eventHandlerMethodName = valueText.substring(1);
        List<PsiMethod> list = Arrays.stream(controllerClass.findMethodsByName(eventHandlerMethodName, true)).filter(method -> !method.hasModifierProperty("static") && JavaFxPsiUtil.isVisibleInFxml((PsiMember)method)).filter(JavaFxEventHandlerInspection::hasEventArgument).collect(Collectors.toList());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "getEventHandlerMethods"));
        }
        return list;
    }

    private static boolean hasEventArgument(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "hasEventArgument"));
        }
        PsiParameter[] parameters = method.getParameterList().getParameters();
        return parameters.length == 0 || parameters.length == 1 && InheritanceUtil.isInheritor((PsiType)parameters[0].getType(), (String)"javafx.event.Event");
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return new SingleCheckboxOptionsPanel("Detect event handler method having non-void return type", (InspectionProfileEntry)this, "myDetectNonVoidReturnType");
    }

    private static void collectFieldTypeFixes(@NotNull XmlAttribute attribute, @NotNull PsiClassType eventType, @NotNull List<LocalQuickFix> quickFixes) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "collectFieldTypeFixes"));
        }
        if (eventType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventType", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "collectFieldTypeFixes"));
        }
        if (quickFixes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "quickFixes", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection", "collectFieldTypeFixes"));
        }
        XmlTag xmlTag = attribute.getParent();
        if (xmlTag == null) {
            return;
        }
        XmlAttribute idAttribute = xmlTag.getAttribute("fx:id");
        if (idAttribute == null) {
            return;
        }
        XmlAttributeValue idValue = idAttribute.getValueElement();
        if (idValue == null) {
            return;
        }
        PsiReference reference = idValue.getReference();
        if (reference == null) {
            return;
        }
        PsiElement element = reference.resolve();
        if (!(element instanceof PsiField)) {
            return;
        }
        PsiField tagField = (PsiField)element;
        if (tagField.hasModifierProperty("static") || !JavaFxPsiUtil.isVisibleInFxml((PsiMember)tagField)) {
            return;
        }
        PsiType tagFieldType = tagField.getType();
        if (!(tagFieldType instanceof PsiClassType)) {
            return;
        }
        PsiClassType rawFieldType = ((PsiClassType)tagFieldType).rawType();
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)eventType);
        PsiClass eventClass = resolveResult.getElement();
        if (eventClass == null) {
            return;
        }
        PsiSubstitutor eventSubstitutor = resolveResult.getSubstitutor();
        for (PsiTypeParameter typeParameter : PsiUtil.typeParametersIterable((PsiTypeParameterListOwner)eventClass)) {
            PsiType eventTypeArgument = eventSubstitutor.substitute(typeParameter);
            PsiClassType rawEventArgument = eventTypeArgument instanceof PsiClassType ? ((PsiClassType)eventTypeArgument).rawType() : null;
            if (!rawFieldType.equals((Object)rawEventArgument)) continue;
            List fixes = HighlightUtil.getChangeVariableTypeFixes((PsiVariable)tagField, (PsiType)eventTypeArgument);
            for (IntentionAction action : fixes) {
                if (!(action instanceof LocalQuickFix)) continue;
                quickFixes.add((LocalQuickFix)action);
            }
        }
    }

    private static class ChangeParameterTypeQuickFix
    extends LocalQuickFixOnPsiElement {
        final String myText;

        public ChangeParameterTypeQuickFix(@NotNull XmlAttribute attribute, @NotNull PsiMethod method, @NotNull PsiType suggestedParameterType) {
            if (attribute == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attribute", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "<init>"));
            }
            if (method == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "<init>"));
            }
            if (suggestedParameterType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suggestedParameterType", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "<init>"));
            }
            super((PsiElement)attribute);
            this.myText = "Change parameter type of '" + JavaHighlightUtil.formatMethod((PsiMethod)method) + "' to " + suggestedParameterType.getPresentableText();
        }

        public boolean startInWriteAction() {
            return false;
        }

        @NotNull
        public String getText() {
            String string = this.myText;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "getText"));
            }
            return string;
        }

        @Nls
        @NotNull
        public String getFamilyName() {
            if ("Change parameter type of event handler method" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "getFamilyName"));
            }
            return "Change parameter type of event handler method";
        }

        public boolean isAvailable(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "isAvailable"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "isAvailable"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "isAvailable"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "isAvailable"));
            }
            return startElement instanceof XmlAttribute;
        }

        public void invoke(@NotNull Project project, @NotNull PsiFile file, @NotNull PsiElement startElement, @NotNull PsiElement endElement) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "invoke"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "invoke"));
            }
            if (startElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startElement", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "invoke"));
            }
            if (endElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "endElement", "org/jetbrains/plugins/javaFX/fxml/codeInsight/inspections/JavaFxEventHandlerInspection$ChangeParameterTypeQuickFix", "invoke"));
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(file)) {
                return;
            }
            if (!(startElement instanceof XmlAttribute)) {
                return;
            }
            XmlAttribute attribute = (XmlAttribute)startElement;
            List eventHandlerMethods = JavaFxEventHandlerInspection.getEventHandlerMethods(attribute);
            if (eventHandlerMethods.size() != 1) {
                return;
            }
            PsiMethod method = (PsiMethod)eventHandlerMethods.get(0);
            PsiParameter[] parameters = method.getParameterList().getParameters();
            if (parameters.length != 1) {
                return;
            }
            String parameterName = parameters[0].getName();
            PsiClassType declaredType = JavaFxPsiUtil.getDeclaredEventType(attribute);
            if (declaredType == null) {
                return;
            }
            ParameterInfoImpl parameterInfo = new ParameterInfoImpl(0, parameterName, (PsiType)declaredType);
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                ChangeSignatureProcessor processor = new ChangeSignatureProcessor(project, method, false, null, method.getName(), method.getReturnType(), new ParameterInfoImpl[]{parameterInfo});
                processor.run();
            } else {
                List<ParameterInfoImpl> parameterInfos = Collections.singletonList(parameterInfo);
                JavaChangeSignatureDialog dialog = JavaChangeSignatureDialog.createAndPreselectNew((Project)project, (PsiMethod)method, parameterInfos, (boolean)false, null);
                dialog.setParameterInfos(parameterInfos);
                dialog.show();
            }
        }
    }
}

