/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.windows;

import com.pty4j.windows.NamedPipe;
import com.pty4j.windows.WinPty;
import java.io.IOException;
import java.io.OutputStream;

public class WinPTYOutputStream
extends OutputStream {
    private final WinPty myWinPty;
    private final NamedPipe myNamedPipe;
    private final boolean myPatchNewline;
    private final boolean mySendEOF;

    public WinPTYOutputStream(WinPty winPty, NamedPipe namedPipe, boolean patchNewline, boolean sendEOF) {
        this.myWinPty = winPty;
        this.myNamedPipe = namedPipe;
        this.myPatchNewline = patchNewline;
        this.mySendEOF = sendEOF;
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.myPatchNewline) {
            byte[] newBuf = new byte[len];
            int newPos = 0;
            for (int i = off; i < off + len; ++i) {
                newBuf[newPos++] = b[i] == 10 ? 13 : b[i];
            }
            b = newBuf;
            off = 0;
            len = newPos;
        }
        this.myNamedPipe.write(b, off, len);
    }

    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)b};
        this.write(buf, 0, 1);
    }

    public void close() throws IOException {
        if (this.mySendEOF) {
            this.write(new byte[]{94, 90, 10});
        }
        this.myNamedPipe.close();
    }
}

