/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.HashMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.yaml.YAMLTokenTypes;
import org.jetbrains.yaml.YAMLUtil;
import org.jetbrains.yaml.lexer.YAMLGrammarCharUtil;
import org.jetbrains.yaml.psi.YAMLQuotedText;
import org.jetbrains.yaml.psi.impl.YAMLScalarImpl;

public class YAMLQuotedTextImpl
extends YAMLScalarImpl
implements YAMLQuotedText {
    private final boolean myIsSingleQuoted;

    public YAMLQuotedTextImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "<init>"));
        }
        super(node);
        this.myIsSingleQuoted = this.getNode().getFirstChildNode().getElementType() == YAMLTokenTypes.SCALAR_STRING;
    }

    @Override
    @NotNull
    public List<TextRange> getContentRanges() {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        List lines = StringUtil.split((String)this.getText(), (String)"\n", (boolean)true, (boolean)false);
        int cumulativeOffset = 0;
        for (int i = 0; i < lines.size(); ++i) {
            int lineStart;
            String line = (String)lines.get(i);
            int lineEnd = line.length();
            if (i == 0) {
                ++lineStart;
            } else {
                for (lineStart = 0; lineStart < line.length() && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineStart)); ++lineStart) {
                }
            }
            if (i == lines.size() - 1) {
                --lineEnd;
            } else {
                while (lineEnd > lineStart && YAMLGrammarCharUtil.isSpaceLike(line.charAt(lineEnd - 1))) {
                    --lineEnd;
                }
            }
            result.add(TextRange.create((int)lineStart, (int)lineEnd).shiftRight(cumulativeOffset));
            cumulativeOffset += line.length() + 1;
        }
        ArrayList<TextRange> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getContentRanges"));
        }
        return arrayList;
    }

    @Override
    @NotNull
    protected String getRangesJoiner(@NotNull CharSequence text, @NotNull List<TextRange> contentRanges, int indexBefore) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
        }
        if (contentRanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "contentRanges", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
        }
        TextRange leftRange = contentRanges.get(indexBefore);
        if (leftRange.isEmpty() || !this.isSingleQuote() && text.charAt(leftRange.getEndOffset() - 1) == '\\') {
            if ("\n" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
            }
            return "\n";
        }
        if (contentRanges.get(indexBefore + 1).isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
            }
            return "";
        }
        if (" " == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getRangesJoiner"));
        }
        return " ";
    }

    @Override
    protected List<Pair<TextRange, String>> getDecodeReplacements(@NotNull CharSequence input) {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getDecodeReplacements"));
        }
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int i = 0;
        while (i + 1 < input.length()) {
            if (this.isSingleQuote() && input.charAt(i) == '\'' && input.charAt(i + 1) == '\'') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)2), (Object)"'"));
                ++i;
            } else if (!this.isSingleQuote() && input.charAt(i) == '\\') {
                if (input.charAt(i + 1) == '\n') {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)2), (Object)""));
                    ++i;
                } else {
                    int length = Escaper.findEscapementLength(input, i);
                    int charCode = Escaper.toUnicodeChar(input, i, length);
                    TextRange range = TextRange.create((int)i, (int)Math.min(i + length + 1, input.length()));
                    result.add((Pair<TextRange, String>)Pair.create((Object)range, (Object)Character.toString((char)charCode)));
                    i += range.getLength() - 1;
                }
            }
            ++i;
        }
        return result;
    }

    @Override
    protected List<Pair<TextRange, String>> getEncodeReplacements(@NotNull CharSequence input) throws IllegalArgumentException {
        if (input == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "input", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl", "getEncodeReplacements"));
        }
        if (this.isSingleQuote()) {
            for (int i = 0; i < input.length(); ++i) {
                if (input.charAt(i) != '\n' || YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i)) continue;
                throw new IllegalArgumentException("Newlines with spaces around are not convertible");
            }
        }
        int indent = YAMLUtil.getIndentToThisElement((PsiElement)this);
        String indentString = StringUtil.repeatSymbol((char)' ', (int)indent);
        ArrayList<Pair<TextRange, String>> result = new ArrayList<Pair<TextRange, String>>();
        int currentLength = 0;
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (c == '\n') {
                if (!this.isSingleQuote() && i + 1 < input.length() && YAMLGrammarCharUtil.isSpaceLike(input.charAt(i + 1))) {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\\n\\\n" + indentString + "\\")));
                } else if (!this.isSingleQuote() && i + 1 < input.length() && input.charAt(i + 1) == '\n') {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\\\n" + indentString + "\\n")));
                } else {
                    result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)("\n\n" + indentString)));
                }
                currentLength = 0;
                continue;
            }
            if (currentLength > 60 && (!this.isSingleQuote() || c == ' ' && YAMLQuotedTextImpl.isSurroundedByNoSpace(input, i))) {
                String replacement = this.isSingleQuote() ? "\n" + indentString : (YAMLGrammarCharUtil.isSpaceLike(c) ? "\\\n" + indentString + "\\" : "\\\n" + indentString);
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)(this.isSingleQuote() ? 1 : 0)), (Object)replacement));
                currentLength = 0;
            }
            ++currentLength;
            if (this.isSingleQuote() && c == '\'') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"''"));
                continue;
            }
            if (this.isSingleQuote()) continue;
            if (c == '\"') {
                result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"\\\""));
                continue;
            }
            if (c != '\\') continue;
            result.add((Pair<TextRange, String>)Pair.create((Object)TextRange.from((int)i, (int)1), (Object)"\\\\"));
        }
        return result;
    }

    @Override
    public boolean isMultiline() {
        return this.textContains('\n');
    }

    @Override
    public boolean isSingleQuote() {
        return this.myIsSingleQuoted;
    }

    @Override
    public String toString() {
        return "YAML quoted text";
    }

    private static class Escaper {
        private static final int[][] ONE_LETTER_CONVERSIONS = new int[][]{{48, 0}, {97, 7}, {98, 8}, {116, 9}, {9, 9}, {110, 10}, {118, 11}, {102, 12}, {114, 13}, {101, 27}, {32, 32}, {34, 34}, {47, 47}, {92, 92}, {78, 133}, {95, 160}, {76, 8232}, {80, 8233}};
        private static final NotNullLazyValue<Map<Integer, Integer>> ESC_TO_CODE = new NotNullLazyValue<Map<Integer, Integer>>(){

            @NotNull
            protected Map<Integer, Integer> compute() {
                HashMap map = new HashMap(ONE_LETTER_CONVERSIONS.length);
                for (int[] conversion : ONE_LETTER_CONVERSIONS) {
                    map.put((Object)conversion[0], (Object)conversion[1]);
                }
                HashMap hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl$Escaper$1", "compute"));
                }
                return hashMap;
            }
        };
        private static final NotNullLazyValue<Map<Integer, Integer>> CODE_TO_ESC = new NotNullLazyValue<Map<Integer, Integer>>(){

            @NotNull
            protected Map<Integer, Integer> compute() {
                HashMap map = new HashMap(ONE_LETTER_CONVERSIONS.length);
                for (int[] conversion : ONE_LETTER_CONVERSIONS) {
                    map.put((Object)conversion[1], (Object)conversion[2]);
                }
                HashMap hashMap = map;
                if (hashMap == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl$Escaper$2", "compute"));
                }
                return hashMap;
            }
        };

        private Escaper() {
        }

        static int findEscapementLength(@NotNull CharSequence text, int pos) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl$Escaper", "findEscapementLength"));
            }
            if (pos + 1 >= text.length() || text.charAt(pos) != '\\') {
                throw new IllegalArgumentException("This is not an escapement start");
            }
            char c = text.charAt(pos + 1);
            if (c == 'x') {
                return 3;
            }
            if (c == 'u') {
                return 5;
            }
            if (c == 'U') {
                return 9;
            }
            return 1;
        }

        static int toUnicodeChar(@NotNull CharSequence text, int pos, int length) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/yaml/psi/impl/YAMLQuotedTextImpl$Escaper", "toUnicodeChar"));
            }
            if (length > 1) {
                CharSequence s = text.subSequence(pos + 2, Math.min(text.length(), pos + length + 1));
                try {
                    return Integer.parseInt(s.toString(), 16);
                }
                catch (NumberFormatException e) {
                    return 63;
                }
            }
            Integer result = (Integer)((Map)ESC_TO_CODE.getValue()).get(text.charAt(pos + 1));
            return (Integer)ObjectUtils.notNull((Object)result, (Object)text.charAt(pos + 1));
        }
    }
}

