/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.yaml.folding;

import com.intellij.lang.ASTNode;
import com.intellij.lang.folding.FoldingBuilderEx;
import com.intellij.lang.folding.FoldingDescriptor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.LinkedList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.yaml.psi.YAMLCompoundValue;
import org.jetbrains.yaml.psi.YAMLDocument;
import org.jetbrains.yaml.psi.YAMLKeyValue;
import org.jetbrains.yaml.psi.YAMLMapping;
import org.jetbrains.yaml.psi.YAMLScalar;
import org.jetbrains.yaml.psi.YAMLSequence;
import org.jetbrains.yaml.psi.impl.YAMLArrayImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockMappingImpl;
import org.jetbrains.yaml.psi.impl.YAMLBlockSequenceImpl;
import org.jetbrains.yaml.psi.impl.YAMLHashImpl;

public class YAMLFoldingBuilder
extends FoldingBuilderEx
implements DumbAware {
    private static final int PLACEHOLDER_LEN = 20;

    @NotNull
    public FoldingDescriptor[] buildFoldRegions(@NotNull PsiElement root, @NotNull Document document, boolean quick) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "buildFoldRegions"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "buildFoldRegions"));
        }
        LinkedList<FoldingDescriptor> descriptors = new LinkedList<FoldingDescriptor>();
        YAMLFoldingBuilder.collectDescriptors(root, descriptors);
        FoldingDescriptor[] foldingDescriptorArray = descriptors.toArray(new FoldingDescriptor[descriptors.size()]);
        if (foldingDescriptorArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "buildFoldRegions"));
        }
        return foldingDescriptorArray;
    }

    private static void collectDescriptors(@NotNull PsiElement element, @NotNull List<FoldingDescriptor> descriptors) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "collectDescriptors"));
        }
        if (descriptors == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptors", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "collectDescriptors"));
        }
        TextRange nodeTextRange = element.getTextRange();
        if (nodeTextRange.getLength() < 2) {
            return;
        }
        if (element instanceof YAMLDocument) {
            if (PsiTreeUtil.findChildrenOfAnyType((PsiElement)element.getParent(), (Class[])new Class[]{YAMLDocument.class}).size() > 1) {
                descriptors.add(new FoldingDescriptor(element, nodeTextRange));
            }
        } else if (element instanceof YAMLScalar || element instanceof YAMLKeyValue && ((YAMLKeyValue)element).getValue() instanceof YAMLCompoundValue) {
            descriptors.add(new FoldingDescriptor(element, nodeTextRange));
        }
        for (PsiElement child : element.getChildren()) {
            YAMLFoldingBuilder.collectDescriptors(child, descriptors);
        }
    }

    @Nullable
    public String getPlaceholderText(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
        }
        return YAMLFoldingBuilder.getPlaceholderText(SourceTreeToPsiMap.treeElementToPsi((ASTNode)node));
    }

    @NotNull
    private static String getPlaceholderText(@Nullable PsiElement psiElement) {
        if (psiElement instanceof YAMLDocument) {
            if ("---" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
            }
            return "---";
        }
        if (psiElement instanceof YAMLScalar) {
            String string = YAMLFoldingBuilder.normalizePlaceHolderText(((YAMLScalar)psiElement).getTextValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
            }
            return string;
        }
        if (psiElement instanceof YAMLSequence) {
            int size = ((YAMLSequence)psiElement).getItems().size();
            String placeholder = size + " " + StringUtil.pluralize((String)"item", (int)size);
            if (psiElement instanceof YAMLArrayImpl) {
                String string = "[" + placeholder + "]";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
                }
                return string;
            }
            if (psiElement instanceof YAMLBlockSequenceImpl) {
                String string = "<" + placeholder + ">";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
                }
                return string;
            }
        } else if (psiElement instanceof YAMLMapping) {
            int size = ((YAMLMapping)psiElement).getKeyValues().size();
            String placeholder = size + " " + StringUtil.pluralize((String)"key", (int)size);
            if (psiElement instanceof YAMLHashImpl) {
                String string = "{" + placeholder + "}";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
                }
                return string;
            }
            if (psiElement instanceof YAMLBlockMappingImpl) {
                String string = "<" + placeholder + ">";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
                }
                return string;
            }
        } else if (psiElement instanceof YAMLKeyValue) {
            String string = YAMLFoldingBuilder.normalizePlaceHolderText(((YAMLKeyValue)psiElement).getKeyText()) + ": " + YAMLFoldingBuilder.getPlaceholderText((PsiElement)((YAMLKeyValue)psiElement).getValue());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
            }
            return string;
        }
        if ("..." == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "getPlaceholderText"));
        }
        return "...";
    }

    public boolean isCollapsedByDefault(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/yaml/folding/YAMLFoldingBuilder", "isCollapsedByDefault"));
        }
        return false;
    }

    private static String normalizePlaceHolderText(@Nullable String text) {
        if (text == null) {
            return null;
        }
        if (text.length() <= 20) {
            return text;
        }
        return StringUtil.trimMiddle((String)text, (int)20);
    }
}

