/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0017\u0018\u00002\u00020\u0001BA\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\u0010\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020\nH\u0002J\u0006\u0010+\u001a\u00020\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0017\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\f\n\u0004\b\u0012\u0010\u0013\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u001aR\u0011\u0010\u000b\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001aR(\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\b@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u0011\"\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u0011R\u0017\u0010\"\u001a\u00020\b8F\u00a2\u0006\f\n\u0004\b$\u0010\u0013\u001a\u0004\b#\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u000eR\u0019\u0010&\u001a\u0004\u0018\u00010\b8F\u00a2\u0006\f\n\u0004\b(\u0010\u0013\u001a\u0004\b'\u0010\u0011\u00a8\u0006,"}, d2={"Lorg/jetbrains/builtInWebServer/PathInfo;", "", "ioFile", "Ljava/nio/file/Path;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "root", "moduleName", "", "isLibrary", "", "isRootNameOptionalInPath", "(Ljava/nio/file/Path;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/openapi/vfs/VirtualFile;Ljava/lang/String;ZZ)V", "getFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "filePath", "getFilePath", "()Ljava/lang/String;", "filePath$delegate", "Lkotlin/Lazy;", "fileType", "Lcom/intellij/openapi/fileTypes/FileType;", "getFileType", "()Lcom/intellij/openapi/fileTypes/FileType;", "getIoFile", "()Ljava/nio/file/Path;", "()Z", "isValid", "<set-?>", "getModuleName", "setModuleName", "(Ljava/lang/String;)V", "name", "getName", "path", "getPath", "path$delegate", "getRoot", "rootLessPathIfPossible", "getRootLessPathIfPossible", "rootLessPathIfPossible$delegate", "buildPath", "useRootName", "isDirectory", "built-in-server-api"})
public final class PathInfo {
    @Nullable
    private String moduleName;
    @NotNull
    private final Lazy path$delegate;
    @Nullable
    private final Lazy rootLessPathIfPossible$delegate;
    @NotNull
    private final Lazy filePath$delegate;
    @Nullable
    private final Path ioFile;
    @Nullable
    private final VirtualFile file;
    @NotNull
    private final VirtualFile root;
    private final boolean isLibrary;
    private final boolean isRootNameOptionalInPath;
    private static final /* synthetic */ KProperty[] $$delegatedProperties;

    @Nullable
    public final String getModuleName() {
        return this.moduleName;
    }

    public final void setModuleName(@Nullable String string) {
        this.moduleName = string;
    }

    @NotNull
    public final String getPath() {
        Lazy lazy = this.path$delegate;
        PathInfo pathInfo = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (String)lazy.getValue();
    }

    @Nullable
    public final String getRootLessPathIfPossible() {
        Lazy lazy = this.rootLessPathIfPossible$delegate;
        PathInfo pathInfo = this;
        KProperty kProperty = $$delegatedProperties[1];
        return (String)lazy.getValue();
    }

    private final String buildPath(boolean useRootName) {
        VirtualFile relativeTo;
        VirtualFile virtualFile;
        StringBuilder builder = new StringBuilder();
        if (this.moduleName != null) {
            builder.append(this.moduleName).append('/');
        }
        if (this.isLibrary) {
            builder.append(this.root.getName()).append('/');
        }
        if (useRootName) {
            virtualFile = this.root;
        } else {
            virtualFile = this.root.getParent();
            if (virtualFile == null) {
                virtualFile = relativeTo = this.root;
            }
        }
        if (this.file == null) {
            String string = relativeTo.getPath();
            Path path2 = this.ioFile;
            if (path2 == null) {
                Intrinsics.throwNpe();
            }
            builder.append(FileUtilRt.getRelativePath((String)string, (String)StringsKt.replace$default((String)((Object)path2).toString(), (char)File.separatorChar, (char)'/', (boolean)false, (int)4, null), (char)'/'));
        } else {
            builder.append(VfsUtilCore.getRelativePath(this.file, relativeTo, '/'));
        }
        String string = builder.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final String getFilePath() {
        Lazy lazy = this.filePath$delegate;
        PathInfo pathInfo = this;
        KProperty kProperty = $$delegatedProperties[2];
        return (String)lazy.getValue();
    }

    public final boolean isValid() {
        boolean bl;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            bl = virtualFile.isValid();
        } else {
            bl = Files.exists(this.ioFile, new LinkOption[0]);
        }
        return bl;
    }

    @NotNull
    public final String getName() {
        String string;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            String string2 = virtualFile.getName();
            string = string2;
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"file!!.name");
        } else {
            string = ((Object)this.ioFile.getFileName()).toString();
        }
        return string;
    }

    @NotNull
    public final FileType getFileType() {
        FileType fileType;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            FileType fileType2 = virtualFile.getFileType();
            fileType = fileType2;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType2, (String)"file!!.fileType");
        } else {
            FileType fileType3 = FileTypeManager.getInstance().getFileTypeByFileName(((Object)this.ioFile.getFileName()).toString());
            fileType = fileType3;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileType3, (String)"FileTypeManager.getInsta\u2026File.fileName.toString())");
        }
        return fileType;
    }

    public final boolean isDirectory() {
        boolean bl;
        if (this.ioFile == null) {
            VirtualFile virtualFile = this.file;
            if (virtualFile == null) {
                Intrinsics.throwNpe();
            }
            bl = virtualFile.isDirectory();
        } else {
            bl = Files.isDirectory(this.ioFile, new LinkOption[0]);
        }
        return bl;
    }

    @Nullable
    public final Path getIoFile() {
        return this.ioFile;
    }

    @Nullable
    public final VirtualFile getFile() {
        return this.file;
    }

    @NotNull
    public final VirtualFile getRoot() {
        return this.root;
    }

    public final boolean isLibrary() {
        return this.isLibrary;
    }

    public final boolean isRootNameOptionalInPath() {
        return this.isRootNameOptionalInPath;
    }

    public PathInfo(@Nullable Path ioFile, @Nullable VirtualFile file, @NotNull VirtualFile root, @Nullable String moduleName, boolean isLibrary, boolean isRootNameOptionalInPath) {
        Intrinsics.checkParameterIsNotNull((Object)root, (String)"root");
        this.ioFile = ioFile;
        this.file = file;
        this.root = root;
        this.isLibrary = isLibrary;
        this.isRootNameOptionalInPath = isRootNameOptionalInPath;
        this.moduleName = moduleName;
        this.path$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PathInfo this$0;

            @NotNull
            public final String invoke() {
                return PathInfo.access$buildPath(this.this$0, true);
            }
            {
                this.this$0 = pathInfo;
                super(0);
            }
        }));
        this.rootLessPathIfPossible$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PathInfo this$0;

            @Nullable
            public final String invoke() {
                return this.this$0.isRootNameOptionalInPath() ? PathInfo.access$buildPath(this.this$0, false) : (String)null;
            }
            {
                this.this$0 = pathInfo;
                super(0);
            }
        }));
        this.filePath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<String>(this){
            final /* synthetic */ PathInfo this$0;

            @NotNull
            public final String invoke() {
                String string;
                if (this.this$0.getIoFile() == null) {
                    VirtualFile virtualFile = this.this$0.getFile();
                    if (virtualFile == null) {
                        Intrinsics.throwNpe();
                    }
                    string = FileUtilRt.toSystemDependentName((String)virtualFile.getPath());
                } else {
                    string = ((Object)this.this$0.getIoFile()).toString();
                }
                return string;
            }
            {
                this.this$0 = pathInfo;
                super(0);
            }
        }));
    }

    public /* synthetic */ PathInfo(Path path2, VirtualFile virtualFile, VirtualFile virtualFile2, String string, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            bl = false;
        }
        if ((n & 0x20) != 0) {
            bl2 = false;
        }
        this(path2, virtualFile, virtualFile2, string, bl, bl2);
    }

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PathInfo.class), "path", "getPath()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PathInfo.class), "rootLessPathIfPossible", "getRootLessPathIfPossible()Ljava/lang/String;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(PathInfo.class), "filePath", "getFilePath()Ljava/lang/String;"))};
    }

    @NotNull
    public static final /* synthetic */ String access$buildPath(PathInfo $this, boolean useRootName) {
        return $this.buildPath(useRootName);
    }
}

