/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import java.nio.ByteBuffer;
import java.security.Key;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=2, d1={"\u0000\u001a\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\u001a\u0018\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a \u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0006\u0010\t\u001a\u00020\u0001\u00a8\u0006\n"}, d2={"decrypt", "", "data", "key", "Ljava/security/Key;", "encrypt", "message", "size", "", "generateAesKey", "platform-api"})
public final class EncryptionSupportKt {
    @NotNull
    public static final byte[] generateAesKey() {
        byte[] bytes = new byte[16];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    private static final byte[] encrypt(byte[] message, int size, Key key) {
        Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
        cipher.init(1, key);
        byte[] body = cipher.doFinal(message, 0, size);
        byte[] iv = cipher.getIV();
        ByteBuffer byteBuffer = ByteBuffer.wrap(new byte[4 + iv.length + body.length]);
        byteBuffer.putInt(iv.length);
        byteBuffer.put(iv);
        byteBuffer.put(body);
        byte[] byArray = byteBuffer.array();
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"byteBuffer.array()");
        return byArray;
    }

    private static final byte[] decrypt(byte[] data, Key key) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(data);
        int ivLength = byteBuffer.getInt();
        Cipher ciph = Cipher.getInstance("AES/CBC/PKCS5Padding");
        ciph.init(2, key, new IvParameterSpec(data, byteBuffer.position(), ivLength));
        int dataOffset = byteBuffer.position() + ivLength;
        byte[] byArray = ciph.doFinal(data, dataOffset, data.length - dataOffset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"ciph.doFinal(data, dataO\u2026, data.size - dataOffset)");
        return byArray;
    }

    @NotNull
    public static final /* synthetic */ byte[] access$encrypt(@NotNull byte[] message, int size, @NotNull Key key) {
        return EncryptionSupportKt.encrypt(message, size, key);
    }

    @NotNull
    public static final /* synthetic */ byte[] access$decrypt(@NotNull byte[] data, @NotNull Key key) {
        return EncryptionSupportKt.decrypt(data, key);
    }
}

