/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class TodoAttributes
implements Cloneable {
    private Icon myIcon;
    private TextAttributes myTextAttributes;
    private boolean myShouldUseCustomColors;
    @NonNls
    private static final String ATTRIBUTE_ICON = "icon";
    @NonNls
    private static final String ICON_DEFAULT = "default";
    @NonNls
    private static final String ICON_QUESTION = "question";
    @NonNls
    private static final String ICON_IMPORTANT = "important";
    @NonNls
    private static final String ELEMENT_OPTION = "option";
    @NonNls
    private static final String USE_CUSTOM_COLORS_ATT = "useCustomColors";

    public TodoAttributes(@NotNull Element element, @NotNull TextAttributes defaultTodoAttributes) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/TodoAttributes", "<init>"));
        }
        if (defaultTodoAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTodoAttributes", "com/intellij/psi/search/TodoAttributes", "<init>"));
        }
        String icon = element.getAttributeValue(ATTRIBUTE_ICON, ICON_DEFAULT);
        if (ICON_DEFAULT.equals(icon)) {
            this.myIcon = AllIcons.General.TodoDefault;
        } else if (ICON_QUESTION.equals(icon)) {
            this.myIcon = AllIcons.General.TodoQuestion;
        } else if (ICON_IMPORTANT.equals(icon)) {
            this.myIcon = AllIcons.General.TodoImportant;
        } else {
            throw new InvalidDataException(icon);
        }
        this.myShouldUseCustomColors = Boolean.parseBoolean(element.getAttributeValue(USE_CUSTOM_COLORS_ATT));
        this.myTextAttributes = this.myShouldUseCustomColors && element.getChild(ELEMENT_OPTION) != null ? new TextAttributes(element) : defaultTodoAttributes;
    }

    TodoAttributes(@NotNull Icon icon, @NotNull TextAttributes textAttributes) {
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", ATTRIBUTE_ICON, "com/intellij/psi/search/TodoAttributes", "<init>"));
        }
        if (textAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textAttributes", "com/intellij/psi/search/TodoAttributes", "<init>"));
        }
        this.myIcon = icon;
        this.myTextAttributes = textAttributes;
    }

    public Icon getIcon() {
        return this.myIcon;
    }

    @NotNull
    public TextAttributes getTextAttributes() {
        TextAttributes textAttributes = this.getCustomizedTextAttributes();
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/TodoAttributes", "getTextAttributes"));
        }
        return textAttributes;
    }

    @NotNull
    public TextAttributes getCustomizedTextAttributes() {
        TextAttributes textAttributes = this.myTextAttributes;
        if (textAttributes == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/TodoAttributes", "getCustomizedTextAttributes"));
        }
        return textAttributes;
    }

    public void setIcon(Icon icon) {
        this.myIcon = icon;
    }

    public void writeExternal(@NotNull Element element) {
        String icon;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/search/TodoAttributes", "writeExternal"));
        }
        if (this.myIcon == AllIcons.General.TodoDefault) {
            icon = ICON_DEFAULT;
        } else if (this.myIcon == AllIcons.General.TodoQuestion) {
            icon = ICON_QUESTION;
        } else if (this.myIcon == AllIcons.General.TodoImportant) {
            icon = ICON_IMPORTANT;
        } else {
            throw new WriteExternalException("");
        }
        if (!icon.equals(ICON_DEFAULT)) {
            element.setAttribute(ATTRIBUTE_ICON, icon);
        }
        if (this.shouldUseCustomTodoColor()) {
            this.myTextAttributes.writeExternal(element);
            element.setAttribute(USE_CUSTOM_COLORS_ATT, "true");
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TodoAttributes)) {
            return false;
        }
        TodoAttributes attributes = (TodoAttributes)o;
        return this.myIcon == attributes.myIcon && !(this.myTextAttributes == null ? attributes.myTextAttributes != null : !this.myTextAttributes.equals(attributes.myTextAttributes)) && this.myShouldUseCustomColors == attributes.myShouldUseCustomColors;
    }

    public int hashCode() {
        int result = this.myIcon != null ? this.myIcon.hashCode() : 0;
        result = 29 * result + (this.myTextAttributes != null ? this.myTextAttributes.hashCode() : 0);
        result = 29 * result + Boolean.valueOf(this.myShouldUseCustomColors).hashCode();
        return result;
    }

    public boolean shouldUseCustomTodoColor() {
        return this.myShouldUseCustomColors;
    }

    public void setUseCustomTodoColor(boolean useCustomColors, @NotNull TextAttributes defaultTodoAttributes) {
        if (defaultTodoAttributes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "defaultTodoAttributes", "com/intellij/psi/search/TodoAttributes", "setUseCustomTodoColor"));
        }
        this.myShouldUseCustomColors = useCustomColors;
        if (!useCustomColors) {
            this.myTextAttributes = defaultTodoAttributes;
        }
    }

    public TodoAttributes clone() {
        try {
            TextAttributes textAttributes = this.myTextAttributes.clone();
            TodoAttributes attributes = (TodoAttributes)super.clone();
            attributes.myTextAttributes = textAttributes;
            attributes.myShouldUseCustomColors = this.myShouldUseCustomColors;
            return attributes;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

