/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.extractor.values;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.codeStyle.extractor.Utils;
import com.intellij.psi.codeStyle.extractor.differ.Differ;
import com.intellij.psi.codeStyle.extractor.values.Gens;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class Generation {
    private static int GENERATION_POOL_SIZE = 45;
    private static int MUTATION_PER_GEN = 10;
    public static int GEN_COUNT = 40;
    private List<Gens> myGensPool;
    private int myAge;
    private int myParentKind;

    private Generation(@NotNull Gens bestGens) {
        if (bestGens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bestGens", "com/intellij/psi/codeStyle/extractor/values/Generation", "<init>"));
        }
        this.myParentKind = -1;
        this.myGensPool = new ArrayList<Gens>(GENERATION_POOL_SIZE);
        for (int i = 0; i < GENERATION_POOL_SIZE; ++i) {
            this.myGensPool.add(new Gens(bestGens).mutate(i == 0 ? 0 : MUTATION_PER_GEN));
        }
        this.myAge = 0;
    }

    private Generation(@NotNull Generation previous, int parentKind) {
        if (previous == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previous", "com/intellij/psi/codeStyle/extractor/values/Generation", "<init>"));
        }
        this.myAge = previous.myAge + 1;
        this.myParentKind = parentKind;
        this.myGensPool = new ArrayList<Gens>(GENERATION_POOL_SIZE);
        int mutationsCount = MUTATION_PER_GEN;
        int prevPullSize = previous.myGensPool.size();
        for (int i = 0; i < GENERATION_POOL_SIZE; ++i) {
            int parent1 = 0;
            int parent2 = 0;
            int iterations = 0;
            while (parent1 == parent2) {
                parent1 = Utils.getRandomLess(prevPullSize);
                parent2 = Utils.getRandomLess(prevPullSize);
                if (++iterations <= 25) continue;
            }
            this.myGensPool.add(Gens.breed(previous.myGensPool.get(parent1), previous.myGensPool.get(parent2), mutationsCount));
        }
    }

    public static Generation createZeroGeneration(@NotNull Gens gens) {
        if (gens == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gens", "com/intellij/psi/codeStyle/extractor/values/Generation", "createZeroGeneration"));
        }
        return new Generation(gens);
    }

    public static Generation createNextGeneration(Differ differ, @NotNull Generation previous) {
        if (previous == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "previous", "com/intellij/psi/codeStyle/extractor/values/Generation", "createNextGeneration"));
        }
        int parentKind = previous.reduceToSize(differ, (int)(0.2 * (double)previous.myGensPool.size()));
        return previous.tryAgain() ? new Generation(previous, parentKind) : previous;
    }

    private int reduceToSize(Differ differ, int newPoolSize) {
        ArrayList<Pair> ranges = new ArrayList<Pair>(this.myGensPool.size());
        int i = 0;
        for (Gens gens : this.myGensPool) {
            int range = differ.getDifference(gens);
            ranges.add(Pair.create((Object)range, (Object)i++));
            if (range != 0) continue;
            this.myAge = GEN_COUNT;
            newPoolSize = 1;
            break;
        }
        Collections.sort(ranges, (o1, o2) -> (Integer)o1.first - (Integer)o2.first);
        ArrayList<Gens> gensPool = new ArrayList<Gens>(newPoolSize);
        int count = 0;
        int worseForward = 0;
        for (Pair pair : ranges) {
            if (count >= newPoolSize) break;
            Gens gens = this.myGensPool.get((Integer)pair.second);
            gensPool.add(gens);
            ++count;
            worseForward = (Integer)pair.first;
        }
        this.myGensPool = gensPool;
        return worseForward;
    }

    public boolean tryAgain() {
        return this.myAge < GEN_COUNT;
    }

    public Gens getBestGens(Differ differ) {
        this.reduceToSize(differ, 1);
        return this.myGensPool.get(0);
    }

    public int getAge() {
        return this.myAge;
    }

    public int getParentKind() {
        return this.myParentKind;
    }
}

