/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.wm;

import com.intellij.ide.ui.UISettings;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class ToolWindowAnchor {
    public static final ToolWindowAnchor TOP = new ToolWindowAnchor("top");
    public static final ToolWindowAnchor LEFT = new ToolWindowAnchor("left");
    public static final ToolWindowAnchor BOTTOM = new ToolWindowAnchor("bottom");
    public static final ToolWindowAnchor RIGHT = new ToolWindowAnchor("right");
    @NotNull
    private final String myText;

    private ToolWindowAnchor(@NonNls @NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/openapi/wm/ToolWindowAnchor", "<init>"));
        }
        this.myText = text;
    }

    public String toString() {
        return this.myText;
    }

    public boolean isHorizontal() {
        return this == TOP || this == BOTTOM;
    }

    @NotNull
    public static ToolWindowAnchor get(int swingOrientationConstant) {
        switch (swingOrientationConstant) {
            case 1: {
                ToolWindowAnchor toolWindowAnchor = TOP;
                if (toolWindowAnchor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/ToolWindowAnchor", "get"));
                }
                return toolWindowAnchor;
            }
            case 3: {
                ToolWindowAnchor toolWindowAnchor = BOTTOM;
                if (toolWindowAnchor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/ToolWindowAnchor", "get"));
                }
                return toolWindowAnchor;
            }
            case 2: {
                ToolWindowAnchor toolWindowAnchor = LEFT;
                if (toolWindowAnchor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/ToolWindowAnchor", "get"));
                }
                return toolWindowAnchor;
            }
            case 4: {
                ToolWindowAnchor toolWindowAnchor = RIGHT;
                if (toolWindowAnchor == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/ToolWindowAnchor", "get"));
                }
                return toolWindowAnchor;
            }
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + swingOrientationConstant);
    }

    public boolean isSplitVertically() {
        return this == LEFT && !UISettings.getInstance().LEFT_HORIZONTAL_SPLIT || this == RIGHT && !UISettings.getInstance().RIGHT_HORIZONTAL_SPLIT;
    }

    @NotNull
    public static ToolWindowAnchor fromText(String anchor) {
        for (ToolWindowAnchor a : new ToolWindowAnchor[]{TOP, LEFT, BOTTOM, RIGHT}) {
            if (!a.myText.equals(anchor)) continue;
            ToolWindowAnchor toolWindowAnchor = a;
            if (toolWindowAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/wm/ToolWindowAnchor", "fromText"));
            }
            return toolWindowAnchor;
        }
        throw new IllegalArgumentException("Unknown anchor constant: " + anchor);
    }
}

