/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.util;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PasswordUtil {
    private PasswordUtil() {
    }

    public static String encodePassword(@Nullable String password) {
        String result = "";
        if (password == null) {
            return result;
        }
        for (int i = 0; i < password.length(); ++i) {
            result = result + Integer.toHexString(password.charAt(i) ^ 0xDFAA);
        }
        return result;
    }

    public static String encodePassword(@Nullable char[] password) {
        String result = "";
        if (password == null) {
            return result;
        }
        for (char c : password) {
            result = result + Integer.toHexString(c ^ 0xDFAA);
        }
        return result;
    }

    public static String decodePassword(@Nullable String password) throws NumberFormatException {
        return password == null ? "" : new String(PasswordUtil.decodePasswordAsCharArray(password));
    }

    @NotNull
    public static char[] decodePasswordAsCharArray(@Nullable String password) throws NumberFormatException {
        if (StringUtil.isEmpty((String)password)) {
            if (ArrayUtil.EMPTY_CHAR_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/PasswordUtil", "decodePasswordAsCharArray"));
            }
            return ArrayUtil.EMPTY_CHAR_ARRAY;
        }
        char[] result = new char[password.length() / 4];
        int i = 0;
        int j = 0;
        while (i < password.length()) {
            int c = Integer.parseInt(password.substring(i, i + 4), 16);
            result[j] = new Character((char)(c ^= 0xDFAA)).charValue();
            i += 4;
            ++j;
        }
        if (result == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/util/PasswordUtil", "decodePasswordAsCharArray"));
        }
        return result;
    }
}

