/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.DefaultListModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.intellij.lang.annotations.JdkConstants;
import org.jetbrains.annotations.NotNull;

public class SelectFromListDialog
extends DialogWrapper {
    private final ToStringAspect myToStringAspect;
    private final DefaultListModel myModel = new DefaultListModel();
    private final JList myList = new JBList((ListModel)this.myModel);
    private final JPanel myMainPanel = new JPanel(new BorderLayout());
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.ui.SelectFromListDialog");

    public SelectFromListDialog(Project project, Object[] objects, ToStringAspect toStringAspect, String title, @JdkConstants.ListSelectionMode int selectionMode) {
        super(project, true);
        this.myToStringAspect = toStringAspect;
        this.myList.setSelectionMode(selectionMode);
        this.setTitle(title);
        for (Object object : objects) {
            this.myModel.addElement(object);
        }
        this.myList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SelectFromListDialog.this.setOKActionEnabled(SelectFromListDialog.this.myList.getSelectedValues().length > 0);
            }
        });
        this.myList.setSelectedIndex(0);
        this.myList.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(@NotNull JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (list == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "list", "com/intellij/openapi/ui/SelectFromListDialog$2", "customizeCellRenderer"));
                }
                this.append(SelectFromListDialog.this.myToStringAspect.getToStirng(value), new SimpleTextAttributes(0, list.getForeground()));
            }
        });
        this.init();
    }

    @Override
    protected JComponent createCenterPanel() {
        this.myMainPanel.add((Component)ScrollPaneFactory.createScrollPane(this.myList), "Center");
        return this.myMainPanel;
    }

    public void addToDialog(JComponent userComponent, @NotNull String borderLayoutConstraints) {
        if (borderLayoutConstraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "borderLayoutConstraints", "com/intellij/openapi/ui/SelectFromListDialog", "addToDialog"));
        }
        LOG.assertTrue(!borderLayoutConstraints.equals("Center"), (Object)"Can't add any component to center");
        this.myMainPanel.add((Component)userComponent, borderLayoutConstraints);
    }

    public void setSelection(String defaultLocation) {
        int index = this.myModel.indexOf(defaultLocation);
        if (index >= 0) {
            this.myList.getSelectionModel().setSelectionInterval(index, index);
        }
    }

    public Object[] getSelection() {
        if (!this.isOK()) {
            return null;
        }
        return this.myList.getSelectedValues();
    }

    @Override
    public JComponent getPreferredFocusedComponent() {
        return this.myList;
    }

    public static interface ToStringAspect {
        public String getToStirng(Object var1);
    }
}

