/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.openapi.module.Module;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public class ModuleSourceSet {
    private final Module myModule;
    private final Type myType;

    public ModuleSourceSet(@NotNull Module module, @NotNull Type type) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/compiler/ModuleSourceSet", "<init>"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/compiler/ModuleSourceSet", "<init>"));
        }
        this.myModule = module;
        this.myType = type;
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleSourceSet", "getModule"));
        }
        return module;
    }

    @NotNull
    public Type getType() {
        Type type = this.myType;
        if (type == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleSourceSet", "getType"));
        }
        return type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ModuleSourceSet set = (ModuleSourceSet)o;
        return this.myModule.equals(set.myModule) && this.myType == set.myType;
    }

    public int hashCode() {
        return 31 * this.myModule.hashCode() + this.myType.hashCode();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public String getDisplayName() {
        return (this.myType == Type.PRODUCTION ? "" : "Tests of ") + "'" + this.myModule.getName() + "' module";
    }

    @NotNull
    public static Set<Module> getModules(@NotNull Collection<ModuleSourceSet> sourceSets) {
        if (sourceSets == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceSets", "com/intellij/compiler/ModuleSourceSet", "getModules"));
        }
        Set<Module> set = sourceSets.stream().map(ModuleSourceSet::getModule).collect(Collectors.toSet());
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/ModuleSourceSet", "getModules"));
        }
        return set;
    }

    public static enum Type {
        PRODUCTION,
        TEST;

    }
}

