/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.offline;

import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class OfflineProblemDescriptor {
    public String myType;
    public String myFQName;
    public String myDescription;
    public List<String> myHints;
    public int myProblemIndex;
    public int myLine;
    public String myModuleName;

    public String getType() {
        return this.myType;
    }

    public void setType(String type) {
        this.myType = type;
    }

    public String getFQName() {
        return this.myFQName;
    }

    public void setFQName(String FQName) {
        this.myFQName = FQName;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public void setDescription(String description) {
        this.myDescription = description;
    }

    public List<String> getHints() {
        return this.myHints;
    }

    public void setHints(List<String> hints) {
        this.myHints = hints;
    }

    public int getProblemIndex() {
        return this.myProblemIndex;
    }

    public void setProblemIndex(int problemIndex) {
        this.myProblemIndex = problemIndex;
    }

    public int getLine() {
        return this.myLine;
    }

    public void setLine(int line) {
        this.myLine = line;
    }

    @Nullable
    public RefEntity getRefElement(RefManager refManager) {
        return (RefEntity)ReadAction.compute(() -> refManager.getReference(this.myType, this.myFQName));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfflineProblemDescriptor that = (OfflineProblemDescriptor)o;
        if (this.myLine != that.myLine) {
            return false;
        }
        if (this.myProblemIndex != that.myProblemIndex) {
            return false;
        }
        if (this.myDescription != null ? !this.myDescription.equals(that.myDescription) : that.myDescription != null) {
            return false;
        }
        if (this.myFQName != null ? !this.myFQName.equals(that.myFQName) : that.myFQName != null) {
            return false;
        }
        if (this.myHints != null ? !this.myHints.equals(that.myHints) : that.myHints != null) {
            return false;
        }
        if (this.myModuleName != null ? !this.myModuleName.equals(that.myModuleName) : that.myModuleName != null) {
            return false;
        }
        return !(this.myType != null ? !this.myType.equals(that.myType) : that.myType != null);
    }

    public int hashCode() {
        int result = this.myType != null ? this.myType.hashCode() : 0;
        result = 31 * result + (this.myFQName != null ? this.myFQName.hashCode() : 0);
        result = 31 * result + (this.myDescription != null ? this.myDescription.hashCode() : 0);
        result = 31 * result + (this.myHints != null ? this.myHints.hashCode() : 0);
        result = 31 * result + this.myProblemIndex;
        result = 31 * result + this.myLine;
        result = 31 * result + (this.myModuleName != null ? this.myModuleName.hashCode() : 0);
        return result;
    }

    public void setModule(String moduleName) {
        this.myModuleName = moduleName;
    }

    public String getModuleName() {
        return this.myModuleName;
    }

    public String toString() {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return this.myFQName;
        }
        return this.myDescription;
    }
}

