/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.mvc.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.mvc.MvcActionBase;
import org.jetbrains.plugins.groovy.mvc.MvcCommand;
import org.jetbrains.plugins.groovy.mvc.MvcCommandExecutor;
import org.jetbrains.plugins.groovy.mvc.MvcFramework;
import org.jetbrains.plugins.groovy.mvc.MvcRunTargetDialog;
import org.jetbrains.plugins.groovy.mvc.actions.MvcRunCommandActionHandler;

public class DefaultMvcRunCommandActionHandler
extends MvcRunCommandActionHandler {
    @Override
    public boolean isAvailable(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/actions/DefaultMvcRunCommandActionHandler", "isAvailable"));
        }
        Pair<MvcFramework, Module> pair = MvcActionBase.guessFramework(e);
        return pair != null && ((MvcFramework)pair.first).isRunTargetActionSupported((Module)pair.second);
    }

    @Override
    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/actions/DefaultMvcRunCommandActionHandler", "update"));
        }
        Pair<MvcFramework, Module> pair = MvcActionBase.guessFramework(e);
        if (pair != null) {
            e.getPresentation().setText("Run " + ((MvcFramework)pair.first).getDisplayName() + " Target");
            e.getPresentation().setDescription("Run arbitrary " + ((MvcFramework)pair.first).getDisplayName() + " target");
        }
    }

    @Override
    public void performAction(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "org/jetbrains/plugins/groovy/mvc/actions/DefaultMvcRunCommandActionHandler", "performAction"));
        }
        Pair<MvcFramework, Module> pair = MvcActionBase.guessFramework(e);
        if (pair == null) {
            return;
        }
        Module module = (Module)pair.second;
        MvcFramework framework = (MvcFramework)pair.first;
        MvcRunTargetDialog dialog = new MvcRunTargetDialog(module, framework);
        if (!dialog.showAndGet()) {
            return;
        }
        Module selectedModule = dialog.getSelectedModule();
        MvcCommand cmd = dialog.createCommand();
        MvcCommandExecutor.run(selectedModule, framework, cmd, null, false, new String[0]);
    }
}

