/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.TokenType;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayFactory;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.TObjectIntHashMap;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.config.GroovyConfigUtils;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.lexer.TokenSets;
import org.jetbrains.plugins.groovy.lang.parser.GroovyElementTypes;
import org.jetbrains.plugins.groovy.lang.psi.GroovyElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifier;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrField;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariable;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrVariableDeclaration;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinitionBody;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrEnumConstant;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.packaging.GrPackageDefinition;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrStubElementBase;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.auxiliary.modifiers.GrAnnotationCollector;
import org.jetbrains.plugins.groovy.lang.psi.stubs.GrModifierListStub;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtilKt;

public class GrModifierListImpl
extends GrStubElementBase<GrModifierListStub>
implements GrModifierList,
StubBasedPsiElement<GrModifierListStub> {
    public static final TObjectIntHashMap<String> NAME_TO_MODIFIER_FLAG_MAP = new TObjectIntHashMap();
    public static final Map<String, IElementType> NAME_TO_MODIFIER_ELEMENT_TYPE = ContainerUtil.newHashMap();
    private static final ArrayFactory<GrAnnotation> ARRAY_FACTORY = GrAnnotation[]::new;
    private static final TObjectIntHashMap<String> PRIORITY = new TObjectIntHashMap(16);
    private static final String[] VISIBILITY_MODIFIERS;

    public GrModifierListImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "<init>"));
        }
        super(node);
    }

    public GrModifierListImpl(GrModifierListStub stub) {
        this(stub, GroovyElementTypes.MODIFIERS);
    }

    public GrModifierListImpl(GrModifierListStub stub, IStubElementType nodeType) {
        super(stub, nodeType);
    }

    @Override
    public void accept(GroovyElementVisitor visitor) {
        visitor.visitModifierList(this);
    }

    public String toString() {
        return "Modifiers";
    }

    @Override
    @NotNull
    public PsiElement[] getModifiers() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>();
        for (PsiElement cur = this.getFirstChild(); cur != null; cur = cur.getNextSibling()) {
            if (!(cur instanceof GrAnnotation) && !TokenSets.MODIFIERS.contains(cur.getNode().getElementType())) continue;
            result.add(cur);
        }
        PsiElement[] psiElementArray = result.toArray(new PsiElement[result.size()]);
        if (psiElementArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "getModifiers"));
        }
        return psiElementArray;
    }

    @Override
    @Nullable
    public PsiElement getModifier(@GrModifier.GrModifierConstant @NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "getModifier"));
        }
        return this.findChildByType(NAME_TO_MODIFIER_ELEMENT_TYPE.get(name));
    }

    @Override
    public boolean hasExplicitVisibilityModifiers() {
        GrModifierListStub stub = (GrModifierListStub)this.getStub();
        if (stub != null) {
            return (stub.getModifiersFlags() & 7) != 0;
        }
        for (String type : VISIBILITY_MODIFIERS) {
            if (!this.hasExplicitModifier(type)) continue;
            return true;
        }
        return false;
    }

    public static boolean checkModifierProperty(@NotNull GrModifierList modifierList, @GrModifier.GrModifierConstant @NotNull String modifier) {
        PsiElement parent;
        if (modifierList == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifierList", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "checkModifierProperty"));
        }
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "checkModifierProperty"));
        }
        PsiElement owner = modifierList.getParent();
        if (owner instanceof GrVariableDeclaration && owner.getParent() instanceof GrTypeDefinitionBody) {
            GrModifierList pModifierList;
            PsiElement pParent = owner.getParent().getParent();
            if (!(modifierList.hasExplicitVisibilityModifiers() || pParent instanceof GrTypeDefinition && GrTraitUtil.isInterface((GrTypeDefinition)pParent))) {
                if (modifier.equals("private")) {
                    return true;
                }
                if (modifier.equals("protected")) {
                    return false;
                }
                if (modifier.equals("public")) {
                    return false;
                }
            }
            if (pParent instanceof GrTypeDefinition && GrTraitUtil.isInterface((GrTypeDefinition)pParent)) {
                if (modifier.equals("static")) {
                    return true;
                }
                if (modifier.equals("final")) {
                    return true;
                }
            }
            if (pParent instanceof GrTypeDefinition && modifier.equals("final") && !modifierList.hasExplicitVisibilityModifiers() && (pModifierList = ((GrTypeDefinition)pParent).getModifierList()) != null && PsiImplUtil.hasImmutableAnnotation(pModifierList)) {
                return true;
            }
        }
        if (owner instanceof GrMethod && owner.getParent() instanceof GrTypeDefinitionBody && (parent = owner.getParent().getParent()) instanceof GrTypeDefinition && ((GrTypeDefinition)parent).isInterface()) {
            if ("abstract".equals(modifier)) {
                return true;
            }
            if (!((GrTypeDefinition)parent).isTrait() && "public".equals(modifier)) {
                return true;
            }
        }
        if (modifierList.hasExplicitModifier(modifier)) {
            return true;
        }
        if (modifier.equals("public")) {
            if (owner instanceof GrPackageDefinition) {
                return false;
            }
            if (owner instanceof GrVariableDeclaration && !(owner.getParent() instanceof GrTypeDefinitionBody) || owner instanceof GrVariable) {
                return false;
            }
            return !modifierList.hasExplicitModifier("private") && !modifierList.hasExplicitModifier("protected");
        }
        if (owner instanceof GrTypeDefinition) {
            GrTypeDefinition clazz = (GrTypeDefinition)owner;
            if (modifier.equals("static")) {
                GrMethod[] containingClass = clazz.getContainingClass();
                return GrTraitUtil.isInterface((PsiClass)containingClass);
            }
            if (modifier.equals("abstract")) {
                if (clazz.isInterface()) {
                    return true;
                }
                if (clazz.isEnum() && GroovyConfigUtils.getInstance().isVersionAtLeast(modifierList, "2.0")) {
                    for (GrMethod method : clazz.getCodeMethods()) {
                        if (!method.hasModifierProperty("abstract")) continue;
                        return true;
                    }
                }
            }
            if (modifier.equals("final") && clazz.isEnum()) {
                GrField[] fields;
                for (GrField field : fields = clazz.getFields()) {
                    if (!(field instanceof GrEnumConstant) || ((GrEnumConstant)field).getInitializingClass() == null) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean hasModifierProperty(@NotNull @NonNls String modifier) {
        if (modifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modifier", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "hasModifierProperty"));
        }
        return GrModifierListImpl.checkModifierProperty(this, modifier);
    }

    @Override
    public boolean hasExplicitModifier(@NotNull @NonNls String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "hasExplicitModifier"));
        }
        GrModifierListStub stub = (GrModifierListStub)this.getStub();
        if (stub != null) {
            return GrModifierListImpl.hasMaskExplicitModifier(name, stub.getModifiersFlags());
        }
        return this.getModifier(name) != null;
    }

    public static boolean hasMaskExplicitModifier(String name, int mask) {
        int flag = NAME_TO_MODIFIER_FLAG_MAP.get((Object)name);
        return (mask & flag) != 0;
    }

    @Override
    public void setModifierProperty(@NotNull @NonNls String name, boolean doSet) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "setModifierProperty"));
        }
        if (this.hasModifierProperty(name) == doSet) {
            return;
        }
        if (doSet && ("private".equals(name) || "protected".equals(name) || "public".equals(name) || "packageLocal".equals(name))) {
            this.setModifierPropertyInternal("public", false);
            this.setModifierPropertyInternal("protected", false);
            this.setModifierPropertyInternal("private", false);
        }
        if ("packageLocal".equals(name)) {
            if (this.getModifiers().length == 0) {
                this.setModifierProperty("def", true);
            }
        } else {
            this.setModifierPropertyInternal(name, doSet);
        }
        if (this.isEmptyModifierList() && !PsiUtilKt.modifierListMayBeEmpty(this.getParent())) {
            this.setModifierPropertyInternal("def", true);
        }
    }

    @Override
    @NotNull
    public GrAnnotation[] getRawAnnotations() {
        GrAnnotation[] grAnnotationArray = (GrAnnotation[])this.getStubOrPsiChildren(GroovyElementTypes.ANNOTATION, ARRAY_FACTORY);
        if (grAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "getRawAnnotations"));
        }
        return grAnnotationArray;
    }

    private void setModifierPropertyInternal(String name, boolean doSet) {
        if (doSet) {
            PsiElement nextSibling;
            if (this.isEmptyModifierList() && (nextSibling = this.getNextSibling()) != null && !PsiImplUtil.isWhiteSpaceOrNls(nextSibling)) {
                this.getNode().getTreeParent().addLeaf(TokenType.WHITE_SPACE, (CharSequence)" ", nextSibling.getNode());
            }
            PsiElement modifier = GroovyPsiElementFactory.getInstance(this.getProject()).createModifierFromText(name);
            PsiElement anchor = this.findAnchor(name);
            this.addAfter(modifier, anchor);
        } else {
            PsiElement nextSibling;
            PsiElement[] modifiers;
            for (PsiElement modifier : modifiers = this.findChildrenByType(TokenSets.MODIFIERS, PsiElement.class)) {
                if (!name.equals(modifier.getText())) continue;
                this.deleteChildRange(modifier, modifier);
                break;
            }
            if (this.isEmptyModifierList() && (nextSibling = this.getNextSibling()) != null && PsiImplUtil.isWhiteSpaceOrNls(nextSibling)) {
                nextSibling.delete();
            }
        }
    }

    public ASTNode addInternal(ASTNode first, ASTNode last, ASTNode anchor, Boolean before) {
        ASTNode node = super.addInternal(first, last, anchor, before);
        PsiElement sibling = this.getNextSibling();
        if (sibling != null && sibling.getText().contains("\n")) {
            sibling.replace(GroovyPsiElementFactory.getInstance(this.getProject()).createWhiteSpace());
        }
        return node;
    }

    private boolean isEmptyModifierList() {
        return this.getTextLength() == 0 || this.getModifiers().length == 0 && this.getRawAnnotations().length == 0;
    }

    @Nullable
    private PsiElement findAnchor(String name) {
        int myPriority = PRIORITY.get((Object)name);
        PsiElement anchor = null;
        for (PsiElement modifier : this.getModifiers()) {
            int otherPriority = PRIORITY.get((Object)modifier.getText());
            if (otherPriority <= myPriority) {
                anchor = modifier;
                continue;
            }
            if (otherPriority > myPriority && anchor != null) break;
        }
        return anchor;
    }

    public void checkSetModifierProperty(@NotNull @NonNls String name, boolean value) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "checkSetModifierProperty"));
        }
    }

    @Override
    @NotNull
    public GrAnnotation[] getAnnotations() {
        GrAnnotation[] grAnnotationArray = (GrAnnotation[])CachedValuesManager.getCachedValue((PsiElement)this, () -> CachedValueProvider.Result.create((Object)GrAnnotationCollector.getResolvedAnnotations(this), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT}));
        if (grAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "getAnnotations"));
        }
        return grAnnotationArray;
    }

    @NotNull
    public PsiAnnotation[] getApplicableAnnotations() {
        PsiAnnotation[] psiAnnotationArray = this.getAnnotations();
        if (psiAnnotationArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "getApplicableAnnotations"));
        }
        return psiAnnotationArray;
    }

    @Nullable
    public PsiAnnotation findAnnotation(@NotNull @NonNls String qualifiedName) {
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "findAnnotation"));
        }
        for (GrAnnotation annotation : this.getAnnotations()) {
            if (!qualifiedName.equals(annotation.getQualifiedName())) continue;
            return annotation;
        }
        return null;
    }

    @NotNull
    public GrAnnotation addAnnotation(@NotNull @NonNls String qualifiedName) {
        GrAnnotation annotation;
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "addAnnotation"));
        }
        PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.getProject()).findClass(qualifiedName, this.getResolveScope());
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(this.getProject());
        if (psiClass != null && psiClass.isAnnotationType()) {
            annotation = (GrAnnotation)this.addAfter(factory.createModifierFromText("@xxx"), null);
            annotation.getClassReference().bindToElement((PsiElement)psiClass);
        } else {
            annotation = (GrAnnotation)this.addAfter(factory.createModifierFromText("@" + qualifiedName), null);
        }
        PsiElement parent = this.getParent();
        if (!(parent instanceof GrParameter)) {
            ASTNode node = annotation.getNode();
            ASTNode treeNext = node.getTreeNext();
            if (treeNext != null) {
                this.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)"\n", treeNext);
            } else {
                parent.getNode().addLeaf(TokenType.WHITE_SPACE, (CharSequence)"\n", this.getNode().getTreeNext());
            }
        }
        GrAnnotation grAnnotation = annotation;
        if (grAnnotation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/lang/psi/impl/auxiliary/modifiers/GrModifierListImpl", "addAnnotation"));
        }
        return grAnnotation;
    }

    static {
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"public", 1);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"protected", 4);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"private", 2);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"packageLocal", 4096);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"static", 8);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"abstract", 1024);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"final", 16);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"native", 256);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"synchronized", 32);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"strictfp", 2048);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"transient", 128);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"volatile", 64);
        NAME_TO_MODIFIER_FLAG_MAP.put((Object)"def", 131072);
        PRIORITY.put((Object)"public", 0);
        PRIORITY.put((Object)"protected", 0);
        PRIORITY.put((Object)"private", 0);
        PRIORITY.put((Object)"packageLocal", 0);
        PRIORITY.put((Object)"static", 1);
        PRIORITY.put((Object)"abstract", 1);
        PRIORITY.put((Object)"final", 2);
        PRIORITY.put((Object)"native", 3);
        PRIORITY.put((Object)"synchronized", 3);
        PRIORITY.put((Object)"strictfp", 3);
        PRIORITY.put((Object)"transient", 3);
        PRIORITY.put((Object)"volatile", 3);
        PRIORITY.put((Object)"def", 4);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("public", GroovyTokenTypes.kPUBLIC);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("abstract", GroovyTokenTypes.kABSTRACT);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("native", GroovyTokenTypes.kNATIVE);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("private", GroovyTokenTypes.kPRIVATE);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("protected", GroovyTokenTypes.kPROTECTED);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("synchronized", GroovyTokenTypes.kSYNCHRONIZED);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("strictfp", GroovyTokenTypes.kSTRICTFP);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("static", GroovyTokenTypes.kSTATIC);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("final", GroovyTokenTypes.kFINAL);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("transient", GroovyTokenTypes.kTRANSIENT);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("native", GroovyTokenTypes.kNATIVE);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("def", GroovyTokenTypes.kDEF);
        NAME_TO_MODIFIER_ELEMENT_TYPE.put("volatile", GroovyTokenTypes.kVOLATILE);
        VISIBILITY_MODIFIERS = new String[]{"public", "protected", "private"};
    }
}

