/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.declaration;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.base.Intention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrAssignmentExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;
import org.jetbrains.plugins.groovy.refactoring.introduce.variable.GrIntroduceVariableHandler;

public class GrIntroduceLocalVariableIntention
extends Intention {
    protected PsiElement getTargetExpression(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/declaration/GrIntroduceLocalVariableIntention", "getTargetExpression"));
        }
        if (GrIntroduceLocalVariableIntention.isTargetVisible(element)) {
            return element;
        }
        PsiElement expression = PsiTreeUtil.getParentOfType((PsiElement)element, GrExpression.class);
        return expression == null ? null : this.getTargetExpression(expression);
    }

    private static boolean isTargetVisible(PsiElement element) {
        return PsiUtil.isExpressionStatement(element) && element instanceof GrExpression && !PsiType.VOID.equals((Object)((GrExpression)element).getType()) && PsiTreeUtil.getParentOfType((PsiElement)element, GrAssignmentExpression.class) == null;
    }

    protected void setSelection(Editor editor, PsiElement element) {
        int offset = element.getTextOffset();
        int length = element.getTextLength();
        editor.getSelectionModel().setSelection(offset, offset + length);
    }

    @Override
    protected void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/declaration/GrIntroduceLocalVariableIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/declaration/GrIntroduceLocalVariableIntention", "processIntention"));
        }
        this.setSelection(editor, this.getTargetExpression(element));
        PsiFile file = element.getContainingFile();
        new GrIntroduceVariableHandler().invoke(project, editor, file, null);
    }

    @Override
    public boolean startInWriteAction() {
        return false;
    }

    @Override
    @NotNull
    protected PsiElementPredicate getElementPredicate() {
        PsiElementPredicate psiElementPredicate = new PsiElementPredicate(){

            @Override
            public boolean satisfiedBy(PsiElement element) {
                if (element == null) {
                    return false;
                }
                return GrIntroduceLocalVariableIntention.this.getTargetExpression(element) != null;
            }
        };
        if (psiElementPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/declaration/GrIntroduceLocalVariableIntention", "getElementPredicate"));
        }
        return psiElementPredicate;
    }
}

