/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.intentions.control;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.intentions.GroovyIntentionsBundle;
import org.jetbrains.plugins.groovy.intentions.base.MutablyNamedIntention;
import org.jetbrains.plugins.groovy.intentions.base.PsiElementPredicate;
import org.jetbrains.plugins.groovy.intentions.control.ComparisonPredicate;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.impl.utils.ComparisonUtils;

public class NegateComparisonIntention
extends MutablyNamedIntention {
    @Override
    protected String getTextForElement(PsiElement element) {
        GrBinaryExpression binaryExpression = (GrBinaryExpression)element;
        IElementType tokenType = binaryExpression.getOperationTokenType();
        String comparison = ComparisonUtils.getStringForComparison(tokenType);
        String negatedComparison = ComparisonUtils.getNegatedComparison(tokenType);
        return GroovyIntentionsBundle.message("negate.comparison.intention.name", comparison, negatedComparison);
    }

    @Override
    @NotNull
    public PsiElementPredicate getElementPredicate() {
        ComparisonPredicate comparisonPredicate = new ComparisonPredicate();
        if (comparisonPredicate == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/intentions/control/NegateComparisonIntention", "getElementPredicate"));
        }
        return comparisonPredicate;
    }

    @Override
    public void processIntention(@NotNull PsiElement element, @NotNull Project project, Editor editor) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/groovy/intentions/control/NegateComparisonIntention", "processIntention"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/intentions/control/NegateComparisonIntention", "processIntention"));
        }
        GrBinaryExpression exp = (GrBinaryExpression)element;
        IElementType tokenType = exp.getOperationTokenType();
        GrExpression lhs = exp.getLeftOperand();
        String lhsText = lhs.getText();
        GrExpression rhs = exp.getRightOperand();
        String rhsText = rhs.getText();
        String negatedComparison = ComparisonUtils.getNegatedComparison(tokenType);
        String newExpression = lhsText + negatedComparison + rhsText;
        NegateComparisonIntention.replaceExpressionWithNegatedExpressionString(newExpression, exp);
    }
}

