/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.griffon;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.plugins.groovy.griffon.GriffonFramework;

public class GriffonSourceInspector {
    public static List<GriffonSource> processModuleMetadata(Module module) {
        return (List)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            ArrayList<GriffonSource> sources = new ArrayList<GriffonSource>();
            ArrayList dependencies = ContainerUtil.newArrayList();
            dependencies.add(ProjectRootManager.getInstance((Project)module.getProject()));
            ContainerUtil.addIfNotNull((Collection)dependencies, (Object)GriffonFramework.getInstance().getApplicationPropertiesFile(module));
            String applicationName = GriffonFramework.getInstance().getApplicationName(module);
            File sdkWorkDir = GriffonFramework.getInstance().getSdkWorkDir(module);
            File pluginsDir = new File(sdkWorkDir, "/projects/" + applicationName + "/plugins/");
            if (pluginsDir.exists() && pluginsDir.canRead() && pluginsDir.isDirectory()) {
                for (File pluginDir : pluginsDir.listFiles()) {
                    XmlTag rootTag;
                    File srcIdeSupportDir;
                    if (!pluginDir.isDirectory() || !pluginDir.canRead() || !(srcIdeSupportDir = new File(pluginDir, "src/ide-support")).exists() || !srcIdeSupportDir.canRead()) continue;
                    File ideaSupport = new File(srcIdeSupportDir, "idea.xml");
                    VirtualFile ideaMetadata = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(ideaSupport);
                    if (ideaMetadata == null) continue;
                    dependencies.add(ideaMetadata);
                    PsiFile psiFile = PsiManager.getInstance((Project)module.getProject()).findFile(ideaMetadata);
                    if (!(psiFile instanceof XmlFile) || (rootTag = ((XmlFile)psiFile).getRootTag()) == null) continue;
                    for (XmlTag sourceRootTag : rootTag.findSubTags("source-root")) {
                        String path = sourceRootTag.getAttributeValue("path");
                        XmlTag navigationTag = sourceRootTag.findFirstSubTag("navigation");
                        String description = navigationTag == null ? "" : navigationTag.getAttributeValue("description");
                        XmlAttribute iconAttr = navigationTag == null ? null : navigationTag.getAttribute("icon");
                        XmlAttribute weightAttr = navigationTag == null ? null : navigationTag.getAttribute("weight");
                        String icon = iconAttr != null ? iconAttr.getValue() : "groovy-icon";
                        int weight = weightAttr != null ? Integer.parseInt(weightAttr.getValue()) : 75;
                        sources.add(new GriffonSource(path, new GriffonSource.Navigation(description, icon, weight)));
                    }
                }
            }
            return CachedValueProvider.Result.create(sources, (Collection)dependencies);
        });
    }

    private static String getNaturalName(String name) {
        name = GriffonSourceInspector.getShortName(name);
        ArrayList<String> words = new ArrayList<String>();
        int i = 0;
        char[] chars = name.toCharArray();
        for (int j = 0; j < chars.length; ++j) {
            String w;
            char c = chars[j];
            if (i >= words.size()) {
                w = "";
                words.add(i, w);
            } else {
                w = (String)words.get(i);
            }
            if (Character.isLowerCase(c) || Character.isDigit(c)) {
                if (Character.isLowerCase(c) && w.isEmpty()) {
                    c = Character.toUpperCase(c);
                } else if (w.length() > 1 && Character.isUpperCase(w.charAt(w.length() - 1))) {
                    w = "";
                    words.add(++i, w);
                }
                words.set(i, w + c);
                continue;
            }
            if (!Character.isUpperCase(c)) continue;
            if (i == 0 && w.isEmpty() || Character.isUpperCase(w.charAt(w.length() - 1))) {
                words.set(i, w + c);
                continue;
            }
            words.add(++i, String.valueOf(c));
        }
        StringBuilder buf = new StringBuilder();
        Iterator j = words.iterator();
        while (j.hasNext()) {
            String word = (String)j.next();
            buf.append(word);
            if (!j.hasNext()) continue;
            buf.append(' ');
        }
        return buf.toString();
    }

    private static String getShortName(String className) {
        return StringUtil.getShortName((String)className);
    }

    public static class GriffonSource {
        private final String path;
        private final Navigation navigation;

        public GriffonSource(String path, Navigation navigation) {
            this.path = path;
            this.navigation = navigation;
        }

        public String getPath() {
            return this.path;
        }

        public Navigation getNavigation() {
            return this.navigation;
        }

        public String toString() {
            return "GriffonSource{path='" + this.path + '\'' + ", navigation=" + this.navigation + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            GriffonSource that = (GriffonSource)o;
            if (!this.navigation.equals(that.navigation)) {
                return false;
            }
            return this.path.equals(that.path);
        }

        public int hashCode() {
            int result = this.path.hashCode();
            result = 31 * result + this.navigation.hashCode();
            return result;
        }

        public static class Navigation {
            private final String description;
            private final String icon;
            private final int weight;

            public Navigation(String description, String icon, int weight) {
                this.description = GriffonSourceInspector.getNaturalName(description);
                this.icon = icon;
                this.weight = weight;
            }

            public String getDescription() {
                return this.description;
            }

            public Icon getIcon() {
                String iconStr;
                String string = iconStr = this.icon.endsWith(".png") ? this.icon : this.icon + ".png";
                if (iconStr.startsWith("/")) {
                    return IconLoader.getIcon((String)iconStr);
                }
                return IconLoader.getIcon((String)("/icons/griffon/" + iconStr));
            }

            public int getWeight() {
                return this.weight;
            }

            public String toString() {
                return "Navigation{description='" + this.description + '\'' + ", icon='" + this.icon + '\'' + ", weight=" + this.weight + '}';
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (!(o instanceof Navigation)) {
                    return false;
                }
                Navigation that = (Navigation)o;
                if (this.weight != that.weight) {
                    return false;
                }
                if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
                    return false;
                }
                return !(this.icon != null ? !this.icon.equals(that.icon) : that.icon != null);
            }

            public int hashCode() {
                int result = this.description != null ? this.description.hashCode() : 0;
                result = 31 * result + (this.icon != null ? this.icon.hashCode() : 0);
                result = 31 * result + this.weight;
                return result;
            }
        }
    }
}

