/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.compiler;

import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.groovy.GreclipseSettings;

public class GreclipseConfigurable
implements Configurable {
    private final GreclipseSettings mySettings;
    private TextFieldWithBrowseButton myJarPath;
    private RawCommandLineEditor myCmdLineParams;
    private JBCheckBox myGenerateDebugInfo;
    private JPanel myPanel;

    public GreclipseConfigurable(GreclipseSettings settings) {
        this.mySettings = settings;
        this.$$$setupUI$$$();
        FileChooserDescriptor descriptor2 = new FileChooserDescriptor(false, false, true, true, false, false);
        this.myJarPath.addBrowseFolderListener(null, "Select path to groovy-eclipse-batch-*.jar with version matching your Groovy distribution", null, descriptor2);
    }

    @Nls
    public String getDisplayName() {
        return null;
    }

    @Nullable
    public String getHelpTopic() {
        return null;
    }

    @Nullable
    public JComponent createComponent() {
        return this.myPanel;
    }

    public boolean isModified() {
        return !Comparing.equal((String)this.getExternalizableJarPath(), (String)this.mySettings.greclipsePath) || !Comparing.equal((String)this.myCmdLineParams.getText(), (String)this.mySettings.cmdLineParams) || !Comparing.equal((Object)this.myGenerateDebugInfo.isSelected(), (Object)this.mySettings.debugInfo);
    }

    public void apply() throws ConfigurationException {
        this.mySettings.greclipsePath = this.getExternalizableJarPath();
        this.mySettings.cmdLineParams = this.myCmdLineParams.getText();
        this.mySettings.debugInfo = this.myGenerateDebugInfo.isSelected();
    }

    @NotNull
    private String getExternalizableJarPath() {
        String string = FileUtil.toSystemIndependentName((String)this.myJarPath.getText());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/compiler/GreclipseConfigurable", "getExternalizableJarPath"));
        }
        return string;
    }

    public void reset() {
        this.myJarPath.setText(FileUtil.toSystemDependentName((String)this.mySettings.greclipsePath));
        this.myCmdLineParams.setText(this.mySettings.cmdLineParams);
        this.myGenerateDebugInfo.setSelected(this.mySettings.debugInfo);
    }

    public void disposeUIResources() {
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        RawCommandLineEditor rawCommandLineEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        Font font = jPanel.getFont();
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder(null, (String)"Groovy-Eclipse options", (int)0, (int)0, (Font)new Font(font.getName(), font.getStyle(), font.getSize()), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Path to groovy-eclipse-batch jar:");
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myJarPath = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setText("");
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, null, new Dimension(150, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Additional command line parameters:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myCmdLineParams = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Command line parameters");
        jPanel.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 1, 0, 1, 7, 0, null, null, null));
        this.myGenerateDebugInfo = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Generate debug info");
        jPanel.add((Component)jBCheckBox, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

