/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.validity;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrClosableBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;

public class GroovyUnreachableStatementInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Validity issues" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyUnreachableStatementInspection", "getGroupDisplayName"));
        }
        return "Validity issues";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Unreachable Statement" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyUnreachableStatementInspection", "getDisplayName"));
        }
        return "Unreachable Statement";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Unreachable statement #loc";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyUnreachableStatementInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitClosure(@NotNull GrClosableBlock closure) {
            if (closure == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "closure", "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyUnreachableStatementInspection$Visitor", "visitClosure"));
            }
            super.visitClosure(closure);
            GrStatement[] statements = closure.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                this.checkPair(statements[i], statements[i + 1]);
            }
        }

        @Override
        public void visitOpenBlock(@NotNull GrOpenBlock block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "org/jetbrains/plugins/groovy/codeInspection/validity/GroovyUnreachableStatementInspection$Visitor", "visitOpenBlock"));
            }
            super.visitOpenBlock(block);
            GrStatement[] statements = block.getStatements();
            for (int i = 0; i < statements.length - 1; ++i) {
                this.checkPair(statements[i], statements[i + 1]);
            }
        }

        private void checkPair(GrStatement prev, GrStatement statement) {
            if (!ControlFlowUtils.statementMayCompleteNormally(prev)) {
                this.registerError(statement);
            }
        }
    }
}

