/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.naming;

import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.GroovyQuickFixFactory;
import org.jetbrains.plugins.groovy.codeInspection.naming.ConventionInspection;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrAnnotationTypeDefinition;

public class GroovyAnnotationNamingConventionInspection
extends ConventionInspection {
    private static final int DEFAULT_MIN_LENGTH = 8;
    private static final int DEFAULT_MAX_LENGTH = 64;

    @NotNull
    public String getDisplayName() {
        if ("Annotation naming convention" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection", "getDisplayName"));
        }
        return "Annotation naming convention";
    }

    @Override
    protected GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection", "buildFix"));
        }
        return GroovyQuickFixFactory.getInstance().createRenameFix();
    }

    @Override
    protected boolean buildQuickFixesOnlyForOnTheFlyErrors() {
        return true;
    }

    @Override
    @NotNull
    public String buildErrorString(Object ... args) {
        String className = (String)args[0];
        if (className.length() < this.getMinLength()) {
            if ("Annotation name '#ref' is too short" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection", "buildErrorString"));
            }
            return "Annotation name '#ref' is too short";
        }
        if (className.length() > this.getMaxLength()) {
            if ("Annotation name '#ref' is too long" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection", "buildErrorString"));
            }
            return "Annotation name '#ref' is too long";
        }
        String string = "Annotation name '#ref' doesn't match regex '" + this.getRegex() + "' #loc";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection", "buildErrorString"));
        }
        return string;
    }

    @Override
    protected String getDefaultRegex() {
        return "[A-Z][A-Za-z\\d]*";
    }

    @Override
    protected int getDefaultMinLength() {
        return 8;
    }

    @Override
    protected int getDefaultMaxLength() {
        return 64;
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        NamingConventionsVisitor namingConventionsVisitor = new NamingConventionsVisitor();
        if (namingConventionsVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection", "buildVisitor"));
        }
        return namingConventionsVisitor;
    }

    private class NamingConventionsVisitor
    extends BaseInspectionVisitor {
        private NamingConventionsVisitor() {
        }

        @Override
        public void visitAnnotationTypeDefinition(@NotNull GrAnnotationTypeDefinition aClass) {
            if (aClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "org/jetbrains/plugins/groovy/codeInspection/naming/GroovyAnnotationNamingConventionInspection$NamingConventionsVisitor", "visitAnnotationTypeDefinition"));
            }
            super.visitAnnotationTypeDefinition(aClass);
            String name = aClass.getName();
            if (name == null) {
                return;
            }
            if (GroovyAnnotationNamingConventionInspection.this.isValid(name)) {
                return;
            }
            this.registerClassError(aClass, name);
        }
    }
}

