/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.exception;

import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.utils.ControlFlowUtils;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrBreakStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.branch.GrContinueStatement;

public class GroovyContinueOrBreakFromFinallyBlockInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Error handling" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyContinueOrBreakFromFinallyBlockInspection", "getGroupDisplayName"));
        }
        return "Error handling";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("'continue' or 'break' inside 'finally' block" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyContinueOrBreakFromFinallyBlockInspection", "getDisplayName"));
        }
        return "'continue' or 'break' inside 'finally' block";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "'#ref' inside 'finally' block #loc";
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyContinueOrBreakFromFinallyBlockInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitContinueStatement(@NotNull GrContinueStatement continueStatement) {
            if (continueStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "continueStatement", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyContinueOrBreakFromFinallyBlockInspection$Visitor", "visitContinueStatement"));
            }
            super.visitContinueStatement(continueStatement);
            if (!ControlFlowUtils.isInFinallyBlock(continueStatement)) {
                return;
            }
            GrStatement continuedStatement = continueStatement.findTargetStatement();
            if (continuedStatement == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(continuedStatement)) {
                return;
            }
            this.registerStatementError(continueStatement, new Object[0]);
        }

        @Override
        public void visitBreakStatement(@NotNull GrBreakStatement breakStatement) {
            if (breakStatement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "breakStatement", "org/jetbrains/plugins/groovy/codeInspection/exception/GroovyContinueOrBreakFromFinallyBlockInspection$Visitor", "visitBreakStatement"));
            }
            super.visitBreakStatement(breakStatement);
            if (!ControlFlowUtils.isInFinallyBlock(breakStatement)) {
                return;
            }
            GrStatement target = breakStatement.findTargetStatement();
            if (target == null) {
                return;
            }
            if (ControlFlowUtils.isInFinallyBlock(target)) {
                return;
            }
            this.registerStatementError(breakStatement, new Object[0]);
        }
    }
}

