/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.control;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.codeInspection.utils.EquivalenceChecker;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrIfStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.GrStatement;

public class GroovyIfStatementWithIdenticalBranchesInspection
extends BaseInspection {
    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public String getDisplayName() {
        if ("If statement with identical branches" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection", "getDisplayName"));
        }
        return "If statement with identical branches";
    }

    @NotNull
    public String getGroupDisplayName() {
        if ("Control Flow" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection", "getGroupDisplayName"));
        }
        return "Control Flow";
    }

    @Override
    public String buildErrorString(Object ... args) {
        return "'#ref' statement with identical branches #loc";
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection", "buildFix"));
        }
        return new CollapseIfFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        IfStatementWithIdenticalBranchesVisitor ifStatementWithIdenticalBranchesVisitor = new IfStatementWithIdenticalBranchesVisitor();
        if (ifStatementWithIdenticalBranchesVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection", "buildVisitor"));
        }
        return ifStatementWithIdenticalBranchesVisitor;
    }

    private static class IfStatementWithIdenticalBranchesVisitor
    extends BaseInspectionVisitor {
        private IfStatementWithIdenticalBranchesVisitor() {
        }

        @Override
        public void visitIfStatement(@NotNull GrIfStatement statement) {
            if (statement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection$IfStatementWithIdenticalBranchesVisitor", "visitIfStatement"));
            }
            super.visitIfStatement(statement);
            GrStatement thenBranch = statement.getThenBranch();
            GrStatement elseBranch = statement.getElseBranch();
            if (thenBranch == null || elseBranch == null) {
                return;
            }
            if (EquivalenceChecker.statementsAreEquivalent(thenBranch, elseBranch)) {
                this.registerStatementError(statement, new Object[0]);
            }
        }
    }

    private static class CollapseIfFix
    extends GroovyFix {
        private CollapseIfFix() {
        }

        @NotNull
        public String getName() {
            if ("Collapse 'if' statement'" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection$CollapseIfFix", "getName"));
            }
            return "Collapse 'if' statement'";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection$CollapseIfFix", "doFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/control/GroovyIfStatementWithIdenticalBranchesInspection$CollapseIfFix", "doFix"));
            }
            PsiElement identifier = descriptor2.getPsiElement();
            GrIfStatement statement = (GrIfStatement)identifier.getParent();
            assert (statement != null);
            GrStatement thenBranch = statement.getThenBranch();
            CollapseIfFix.replaceStatement((GrStatement)statement, thenBranch);
        }
    }
}

