/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations;

import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.MethodCallData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.data.OptionsData;
import org.jetbrains.plugins.groovy.codeInspection.changeToOperator.transformations.Transformation;

public class BinaryTransformation
extends Transformation {
    public BinaryTransformation(@Nullable IElementType operator) {
        super(operator);
    }

    @Override
    @Nullable
    public String getReplacement(MethodCallData methodInfo, OptionsData optionsData) {
        String lhs = this.getLhs(methodInfo);
        IElementType operator = this.getOperator(methodInfo, optionsData);
        String rhs = this.getRhs(methodInfo);
        if (lhs == null || operator == null || rhs == null) {
            return null;
        }
        return String.format("%s %s %s", lhs, operator, rhs);
    }

    @Nullable
    protected String getLhs(MethodCallData methodInfo) {
        return methodInfo.getBase();
    }

    @Nullable
    protected IElementType getOperator(MethodCallData methodInfo, OptionsData optionsData) {
        return this.operator;
    }

    @Nullable
    protected String getRhs(MethodCallData methodInfo) {
        return methodInfo.getArgument(0);
    }
}

