/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeInspection.bugs;

import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspection;
import org.jetbrains.plugins.groovy.codeInspection.BaseInspectionVisitor;
import org.jetbrains.plugins.groovy.codeInspection.GroovyFix;
import org.jetbrains.plugins.groovy.lang.lexer.GroovyTokenTypes;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrBinaryExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;

public class GroovyNonShortCircuitBooleanInspection
extends BaseInspection {
    @Nls
    @NotNull
    public String getGroupDisplayName() {
        if ("Probable bugs" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection", "getGroupDisplayName"));
        }
        return "Probable bugs";
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Non short-circuit boolean" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection", "getDisplayName"));
        }
        return "Non short-circuit boolean";
    }

    @Override
    @Nullable
    protected String buildErrorString(Object ... args) {
        return "Non short-circuit boolean expression #loc";
    }

    public boolean isEnabledByDefault() {
        return false;
    }

    @Override
    public GroovyFix buildFix(@NotNull PsiElement location) {
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection", "buildFix"));
        }
        return new NonShortCircuitBooleanFix();
    }

    @Override
    @NotNull
    public BaseInspectionVisitor buildVisitor() {
        Visitor visitor = new Visitor();
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends BaseInspectionVisitor {
        private Visitor() {
        }

        @Override
        public void visitBinaryExpression(@NotNull GrBinaryExpression expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection$Visitor", "visitBinaryExpression"));
            }
            super.visitBinaryExpression(expression);
            GrExpression rhs = expression.getRightOperand();
            if (rhs == null) {
                return;
            }
            IElementType sign = expression.getOperationTokenType();
            if (!GroovyTokenTypes.mBAND.equals(sign) && !GroovyTokenTypes.mBOR.equals(sign)) {
                return;
            }
            if (!PsiType.BOOLEAN.equals((Object)rhs.getType())) {
                return;
            }
            this.registerError(expression);
        }
    }

    private static class NonShortCircuitBooleanFix
    extends GroovyFix {
        private NonShortCircuitBooleanFix() {
        }

        @NotNull
        public String getName() {
            if ("Replace with short-circuit expression" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection$NonShortCircuitBooleanFix", "getName"));
            }
            return "Replace with short-circuit expression";
        }

        @Override
        public void doFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor2) throws IncorrectOperationException {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection$NonShortCircuitBooleanFix", "doFix"));
            }
            if (descriptor2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/plugins/groovy/codeInspection/bugs/GroovyNonShortCircuitBooleanInspection$NonShortCircuitBooleanFix", "doFix"));
            }
            GrBinaryExpression expression = (GrBinaryExpression)descriptor2.getPsiElement();
            GrExpression lhs = expression.getLeftOperand();
            GrExpression rhs = expression.getRightOperand();
            IElementType operationSign = expression.getOperationTokenType();
            assert (rhs != null);
            String newExpression = lhs.getText() + NonShortCircuitBooleanFix.getShortCircuitOperand(operationSign) + rhs.getText();
            NonShortCircuitBooleanFix.replaceExpression(expression, newExpression);
        }

        private static String getShortCircuitOperand(IElementType tokenType) {
            if (tokenType.equals(GroovyTokenTypes.mBAND)) {
                return "&&";
            }
            return "||";
        }
    }
}

