/*
 * Decompiled with CFR 0.152.
 */
package git4idea.rebase;

import com.intellij.ide.XmlRpcServer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.containers.ContainerUtil;
import git4idea.commands.GitLineHandler;
import git4idea.rebase.GitRebaseEditorHandler;
import git4idea.rebase.GitRebaseEditorMain;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.codec.DecoderException;
import org.apache.xmlrpc.XmlRpcClientLite;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.git4idea.util.ScriptGenerator;
import org.jetbrains.ide.BuiltInServerManager;

public class GitRebaseEditorService {
    private String myEditorCommand;
    private final Object myScriptLock = new Object();
    private final Map<UUID, GitRebaseEditorHandler> myHandlers = ContainerUtil.newHashMap();
    private final Object myHandlersLock = new Object();
    @NonNls
    private static final String GIT_REBASE_EDITOR_PREFIX = "git-rebase-editor-";

    @NotNull
    public static GitRebaseEditorService getInstance() {
        GitRebaseEditorService service = (GitRebaseEditorService)ServiceManager.getService(GitRebaseEditorService.class);
        if (service == null) {
            throw new IllegalStateException("The service " + GitRebaseEditorService.class.getName() + " cannot be located");
        }
        GitRebaseEditorService gitRebaseEditorService = service;
        if (gitRebaseEditorService == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEditorService", "getInstance"));
        }
        return gitRebaseEditorService;
    }

    private void addInternalHandler() {
        XmlRpcServer xmlRpcServer = XmlRpcServer.SERVICE.getInstance();
        if (!xmlRpcServer.hasHandler("Git4ideaRebaseEditorHandler")) {
            xmlRpcServer.addHandler("Git4ideaRebaseEditorHandler", (Object)new InternalHandler());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public synchronized String getEditorCommand() {
        Object object = this.myScriptLock;
        // MONITORENTER : object
        if (this.myEditorCommand == null) {
            ScriptGenerator generator = new ScriptGenerator(GIT_REBASE_EDITOR_PREFIX, GitRebaseEditorMain.class);
            generator.addInternal(Integer.toString(BuiltInServerManager.getInstance().getPort()));
            generator.addClasses(XmlRpcClientLite.class, DecoderException.class);
            this.myEditorCommand = generator.commandLine();
        }
        String string = this.myEditorCommand;
        // MONITOREXIT : object
        if (string != null) return string;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEditorService", "getEditorCommand"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public UUID registerHandler(@NotNull GitRebaseEditorHandler handler, @NotNull Disposable parentDisposable) {
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "git4idea/rebase/GitRebaseEditorService", "registerHandler"));
        }
        if (parentDisposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentDisposable", "git4idea/rebase/GitRebaseEditorService", "registerHandler"));
        }
        this.addInternalHandler();
        Object object = this.myHandlersLock;
        // MONITORENTER : object
        final UUID key = UUID.randomUUID();
        this.myHandlers.put(key, handler);
        Disposer.register((Disposable)parentDisposable, (Disposable)new Disposable(){

            public void dispose() {
                GitRebaseEditorService.this.myHandlers.remove(key);
            }
        });
        UUID uUID = key;
        // MONITOREXIT : object
        if (uUID != null) return uUID;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEditorService", "registerHandler"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterHandler(@NotNull UUID handlerNo) {
        if (handlerNo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerNo", "git4idea/rebase/GitRebaseEditorService", "unregisterHandler"));
        }
        Object object = this.myHandlersLock;
        synchronized (object) {
            if (this.myHandlers.remove(handlerNo) == null) {
                throw new IllegalStateException("The handler " + handlerNo + " has been already removed");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    GitRebaseEditorHandler getHandler(@NotNull UUID handlerNo) {
        if (handlerNo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerNo", "git4idea/rebase/GitRebaseEditorService", "getHandler"));
        }
        Object object = this.myHandlersLock;
        // MONITORENTER : object
        GitRebaseEditorHandler h = this.myHandlers.get(handlerNo);
        if (h == null) {
            throw new IllegalStateException("The handler " + handlerNo + " is not registered");
        }
        GitRebaseEditorHandler gitRebaseEditorHandler = h;
        // MONITOREXIT : object
        if (gitRebaseEditorHandler != null) return gitRebaseEditorHandler;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/rebase/GitRebaseEditorService", "getHandler"));
    }

    public void configureHandler(GitLineHandler h, @NotNull UUID editorNo) {
        if (editorNo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorNo", "git4idea/rebase/GitRebaseEditorService", "configureHandler"));
        }
        h.setEnvironment("GIT_EDITOR", this.getEditorCommand());
        h.setEnvironment("IDEA_REBASE_HANDER_NO", editorNo.toString());
    }

    public class InternalHandler {
        public int editCommits(@NotNull String handlerNo, String path) {
            if (handlerNo == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handlerNo", "git4idea/rebase/GitRebaseEditorService$InternalHandler", "editCommits"));
            }
            GitRebaseEditorHandler editor = GitRebaseEditorService.this.getHandler(UUID.fromString(handlerNo));
            return editor.editCommits(path);
        }
    }
}

