/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vcs.vfs.AbstractVcsVirtualFile;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitSimpleHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUtil {
    public static final String DOT_GIT = ".git";
    public static final String ORIGIN_HEAD = "origin/HEAD";
    public static final com.intellij.util.Function<GitRepository, VirtualFile> REPOSITORY_TO_ROOT = new com.intellij.util.Function<GitRepository, VirtualFile>(){

        public VirtualFile fun(@NotNull GitRepository repository) {
            if (repository == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitUtil$1", "fun"));
            }
            return repository.getRoot();
        }
    };
    public static final String HEAD = "HEAD";
    public static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    public static final String MERGE_HEAD = "MERGE_HEAD";
    private static final String SUBMODULE_REPO_PATH_PREFIX = "gitdir:";
    private static final Logger LOG = Logger.getInstance(GitUtil.class);
    private static final String HEAD_FILE = "HEAD";

    private GitUtil() {
    }

    @Nullable
    public static File findGitDir(@NotNull File rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "git4idea/GitUtil", "findGitDir"));
        }
        File dotGit = new File(rootDir, DOT_GIT);
        if (!dotGit.exists()) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = new File(dotGit, "HEAD").exists();
            return headExists ? dotGit : null;
        }
        String content = DvcsUtil.tryLoadFileOrReturn((File)dotGit, null, (String)"UTF-8");
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        return GitUtil.findSubmoduleRepositoryDir(rootDir.getPath(), pathToDir);
    }

    @Nullable
    public static VirtualFile findGitDir(@NotNull VirtualFile rootDir) {
        if (rootDir == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootDir", "git4idea/GitUtil", "findGitDir"));
        }
        VirtualFile dotGit = rootDir.findChild(DOT_GIT);
        if (dotGit == null) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = dotGit.findChild("HEAD") != null;
            return headExists ? dotGit : null;
        }
        String content = GitUtil.readContent(dotGit);
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        File file = GitUtil.findSubmoduleRepositoryDir(rootDir.getPath(), pathToDir);
        if (file == null) {
            return null;
        }
        return VcsUtil.getVirtualFileWithRefresh((File)file);
    }

    @Nullable
    private static File findSubmoduleRepositoryDir(@NotNull String rootPath, @NotNull String path) {
        File file;
        if (rootPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootPath", "git4idea/GitUtil", "findSubmoduleRepositoryDir"));
        }
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitUtil", "findSubmoduleRepositoryDir"));
        }
        if (!FileUtil.isAbsolute((String)path)) {
            String canonicalPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{rootPath, path}), (boolean)true);
            if (canonicalPath == null) {
                return null;
            }
            path = FileUtil.toSystemIndependentName((String)canonicalPath);
        }
        return (file = new File(path)).isDirectory() ? file : null;
    }

    @NotNull
    private static String parsePathToRepository(@NotNull String content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "git4idea/GitUtil", "parsePathToRepository"));
        }
        String string = (content = content.trim()).startsWith(SUBMODULE_REPO_PATH_PREFIX) ? content.substring(SUBMODULE_REPO_PATH_PREFIX.length()).trim() : content;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "parsePathToRepository"));
        }
        return string;
    }

    @Nullable
    private static String readContent(@NotNull VirtualFile dotGit) {
        String content;
        if (dotGit == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dotGit", "git4idea/GitUtil", "readContent"));
        }
        try {
            content = GitUtil.readFile(dotGit);
        }
        catch (IOException e) {
            LOG.error("Couldn't read the content of " + dotGit, (Throwable)e);
            return null;
        }
        return content;
    }

    @NotNull
    public static String readFile(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/GitUtil", "readFile"));
        }
        int ATTEMPTS = 3;
        for (int attempt = 0; attempt < 3; ++attempt) {
            String string;
            block4: {
                try {
                    string = new String(file.contentsToByteArray());
                    if (string != null) break block4;
                }
                catch (IOException e) {
                    LOG.info(String.format("IOException while reading %s (attempt #%s)", file, attempt));
                    if (attempt < 2) continue;
                    throw e;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "readFile"));
            }
            return string;
        }
        throw new AssertionError((Object)("Shouldn't get here. Couldn't read " + file));
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Collection<VirtualFile> virtualFiles) throws VcsException {
        if (virtualFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFiles", "git4idea/GitUtil", "sortFilesByGitRoot"));
        }
        Map<VirtualFile, List<VirtualFile>> map = GitUtil.sortFilesByGitRoot(virtualFiles, false);
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "sortFilesByGitRoot"));
        }
        return map;
    }

    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(Collection<VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        HashMap<VirtualFile, List<VirtualFile>> result = new HashMap<VirtualFile, List<VirtualFile>>();
        for (VirtualFile file : virtualFiles) {
            VirtualFile vcsRoot = GitUtil.gitRootOrNull(file.isDirectory() ? file.getParent() : file);
            if (vcsRoot == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + file.getPath() + " is not under Git");
            }
            ArrayList<VirtualFile> files = (ArrayList<VirtualFile>)result.get(vcsRoot);
            if (files == null) {
                files = new ArrayList<VirtualFile>();
                result.put(vcsRoot, files);
            }
            files.add(file);
        }
        return result;
    }

    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(Collection<FilePath> files) throws VcsException {
        return GitUtil.sortFilePathsByGitRoot(files, false);
    }

    @NotNull
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Collection<FilePath> files, boolean ignoreNonGit) throws VcsException {
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/GitUtil", "sortFilePathsByGitRoot"));
        }
        HashMap<VirtualFile, List<FilePath>> rc = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath p : files) {
            VirtualFile root = GitUtil.getGitRootOrNull(p);
            if (root == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + p.getPath() + " is not under Git");
            }
            ArrayList<FilePath> l = (ArrayList<FilePath>)rc.get(root);
            if (l == null) {
                l = new ArrayList<FilePath>();
                rc.put(root, l);
            }
            l.add(p);
        }
        HashMap<VirtualFile, List<FilePath>> hashMap = rc;
        if (hashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "sortFilePathsByGitRoot"));
        }
        return hashMap;
    }

    public static Date parseTimestamp(String value) {
        long parsed = Long.parseLong(value.trim());
        return new Date(parsed * 1000L);
    }

    public static Date parseTimestampWithNFEReport(String value, GitHandler handler, String gitOutput) {
        try {
            return GitUtil.parseTimestamp(value);
        }
        catch (NumberFormatException e) {
            LOG.error("annotate(). NFE. Handler: " + handler + ". Output: " + gitOutput, (Throwable)e);
            return new Date();
        }
    }

    public static Set<VirtualFile> gitRootsForPaths(Collection<VirtualFile> roots) {
        HashSet<VirtualFile> rc = new HashSet<VirtualFile>();
        Iterator<VirtualFile> iterator = roots.iterator();
        block0: while (iterator.hasNext()) {
            VirtualFile root;
            VirtualFile f = root = iterator.next();
            do {
                if (f.findFileByRelativePath(DOT_GIT) == null) continue;
                rc.add(f);
                continue block0;
            } while ((f = f.getParent()) != null);
        }
        return rc;
    }

    public static VirtualFile getGitRoot(@NotNull FilePath filePath) throws VcsException {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/GitUtil", "getGitRoot"));
        }
        VirtualFile root = GitUtil.getGitRootOrNull(filePath);
        if (root != null) {
            return root;
        }
        throw new VcsException("The file " + filePath + " is not under git.");
    }

    @Deprecated
    @Nullable
    public static VirtualFile getGitRootOrNull(@NotNull FilePath filePath) {
        if (filePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "git4idea/GitUtil", "getGitRootOrNull"));
        }
        return GitUtil.getGitRootOrNull(filePath.getIOFile());
    }

    public static boolean isGitRoot(@NotNull File folder) {
        if (folder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "folder", "git4idea/GitUtil", "isGitRoot"));
        }
        return GitUtil.findGitDir(folder) != null;
    }

    @Deprecated
    @Nullable
    public static VirtualFile getGitRootOrNull(File file) {
        File root;
        for (root = file; !(root == null || root.exists() && root.isDirectory() && new File(root, DOT_GIT).exists()); root = root.getParentFile()) {
        }
        return root == null ? null : LocalFileSystem.getInstance().findFileByIoFile(root);
    }

    public static VirtualFile getGitRoot(@NotNull VirtualFile file) throws VcsException {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "git4idea/GitUtil", "getGitRoot"));
        }
        VirtualFile root = GitUtil.gitRootOrNull(file);
        if (root != null) {
            return root;
        }
        throw new VcsException("The file " + file.getPath() + " is not under git.");
    }

    @Nullable
    public static VirtualFile gitRootOrNull(VirtualFile file) {
        VirtualFile root;
        if (file instanceof AbstractVcsVirtualFile) {
            return GitUtil.getGitRootOrNull(VcsUtil.getFilePath((String)file.getPath()));
        }
        for (root = file; root != null; root = root.getParent()) {
            if (root.findFileByRelativePath(DOT_GIT) == null) continue;
            return root;
        }
        return root;
    }

    @NotNull
    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) throws VcsException {
        VirtualFile[] contentRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (contentRoots == null || contentRoots.length == 0) {
            throw new VcsException(GitBundle.getString("repository.action.missing.roots.unconfigured.message"));
        }
        List sortedRoots = DvcsUtil.sortVirtualFilesByPresentation(GitUtil.gitRootsForPaths(Arrays.asList(contentRoots)));
        if (sortedRoots.size() == 0) {
            throw new VcsException(GitBundle.getString("repository.action.missing.roots.misconfigured"));
        }
        List list = sortedRoots;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getGitRoots"));
        }
        return list;
    }

    public static boolean isUnderGit(VirtualFile vFile) {
        return GitUtil.gitRootOrNull(vFile) != null;
    }

    public static String adjustAuthorName(String authorName, String committerName) {
        if (!authorName.equals(committerName)) {
            committerName = authorName + ", via " + committerName;
        }
        return committerName;
    }

    public static boolean isUnderGit(FilePath path) {
        return GitUtil.getGitRootOrNull(path) != null;
    }

    public static Set<VirtualFile> gitRoots(Collection<FilePath> filePaths) {
        return filePaths.stream().map(GitUtil::getGitRootOrNull).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static String gitTime(Date time) {
        long t = time.getTime() / 1000L;
        return Long.toString(t);
    }

    public static String formatLongRev(long rev) {
        return String.format("%015x%x", rev >>> 4, rev & 0xFL);
    }

    public static void getLocalCommittedChanges(Project project, VirtualFile root, Consumer<GitSimpleHandler> parametersSpecifier, Consumer<GitCommittedChangeList> consumer, boolean skipDiffsForMerge) throws VcsException {
        GitSimpleHandler h = new GitSimpleHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters("--pretty=format:%x04%x01%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--name-status");
        parametersSpecifier.consume((Object)h);
        String output = h.run();
        LOG.debug("getLocalCommittedChanges output: '" + output + "'");
        StringScanner s = new StringScanner(output);
        StringBuilder sb = new StringBuilder();
        boolean firstStep = true;
        while (s.hasMoreData()) {
            String line = s.line();
            boolean lineIsAStart = line.startsWith("\u0004\u0001");
            if (!firstStep && lineIsAStart) {
                StringScanner innerScanner = new StringScanner(sb.toString());
                sb.setLength(0);
                consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
            }
            sb.append(lineIsAStart ? line.substring(2) : line).append('\n');
            firstStep = false;
        }
        if (sb.length() > 0) {
            StringScanner innerScanner = new StringScanner(sb.toString());
            sb.setLength(0);
            consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
        }
        if (s.hasMoreData()) {
            throw new IllegalStateException("More input is avaialble: " + s.line());
        }
    }

    public static List<GitCommittedChangeList> getLocalCommittedChanges(Project project, VirtualFile root, Consumer<GitSimpleHandler> parametersSpecifier) throws VcsException {
        final ArrayList<GitCommittedChangeList> rc = new ArrayList<GitCommittedChangeList>();
        GitUtil.getLocalCommittedChanges(project, root, parametersSpecifier, new Consumer<GitCommittedChangeList>(){

            public void consume(GitCommittedChangeList committedChangeList) {
                rc.add(committedChangeList);
            }
        }, false);
        return rc;
    }

    @NotNull
    public static String unescapePath(@NotNull String path) throws VcsException {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "git4idea/GitUtil", "unescapePath"));
        }
        String QUOTE = "\"";
        if (path.startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        int l = path.length();
        StringBuilder rc = new StringBuilder(l);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                if (++i >= l) {
                    throw new VcsException("Unterminated escape sequence in the path: " + path);
                }
                char e = path.charAt(i);
                switch (e) {
                    case '\\': {
                        rc.append('\\');
                        break;
                    }
                    case 't': {
                        rc.append('\t');
                        break;
                    }
                    case 'n': {
                        rc.append('\n');
                        break;
                    }
                    case '\"': {
                        rc.append('\"');
                        break;
                    }
                    default: {
                        if (VcsFileUtil.isOctal((char)e)) {
                            int n = 0;
                            for (int j = i; j < l; ++j) {
                                if (VcsFileUtil.isOctal((char)path.charAt(j))) {
                                    ++n;
                                    for (int k = 0; k < 3 && j < l && VcsFileUtil.isOctal((char)path.charAt(j)); ++j, ++k) {
                                    }
                                }
                                if (j + 1 >= l || path.charAt(j) != '\\' || !VcsFileUtil.isOctal((char)path.charAt(j + 1))) break;
                            }
                            byte[] b = new byte[n];
                            n = 0;
                            while (i < l) {
                                if (VcsFileUtil.isOctal((char)path.charAt(i))) {
                                    int code = 0;
                                    for (int k = 0; k < 3 && i < l && VcsFileUtil.isOctal((char)path.charAt(i)); ++i, ++k) {
                                        code = code * 8 + (path.charAt(i) - 48);
                                    }
                                    b[n++] = (byte)code;
                                }
                                if (i + 1 >= l || path.charAt(i) != '\\' || !VcsFileUtil.isOctal((char)path.charAt(i + 1))) break;
                                ++i;
                            }
                            --i;
                            assert (n == b.length);
                            String encoding = GitConfigUtil.getFileNameEncoding();
                            try {
                                rc.append(new String(b, encoding));
                                break;
                            }
                            catch (UnsupportedEncodingException e1) {
                                throw new IllegalStateException("The file name encoding is unsuported: " + encoding);
                            }
                        }
                        throw new VcsException("Unknown escape sequence '\\" + path.charAt(i) + "' in the path: " + path);
                    }
                }
                continue;
            }
            rc.append(c);
        }
        String string = rc.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "unescapePath"));
        }
        return string;
    }

    public static boolean justOneGitRepository(Project project) {
        if (project.isDisposed()) {
            return true;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        return !manager.moreThanOneRoot();
    }

    @Nullable
    public static GitRemote findRemoteByName(@NotNull GitRepository repository, @NotNull String name) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitUtil", "findRemoteByName"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/GitUtil", "findRemoteByName"));
        }
        return GitUtil.findRemoteByName(repository.getRemotes(), name);
    }

    @Nullable
    public static GitRemote findRemoteByName(Collection<GitRemote> remotes, final @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "git4idea/GitUtil", "findRemoteByName"));
        }
        return (GitRemote)ContainerUtil.find(remotes, (Condition)new Condition<GitRemote>(){

            public boolean value(GitRemote remote) {
                return remote.getName().equals(name);
            }
        });
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull GitRepository repository, final @NotNull GitRemote remote, final @NotNull String nameAtRemote) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitUtil", "findRemoteBranch"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/GitUtil", "findRemoteBranch"));
        }
        if (nameAtRemote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameAtRemote", "git4idea/GitUtil", "findRemoteBranch"));
        }
        return (GitRemoteBranch)ContainerUtil.find(repository.getBranches().getRemoteBranches(), (Condition)new Condition<GitRemoteBranch>(){

            public boolean value(GitRemoteBranch remoteBranch) {
                return remoteBranch.getRemote().equals(remote) && remoteBranch.getNameForRemoteOperations().equals(GitBranchUtil.stripRefsPrefix(nameAtRemote));
            }
        });
    }

    @NotNull
    public static GitRemoteBranch findOrCreateRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitUtil", "findOrCreateRemoteBranch"));
        }
        if (remote == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remote", "git4idea/GitUtil", "findOrCreateRemoteBranch"));
        }
        if (branchName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchName", "git4idea/GitUtil", "findOrCreateRemoteBranch"));
        }
        GitRemoteBranch remoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        GitRemoteBranch gitRemoteBranch = (GitRemoteBranch)ObjectUtils.notNull((Object)remoteBranch, (Object)new GitStandardRemoteBranch(remote, branchName));
        if (gitRemoteBranch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "findOrCreateRemoteBranch"));
        }
        return gitRemoteBranch;
    }

    @Nullable
    public static GitRemote findOrigin(Collection<GitRemote> remotes) {
        for (GitRemote remote : remotes) {
            if (!remote.getName().equals("origin")) continue;
            return remote;
        }
        return null;
    }

    @NotNull
    public static Collection<VirtualFile> getRootsFromRepositories(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/GitUtil", "getRootsFromRepositories"));
        }
        List list = ContainerUtil.map(repositories, REPOSITORY_TO_ROOT);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getRootsFromRepositories"));
        }
        return list;
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesFromRoots(@NotNull GitRepositoryManager repositoryManager, @NotNull Collection<VirtualFile> roots) {
        if (repositoryManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositoryManager", "git4idea/GitUtil", "getRepositoriesFromRoots"));
        }
        if (roots == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "roots", "git4idea/GitUtil", "getRepositoriesFromRoots"));
        }
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(roots.size());
        for (VirtualFile root : roots) {
            GitRepository repo = (GitRepository)repositoryManager.getRepositoryForRoot(root);
            if (repo == null) {
                LOG.error("Repository not found for root " + root);
                continue;
            }
            repositories.add(repo);
        }
        ArrayList<GitRepository> arrayList = repositories;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getRepositoriesFromRoots"));
        }
        return arrayList;
    }

    @NotNull
    public static Collection<String> getPathsDiffBetweenRefs(@NotNull Git git, @NotNull GitRepository repository, @NotNull String beforeRef, @NotNull String afterRef) throws VcsException {
        String range;
        if (git == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "git", "git4idea/GitUtil", "getPathsDiffBetweenRefs"));
        }
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitUtil", "getPathsDiffBetweenRefs"));
        }
        if (beforeRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "beforeRef", "git4idea/GitUtil", "getPathsDiffBetweenRefs"));
        }
        if (afterRef == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterRef", "git4idea/GitUtil", "getPathsDiffBetweenRefs"));
        }
        List<String> parameters = Arrays.asList("--name-only", "--pretty=format:");
        GitCommandResult result = git.diff(repository, parameters, range = beforeRef + ".." + afterRef);
        if (!result.success()) {
            LOG.info(String.format("Couldn't get diff in range [%s] for repository [%s]", range, repository.toLogString()));
            List<String> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getPathsDiffBetweenRefs"));
            }
            return list;
        }
        HashSet<String> remoteChanges = new HashSet<String>();
        StringScanner s = new StringScanner(result.getOutputAsJoinedString());
        while (s.hasMoreData()) {
            String relative = s.line();
            if (StringUtil.isEmptyOrSpaces((String)relative)) continue;
            String path = repository.getRoot().getPath() + "/" + GitUtil.unescapePath(relative);
            remoteChanges.add(path);
        }
        HashSet<String> hashSet = remoteChanges;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getPathsDiffBetweenRefs"));
        }
        return hashSet;
    }

    @NotNull
    public static GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUtil", "getRepositoryManager"));
        }
        GitRepositoryManager gitRepositoryManager = (GitRepositoryManager)((Object)ServiceManager.getService((Project)project, GitRepositoryManager.class));
        if (gitRepositoryManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getRepositoryManager"));
        }
        return gitRepositoryManager;
    }

    @Nullable
    public static GitRepository getRepositoryForRootOrLogError(@NotNull Project project, @NotNull VirtualFile root) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUtil", "getRepositoryForRootOrLogError"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUtil", "getRepositoryForRootOrLogError"));
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)manager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository is null for root " + root);
        }
        return repository;
    }

    @NotNull
    public static String getPrintableRemotes(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/GitUtil", "getPrintableRemotes"));
        }
        String string = StringUtil.join(remotes, (com.intellij.util.Function)new com.intellij.util.Function<GitRemote, String>(){

            public String fun(GitRemote remote) {
                return remote.getName() + ": [" + StringUtil.join(remote.getUrls(), (String)", ") + "]";
            }
        }, (String)"\n");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getPrintableRemotes"));
        }
        return string;
    }

    public static void showSubmittedFiles(final Project project, final String revision, final VirtualFile file, final boolean local, final boolean revertable) {
        new Task.Backgroundable(project, GitBundle.message("changes.retrieving", revision)){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "git4idea/GitUtil$6", "run"));
                }
                indicator.setIndeterminate(true);
                try {
                    VirtualFile vcsRoot = GitUtil.getGitRoot(file);
                    GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(project, vcsRoot, revision, true, local, revertable);
                    if (changeList != null) {
                        UIUtil.invokeLaterIfNeeded((Runnable)new Runnable((CommittedChangeList)changeList){
                            final /* synthetic */ CommittedChangeList val$changeList;
                            {
                                this.val$changeList = committedChangeList;
                            }

                            @Override
                            public void run() {
                                AbstractVcsHelper.getInstance((Project)project).showChangesListBrowser(this.val$changeList, GitBundle.message("paths.affected.title", revision));
                            }
                        });
                    }
                }
                catch (VcsException e) {
                    UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            GitUIUtil.showOperationError(project, e, "git show");
                        }
                    });
                }
            }
        }.queue();
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForCurrentBranch(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitUtil", "getTrackInfoForCurrentBranch"));
        }
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        return GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesForFiles(@NotNull Project project, @NotNull Collection<VirtualFile> files) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUtil", "getRepositoriesForFiles"));
        }
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/GitUtil", "getRepositoriesForFiles"));
        }
        final GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        Function<VirtualFile, GitRepository> ROOT_TO_REPO = new Function<VirtualFile, GitRepository>(){

            public GitRepository apply(@Nullable VirtualFile root) {
                return root != null ? (GitRepository)manager.getRepositoryForRoot(root) : null;
            }
        };
        Collection collection = Collections2.filter((Collection)Collections2.transform(GitUtil.sortFilesByGitRootsIgnoringOthers(files).keySet(), (Function)ROOT_TO_REPO), (Predicate)Predicates.notNull());
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getRepositoriesForFiles"));
        }
        return collection;
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRootsIgnoringOthers(@NotNull Collection<VirtualFile> files) {
        Map<VirtualFile, List<VirtualFile>> map;
        if (files == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "files", "git4idea/GitUtil", "sortFilesByGitRootsIgnoringOthers"));
        }
        try {
            map = GitUtil.sortFilesByGitRoot(files, true);
        }
        catch (VcsException e) {
            LOG.error("Should never happen, since we passed 'ignore non-git' parameter", (Throwable)e);
            Map<VirtualFile, List<VirtualFile>> map2 = Collections.emptyMap();
            if (map2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "sortFilesByGitRootsIgnoringOthers"));
            }
            return map2;
        }
        if (map == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "sortFilesByGitRootsIgnoringOthers"));
        }
        return map;
    }

    public static boolean hasLocalChanges(boolean staged, Project project, VirtualFile root) throws VcsException {
        GitSimpleHandler diff = new GitSimpleHandler(project, root, GitCommand.DIFF);
        diff.addParameters("--name-only");
        if (staged) {
            diff.addParameters("--cached");
        }
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        String output = diff.run();
        return !output.trim().isEmpty();
    }

    @Nullable
    public static VirtualFile findRefreshFileOrLog(@NotNull String absolutePath) {
        if (absolutePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "absolutePath", "git4idea/GitUtil", "findRefreshFileOrLog"));
        }
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(absolutePath);
        if (file == null) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(absolutePath);
        }
        if (file == null) {
            LOG.warn("VirtualFile not found for " + absolutePath);
        }
        return file;
    }

    @NotNull
    public static String toAbsolute(@NotNull VirtualFile root, @NotNull String relativePath) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUtil", "toAbsolute"));
        }
        if (relativePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePath", "git4idea/GitUtil", "toAbsolute"));
        }
        String string = StringUtil.trimEnd((String)root.getPath(), (String)"/") + "/" + StringUtil.trimStart((String)relativePath, (String)"/");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "toAbsolute"));
        }
        return string;
    }

    @NotNull
    public static Collection<String> toAbsolute(final @NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUtil", "toAbsolute"));
        }
        if (relativePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "relativePaths", "git4idea/GitUtil", "toAbsolute"));
        }
        List list = ContainerUtil.map(relativePaths, (com.intellij.util.Function)new com.intellij.util.Function<String, String>(){

            public String fun(String s) {
                return GitUtil.toAbsolute(root, s);
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "toAbsolute"));
        }
        return list;
    }

    @NotNull
    public static List<Change> findLocalChangesForPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> affectedPaths, boolean relativePaths) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUtil", "findLocalChangesForPaths"));
        }
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUtil", "findLocalChangesForPaths"));
        }
        if (affectedPaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "affectedPaths", "git4idea/GitUtil", "findLocalChangesForPaths"));
        }
        ChangeListManagerEx changeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        ArrayList<Change> affectedChanges = new ArrayList<Change>();
        for (String path : affectedPaths) {
            String absolutePath = relativePaths ? GitUtil.toAbsolute(root, path) : path;
            VirtualFile file = GitUtil.findRefreshFileOrLog(absolutePath);
            if (file == null) continue;
            Change change = changeListManager.getChange(file);
            if (change != null) {
                affectedChanges.add(change);
                continue;
            }
            String message = "Change is not found for " + file.getPath();
            if (changeListManager.isInUpdate()) {
                message = message + " because ChangeListManager is being updated.";
                LOG.debug(message);
                continue;
            }
            LOG.info(message);
        }
        ArrayList<Change> arrayList = affectedChanges;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "findLocalChangesForPaths"));
        }
        return arrayList;
    }

    public static void showPathsInDialog(@NotNull Project project, @NotNull Collection<String> absolutePaths, @NotNull String title, @Nullable String description) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUtil", "showPathsInDialog"));
        }
        if (absolutePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "absolutePaths", "git4idea/GitUtil", "showPathsInDialog"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "git4idea/GitUtil", "showPathsInDialog"));
        }
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel((JComponent)new GitSimplePathsBrowser(project, absolutePaths));
        if (description != null) {
            builder.setNorthPanel((JComponent)new MultiLineLabel(description));
        }
        builder.addOkAction();
        builder.setTitle(title);
        builder.show();
    }

    @NotNull
    public static String cleanupErrorPrefixes(@NotNull String msg) {
        if (msg == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "msg", "git4idea/GitUtil", "cleanupErrorPrefixes"));
        }
        String[] PREFIXES = new String[]{"fatal:", "error:"};
        msg = msg.trim();
        for (String prefix : PREFIXES) {
            if (!msg.startsWith(prefix)) continue;
            msg = msg.substring(prefix.length()).trim();
        }
        String string = msg;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "cleanupErrorPrefixes"));
        }
        return string;
    }

    @Nullable
    public static GitRemote getDefaultRemote(@NotNull Collection<GitRemote> remotes) {
        if (remotes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "remotes", "git4idea/GitUtil", "getDefaultRemote"));
        }
        for (GitRemote remote : remotes) {
            if (!remote.getName().equals("origin")) continue;
            return remote;
        }
        return null;
    }

    @NotNull
    public static String joinToHtml(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/GitUtil", "joinToHtml"));
        }
        String string = StringUtil.join(repositories, (com.intellij.util.Function)new com.intellij.util.Function<GitRepository, String>(){

            public String fun(GitRepository repository) {
                return repository.getPresentableUrl();
            }
        }, (String)"<br/>");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "joinToHtml"));
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull GitRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repository", "git4idea/GitUtil", "mention"));
        }
        String string = GitUtil.getRepositoryManager(repository.getProject()).moreThanOneRoot() ? " in " + DvcsUtil.getShortRepositoryName((Repository)repository) : "";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "mention"));
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/GitUtil", "mention"));
        }
        String string = GitUtil.mention(repositories, -1);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "mention"));
        }
        return string;
    }

    @NotNull
    public static String mention(@NotNull Collection<GitRepository> repositories, int limit) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/GitUtil", "mention"));
        }
        if (repositories.isEmpty()) {
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "mention"));
            }
            return "";
        }
        String string = " in " + DvcsUtil.joinShortNames(repositories, (int)limit);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "mention"));
        }
        return string;
    }

    public static void updateRepositories(@NotNull Collection<GitRepository> repositories) {
        if (repositories == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "repositories", "git4idea/GitUtil", "updateRepositories"));
        }
        for (GitRepository repository : repositories) {
            repository.update();
        }
    }

    public static boolean hasGitRepositories(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUtil", "hasGitRepositories"));
        }
        return !GitUtil.getRepositories(project).isEmpty();
    }

    @NotNull
    public static Collection<GitRepository> getRepositories(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "git4idea/GitUtil", "getRepositories"));
        }
        List<GitRepository> list = GitUtil.getRepositoryManager(project).getRepositories();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getRepositories"));
        }
        return list;
    }

    public static boolean isCaseOnlyChange(@NotNull String oldPath, @NotNull String newPath) {
        if (oldPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldPath", "git4idea/GitUtil", "isCaseOnlyChange"));
        }
        if (newPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newPath", "git4idea/GitUtil", "isCaseOnlyChange"));
        }
        if (oldPath.equalsIgnoreCase(newPath)) {
            if (oldPath.equals(newPath)) {
                LOG.error("Comparing perfectly equal paths: " + newPath);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static String getLogString(@NotNull String root, @NotNull Collection<Change> changes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUtil", "getLogString"));
        }
        if (changes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changes", "git4idea/GitUtil", "getLogString"));
        }
        String string = StringUtil.join(changes, change -> {
            if (root == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUtil", "lambda$getLogString$0"));
            }
            ContentRevision after = change.getAfterRevision();
            ContentRevision before = change.getBeforeRevision();
            switch (change.getType()) {
                case NEW: {
                    return "A: " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)after));
                }
                case DELETED: {
                    return "D: " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)before));
                }
                case MOVED: {
                    return "M: " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)before)) + " -> " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)after));
                }
            }
            return "M: " + GitUtil.getRelativePath(root, (ContentRevision)ObjectUtils.assertNotNull((Object)after));
        }, (String)", ");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "getLogString"));
        }
        return string;
    }

    @Nullable
    public static String getRelativePath(@NotNull String root, @NotNull ContentRevision after) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "git4idea/GitUtil", "getRelativePath"));
        }
        if (after == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "after", "git4idea/GitUtil", "getRelativePath"));
        }
        return FileUtil.getRelativePath((String)root, (String)after.getFile().getPath(), (char)File.separatorChar);
    }

    @NotNull
    public static Collection<Change> findCorrespondentLocalChanges(@NotNull ChangeListManager changeListManager, @NotNull Collection<Change> originalChanges) {
        if (changeListManager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "changeListManager", "git4idea/GitUtil", "findCorrespondentLocalChanges"));
        }
        if (originalChanges == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalChanges", "git4idea/GitUtil", "findCorrespondentLocalChanges"));
        }
        OpenTHashSet allChanges = new OpenTHashSet(changeListManager.getAllChanges());
        List list = ContainerUtil.mapNotNull(originalChanges, arg_0 -> ((OpenTHashSet)allChanges).get(arg_0));
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "git4idea/GitUtil", "findCorrespondentLocalChanges"));
        }
        return list;
    }
}

