/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.incremental.BinaryContent;

public class CompiledClass
extends UserDataHolderBase {
    private static final Logger LOG = Logger.getInstance(CompiledClass.class);
    @NotNull
    private final File myOutputFile;
    @NotNull
    private final Collection<File> mySourceFiles;
    @Nullable
    private final String myClassName;
    @NotNull
    private BinaryContent myContent;
    private boolean myIsDirty;

    public CompiledClass(@NotNull File outputFile, @NotNull Collection<File> sourceFiles, @Nullable String className, @NotNull BinaryContent content) {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        if (sourceFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFiles", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        this.myIsDirty = false;
        this.myOutputFile = outputFile;
        this.mySourceFiles = sourceFiles;
        this.myClassName = className;
        this.myContent = content;
        LOG.assertTrue(!this.mySourceFiles.isEmpty());
    }

    public CompiledClass(@NotNull File outputFile, @NotNull File sourceFile, @Nullable String className, @NotNull BinaryContent content) {
        if (outputFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outputFile", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        if (sourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceFile", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/jps/incremental/CompiledClass", "<init>"));
        }
        this(outputFile, Collections.singleton(sourceFile), className, content);
    }

    public void save() throws IOException {
        this.myContent.saveToFile(this.myOutputFile);
        this.myIsDirty = false;
    }

    @NotNull
    public File getOutputFile() {
        File file = this.myOutputFile;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/CompiledClass", "getOutputFile"));
        }
        return file;
    }

    @NotNull
    public Collection<File> getSourceFiles() {
        Collection<File> collection = this.mySourceFiles;
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/CompiledClass", "getSourceFiles"));
        }
        return collection;
    }

    @NotNull
    public List<String> getSourceFilesPaths() {
        List list = ContainerUtil.map(this.mySourceFiles, (Function)new Function<File, String>(){

            public String fun(File file) {
                return file.getPath();
            }
        });
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/CompiledClass", "getSourceFilesPaths"));
        }
        return list;
    }

    @Deprecated
    @NotNull
    public File getSourceFile() {
        File file = (File)ContainerUtil.getFirstItem(this.getSourceFiles());
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/CompiledClass", "getSourceFile"));
        }
        return file;
    }

    @Nullable
    public String getClassName() {
        return this.myClassName;
    }

    @NotNull
    public BinaryContent getContent() {
        BinaryContent binaryContent = this.myContent;
        if (binaryContent == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/CompiledClass", "getContent"));
        }
        return binaryContent;
    }

    public void setContent(@NotNull BinaryContent content) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "org/jetbrains/jps/incremental/CompiledClass", "setContent"));
        }
        this.myContent = content;
        this.myIsDirty = true;
    }

    public boolean isDirty() {
        return this.myIsDirty;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CompiledClass aClass = (CompiledClass)((Object)o);
        return FileUtil.filesEqual((File)this.myOutputFile, (File)aClass.myOutputFile);
    }

    public int hashCode() {
        return FileUtil.fileHashCode((File)this.myOutputFile);
    }

    public String toString() {
        return "CompiledClass{myOutputFile=" + this.myOutputFile + ", mySourceFiles=" + this.mySourceFiles + ", myIsDirty=" + this.myIsDirty + '}';
    }
}

