/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.java;

import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.incremental.ResourcesTarget;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsCompilerExcludes;

public class ResourceRootDescriptor
extends BuildRootDescriptor {
    @NotNull
    private final File myRoot;
    @NotNull
    private final ResourcesTarget myTarget;
    @NotNull
    private final String myPackagePrefix;
    @NotNull
    private final Set<File> myExcludes;

    public ResourceRootDescriptor(@NotNull File root, @NotNull ResourcesTarget target, @NotNull String packagePrefix, @NotNull Set<File> excludes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "org/jetbrains/jps/builders/java/ResourceRootDescriptor", "<init>"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/jps/builders/java/ResourceRootDescriptor", "<init>"));
        }
        if (packagePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packagePrefix", "org/jetbrains/jps/builders/java/ResourceRootDescriptor", "<init>"));
        }
        if (excludes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "excludes", "org/jetbrains/jps/builders/java/ResourceRootDescriptor", "<init>"));
        }
        this.myPackagePrefix = packagePrefix;
        this.myRoot = root;
        this.myTarget = target;
        this.myExcludes = excludes;
    }

    @Override
    public File getRootFile() {
        return this.myRoot;
    }

    @Override
    @NotNull
    public Set<File> getExcludedRoots() {
        Set<File> set = this.myExcludes;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/ResourceRootDescriptor", "getExcludedRoots"));
        }
        return set;
    }

    @NotNull
    public ResourcesTarget getTarget() {
        ResourcesTarget resourcesTarget = this.myTarget;
        if (resourcesTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/ResourceRootDescriptor", "getTarget"));
        }
        return resourcesTarget;
    }

    @NotNull
    public String getPackagePrefix() {
        String string = this.myPackagePrefix;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/ResourceRootDescriptor", "getPackagePrefix"));
        }
        return string;
    }

    @Override
    @NotNull
    public FileFilter createFileFilter() {
        JpsProject project = this.getTarget().getModule().getProject();
        final JpsCompilerExcludes excludes = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project).getCompilerExcludes();
        FileFilter fileFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return !excludes.isExcluded(file);
            }
        };
        if (fileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/builders/java/ResourceRootDescriptor", "createFileFilter"));
        }
        return fileFilter;
    }

    @Override
    public boolean isGenerated() {
        return false;
    }

    public String toString() {
        return "ResourceRootDescriptor{target='" + this.myTarget + '\'' + ", root=" + this.myRoot + '}';
    }

    @Override
    public boolean canUseFileCache() {
        return true;
    }

    @Override
    public String getRootId() {
        return FileUtil.toSystemIndependentName((String)this.myRoot.getPath());
    }
}

