/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import java.io.File;
import java.io.FileFilter;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.java.ResourceRootDescriptor;
import org.jetbrains.jps.cmdline.ProjectDescriptor;
import org.jetbrains.jps.incremental.groovy.CheckResourcesTarget;

class GroovyResourceRootDescriptor
extends BuildRootDescriptor {
    private final CheckResourcesTarget myTarget;
    private final ResourceRootDescriptor myDescriptor;

    GroovyResourceRootDescriptor(ResourceRootDescriptor descriptor, CheckResourcesTarget target) {
        this.myDescriptor = descriptor;
        this.myTarget = target;
    }

    @NotNull
    public CheckResourcesTarget getTarget() {
        CheckResourcesTarget checkResourcesTarget = this.myTarget;
        if (checkResourcesTarget == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyResourceRootDescriptor", "getTarget"));
        }
        return checkResourcesTarget;
    }

    @NotNull
    public String getPackagePrefix() {
        String string = this.myDescriptor.getPackagePrefix();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyResourceRootDescriptor", "getPackagePrefix"));
        }
        return string;
    }

    @NotNull
    public FileFilter createFileFilter() {
        FileFilter fileFilter = this.myDescriptor.createFileFilter();
        if (fileFilter == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyResourceRootDescriptor", "createFileFilter"));
        }
        return fileFilter;
    }

    public boolean isGenerated() {
        return this.myDescriptor.isGenerated();
    }

    public String toString() {
        return this.myDescriptor.toString();
    }

    public boolean canUseFileCache() {
        return this.myDescriptor.canUseFileCache();
    }

    public String getRootId() {
        return this.myDescriptor.getRootId();
    }

    public File getRootFile() {
        return this.myDescriptor.getRootFile();
    }

    public FileFilter createFileFilter(@NotNull ProjectDescriptor descriptor) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "org/jetbrains/jps/incremental/groovy/GroovyResourceRootDescriptor", "createFileFilter"));
        }
        return this.myDescriptor.createFileFilter(descriptor);
    }

    @NotNull
    public Set<File> getExcludedRoots() {
        Set set = this.myDescriptor.getExcludedRoots();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/incremental/groovy/GroovyResourceRootDescriptor", "getExcludedRoots"));
        }
        return set;
    }
}

