/*
 * Decompiled with CFR 0.152.
 */
package org.opentest4j;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MultipleFailuresError
extends AssertionError {
    private static final long serialVersionUID = 1L;
    private final List<AssertionError> failures = new ArrayList<AssertionError>();
    private final String heading;

    public MultipleFailuresError(String heading) {
        this.heading = MultipleFailuresError.isBlank(heading) ? "Multiple Failures" : heading.trim();
    }

    public void addFailure(AssertionError failure) {
        this.failures.add(failure);
    }

    public String getMessage() {
        int failureCount = this.failures.size();
        if (failureCount == 0) {
            return this.heading;
        }
        StringBuilder builder = new StringBuilder(this.heading).append(" (").append(failureCount).append(" ").append(MultipleFailuresError.pluralize(failureCount, "failure", "failures")).append(")\n");
        int lastIndex = failureCount - 1;
        for (AssertionError failure : this.failures.subList(0, lastIndex)) {
            builder.append("\t").append(MultipleFailuresError.nullSafeMessage(failure)).append("\n");
        }
        builder.append('\t').append(MultipleFailuresError.nullSafeMessage(this.failures.get(lastIndex)));
        return builder.toString();
    }

    public List<AssertionError> getFailures() {
        return Collections.unmodifiableList(this.failures);
    }

    public boolean hasFailures() {
        return !this.failures.isEmpty();
    }

    private static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static String pluralize(int count, String singular, String plural) {
        return count == 1 ? singular : plural;
    }

    private static String nullSafeMessage(AssertionError failure) {
        if (MultipleFailuresError.isBlank(((Throwable)((Object)failure)).getMessage())) {
            return "<no message> in " + failure.getClass().getName();
        }
        return ((Throwable)((Object)failure)).getMessage();
    }
}

