/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.coverage;

import com.intellij.coverage.BaseCoverageSuite;
import com.intellij.coverage.CoverageAnnotator;
import com.intellij.coverage.CoverageEngine;
import com.intellij.coverage.CoverageSuite;
import com.intellij.coverage.LineMarkerRendererWithErrorStripe;
import com.intellij.execution.configurations.ModuleBasedConfiguration;
import com.intellij.execution.configurations.RunConfigurationBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootModificationTracker;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScopesCore;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.reference.SoftReference;
import com.intellij.rt.coverage.data.CoverageData;
import com.intellij.rt.coverage.data.LineData;
import com.intellij.rt.coverage.data.ProjectData;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.Function;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CoverageSuitesBundle {
    private CoverageSuite[] mySuites;
    private CoverageEngine myEngine;
    private Set<Module> myProcessedModules;
    private CachedValue<GlobalSearchScope> myCachedValue;
    private SoftReference<ProjectData> myData = new SoftReference(null);
    private static final Logger LOG = Logger.getInstance((String)("#" + CoverageSuitesBundle.class.getName()));

    public CoverageSuitesBundle(CoverageSuite suite) {
        this(new CoverageSuite[]{suite});
    }

    public CoverageSuitesBundle(CoverageSuite[] suites) {
        this.mySuites = suites;
        LOG.assertTrue(this.mySuites.length > 0);
        this.myEngine = this.mySuites[0].getCoverageEngine();
        for (CoverageSuite suite : suites) {
            CoverageEngine engine = suite.getCoverageEngine();
            LOG.assertTrue(Comparing.equal((Object)engine, (Object)this.myEngine));
        }
    }

    public boolean isValid() {
        for (CoverageSuite suite : this.mySuites) {
            if (suite.isValid()) continue;
            return false;
        }
        return true;
    }

    public long getLastCoverageTimeStamp() {
        long max = 0L;
        for (CoverageSuite suite : this.mySuites) {
            max = Math.max(max, suite.getLastCoverageTimeStamp());
        }
        return max;
    }

    public boolean isCoverageByTestApplicable() {
        for (CoverageSuite suite : this.mySuites) {
            if (!suite.isCoverageByTestApplicable()) continue;
            return true;
        }
        return false;
    }

    public boolean isCoverageByTestEnabled() {
        for (CoverageSuite suite : this.mySuites) {
            if (!suite.isCoverageByTestEnabled()) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public ProjectData getCoverageData() {
        ProjectData projectData = (ProjectData)this.myData.get();
        if (projectData != null) {
            return projectData;
        }
        ProjectData data = new ProjectData();
        for (CoverageSuite suite : this.mySuites) {
            ProjectData coverageData = suite.getCoverageData(null);
            if (coverageData == null) continue;
            data.merge((CoverageData)coverageData);
        }
        this.myData = new SoftReference((Object)data);
        return data;
    }

    public boolean isTrackTestFolders() {
        for (CoverageSuite suite : this.mySuites) {
            if (!suite.isTrackTestFolders()) continue;
            return true;
        }
        return false;
    }

    public boolean isTracingEnabled() {
        for (CoverageSuite suite : this.mySuites) {
            if (!suite.isTracingEnabled()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public CoverageEngine getCoverageEngine() {
        CoverageEngine coverageEngine = this.myEngine;
        if (coverageEngine == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/coverage/CoverageSuitesBundle", "getCoverageEngine"));
        }
        return coverageEngine;
    }

    public LineMarkerRendererWithErrorStripe getLineMarkerRenderer(int lineNumber, @Nullable String className, TreeMap<Integer, LineData> lines, boolean coverageByTestApplicable, @NotNull CoverageSuitesBundle coverageSuite, Function<Integer, Integer> newToOldConverter, Function<Integer, Integer> oldToNewConverter, boolean subCoverageActive) {
        if (coverageSuite == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "coverageSuite", "com/intellij/coverage/CoverageSuitesBundle", "getLineMarkerRenderer"));
        }
        return this.myEngine.getLineMarkerRenderer(lineNumber, className, lines, coverageByTestApplicable, coverageSuite, newToOldConverter, oldToNewConverter, subCoverageActive);
    }

    public CoverageAnnotator getAnnotator(Project project) {
        return this.myEngine.getCoverageAnnotator(project);
    }

    public CoverageSuite[] getSuites() {
        return this.mySuites;
    }

    public boolean contains(CoverageSuite suite) {
        return ArrayUtilRt.find((Object[])this.mySuites, (Object)suite) > -1;
    }

    public void setCoverageData(ProjectData projectData) {
        this.myData = new SoftReference((Object)projectData);
    }

    public void restoreCoverageData() {
        this.myData = new SoftReference(null);
    }

    public String getPresentableName() {
        return StringUtil.join((Object[])this.mySuites, coverageSuite -> coverageSuite.getPresentableName(), (String)", ");
    }

    public boolean isModuleChecked(Module module) {
        return this.myProcessedModules != null && this.myProcessedModules.contains(module);
    }

    public void checkModule(Module module) {
        if (this.myProcessedModules == null) {
            this.myProcessedModules = new HashSet<Module>();
        }
        this.myProcessedModules.add(module);
    }

    @Nullable
    public RunConfigurationBase getRunConfiguration() {
        for (CoverageSuite suite : this.mySuites) {
            RunConfigurationBase configuration;
            if (!(suite instanceof BaseCoverageSuite) || (configuration = ((BaseCoverageSuite)suite).getConfiguration()) == null) continue;
            return configuration;
        }
        return null;
    }

    public GlobalSearchScope getSearchScope(Project project) {
        if (this.myCachedValue == null) {
            this.myCachedValue = CachedValuesManager.getManager((Project)project).createCachedValue(() -> new CachedValueProvider.Result((Object)this.getSearchScopeInner(project), new Object[]{ProjectRootModificationTracker.getInstance((Project)project)}), false);
        }
        return (GlobalSearchScope)this.myCachedValue.getValue();
    }

    private GlobalSearchScope getSearchScopeInner(Project project) {
        Module module;
        RunConfigurationBase configuration = this.getRunConfiguration();
        if (configuration instanceof ModuleBasedConfiguration && (module = ((ModuleBasedConfiguration)configuration).getConfigurationModule().getModule()) != null) {
            return GlobalSearchScope.moduleRuntimeScope((Module)module, (boolean)this.isTrackTestFolders());
        }
        return this.isTrackTestFolders() ? GlobalSearchScope.projectScope((Project)project) : GlobalSearchScopesCore.projectProductionScope((Project)project);
    }
}

