/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.InvokeAfterUpdateMode;
import com.intellij.openapi.vcs.changes.LocalChangeList;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergerFactory;
import org.jetbrains.idea.svn.integrate.QuickMerge;
import org.jetbrains.idea.svn.integrate.SvnIntegrateChangesTask;
import org.jetbrains.idea.svn.integrate.WorkingCopyInfo;
import org.tmatesoft.svn.core.SVNURL;

public class MergeTask
extends BaseMergeTask {
    @NotNull
    private final MergerFactory myFactory;

    public MergeTask(@NotNull QuickMerge mergeProcess, @NotNull MergerFactory factory, @NotNull String mergeTitle) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/MergeTask", "<init>"));
        }
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "org/jetbrains/idea/svn/integrate/MergeTask", "<init>"));
        }
        if (mergeTitle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeTitle", "org/jetbrains/idea/svn/integrate/MergeTask", "<init>"));
        }
        super(mergeProcess, mergeTitle, Where.AWT);
        this.myFactory = factory;
    }

    @Override
    public void run() {
        SVNURL sourceUrl = this.parseSourceUrl();
        if (sourceUrl != null) {
            this.next(TaskDescriptor.createForBackgroundableTask((Task.Backgroundable)this.newIntegrateTask(sourceUrl)));
            boolean needRefresh = this.setupDefaultEmptyChangeListForMerge();
            if (needRefresh) {
                this.refreshChanges();
            }
        }
    }

    @NotNull
    private SvnIntegrateChangesTask newIntegrateTask(@NotNull SVNURL branchUrl) {
        if (branchUrl == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "branchUrl", "org/jetbrains/idea/svn/integrate/MergeTask", "newIntegrateTask"));
        }
        SvnIntegrateChangesTask svnIntegrateChangesTask = new SvnIntegrateChangesTask(this.myMergeContext.getVcs(), new WorkingCopyInfo(this.myMergeContext.getWcInfo().getPath(), true), this.myFactory, branchUrl, this.getName(), false, this.myMergeContext.getBranchName());
        if (svnIntegrateChangesTask == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/MergeTask", "newIntegrateTask"));
        }
        return svnIntegrateChangesTask;
    }

    private boolean setupDefaultEmptyChangeListForMerge() {
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.myMergeContext.getProject());
        int i = 0;
        boolean needRefresh = false;
        while (true) {
            String name;
            LocalChangeList changeList;
            if ((changeList = changeListManager.findChangeList(name = this.myMergeContext.getTitle() + (i > 0 ? " (" + i + ")" : ""))) == null) {
                changeListManager.setDefaultChangeList(changeListManager.addChangeList(name, null));
                needRefresh = true;
                break;
            }
            if (changeList.getChanges().isEmpty()) {
                if (changeList.isDefault()) break;
                changeListManager.setDefaultChangeList(changeList);
                needRefresh = true;
                break;
            }
            ++i;
        }
        return needRefresh;
    }

    private void refreshChanges() {
        this.suspend();
        ChangeListManager.getInstance((Project)this.myMergeContext.getProject()).invokeAfterUpdate(this::ping, InvokeAfterUpdateMode.BACKGROUND_NOT_CANCELLABLE, "", ModalityState.NON_MODAL);
    }
}

