/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.integrate;

import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.continuation.TaskDescriptor;
import com.intellij.util.continuation.Where;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.integrate.BaseMergeTask;
import org.jetbrains.idea.svn.integrate.MergeAllOrSelectedChooserTask;
import org.jetbrains.idea.svn.integrate.QuickMerge;

public class CheckRepositorySupportsMergeInfoTask
extends BaseMergeTask {
    public CheckRepositorySupportsMergeInfoTask(@NotNull QuickMerge mergeProcess) {
        if (mergeProcess == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergeProcess", "org/jetbrains/idea/svn/integrate/CheckRepositorySupportsMergeInfoTask", "<init>"));
        }
        super(mergeProcess, "Checking repository capabilities", Where.POOLED);
    }

    @Override
    public void run() {
        this.next(this.supportsMergeInfo() ? this.getChooseMergeTypeTasks() : this.getMergeAllTasks(false));
    }

    private boolean supportsMergeInfo() {
        return this.myMergeContext.getWcInfo().getFormat().supportsMergeInfo() && SvnUtil.checkRepositoryVersion15(this.myMergeContext.getVcs(), this.myMergeContext.getSourceUrl());
    }

    @NotNull
    private List<TaskDescriptor> getChooseMergeTypeTasks() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new TaskDescriptor[]{new MergeAllOrSelectedChooserTask(this.myMergeProcess)});
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/integrate/CheckRepositorySupportsMergeInfoTask", "getChooseMergeTypeTasks"));
        }
        return arrayList;
    }
}

