/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.actions;

import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.MarkerVcsContentRevision;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Depth;
import org.jetbrains.idea.svn.difftool.properties.SvnPropertiesDiffRequest;
import org.jetbrains.idea.svn.history.SvnRepositoryContentRevision;
import org.jetbrains.idea.svn.properties.PropertyConsumer;
import org.jetbrains.idea.svn.properties.PropertyData;
import org.jetbrains.idea.svn.properties.PropertyValue;
import org.tmatesoft.svn.core.SVNErrorCode;
import org.tmatesoft.svn.core.SVNErrorMessage;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc2.SvnTarget;

public abstract class AbstractShowPropertiesDiffAction
extends AnAction
implements DumbAware {
    private static final String ourPropertiesDelimiter = "\n";

    protected AbstractShowPropertiesDiffAction(String name) {
        super(name);
    }

    protected abstract DataKey<Change[]> getChangesKey();

    @Nullable
    protected abstract SVNRevision getBeforeRevisionValue(Change var1, SvnVcs var2) throws SVNException;

    @Nullable
    protected abstract SVNRevision getAfterRevisionValue(Change var1, SvnVcs var2) throws SVNException;

    public void update(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Presentation presentation = e.getPresentation();
        Change[] data = (Change[])VcsDataKeys.CHANGES.getData(dataContext);
        boolean showAction = AbstractShowPropertiesDiffAction.checkThatChangesAreUnderSvn(data);
        presentation.setVisible(data != null && showAction);
        presentation.setEnabled(showAction);
    }

    private static boolean checkThatChangesAreUnderSvn(@Nullable Change[] changes) {
        boolean result = false;
        if (changes != null) {
            result = ContainerUtil.or((Object[])changes, (Condition)new Condition<Change>(){

                public boolean value(Change change) {
                    return AbstractShowPropertiesDiffAction.isUnderSvn(change.getBeforeRevision()) || AbstractShowPropertiesDiffAction.isUnderSvn(change.getAfterRevision());
                }
            });
        }
        return result;
    }

    private static boolean isUnderSvn(@Nullable ContentRevision revision) {
        return revision instanceof MarkerVcsContentRevision && SvnVcs.getKey().equals((Object)((MarkerVcsContentRevision)revision).getVcsKey());
    }

    public void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Change[] changes = (Change[])e.getData(this.getChangesKey());
        if (!AbstractShowPropertiesDiffAction.checkThatChangesAreUnderSvn(changes)) {
            return;
        }
        Change change = changes[0];
        CalculateAndShow worker = new CalculateAndShow(project, change, e.getPresentation().getText());
        ProgressManager.getInstance().run((Task)worker);
    }

    @NotNull
    private static String getDiffWindowTitle(@NotNull Change change) {
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getDiffWindowTitle"));
        }
        if (change.isMoved() || change.isRenamed()) {
            FilePath beforeFilePath = ChangesUtil.getBeforePath((Change)change);
            FilePath afterFilePath = ChangesUtil.getAfterPath((Change)change);
            String beforePath = beforeFilePath == null ? "" : beforeFilePath.getPath();
            String afterPath = afterFilePath == null ? "" : afterFilePath.getPath();
            String string = SvnBundle.message("action.Subversion.properties.difference.diff.for.move.title", beforePath, afterPath);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getDiffWindowTitle"));
            }
            return string;
        }
        String string = SvnBundle.message("action.Subversion.properties.difference.diff.title", ChangesUtil.getFilePath((Change)change).getPath());
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getDiffWindowTitle"));
        }
        return string;
    }

    private static int compareRevisions(@NotNull SVNRevision revision1, @NotNull SVNRevision revision2) {
        if (revision1 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision1", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "compareRevisions"));
        }
        if (revision2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "revision2", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "compareRevisions"));
        }
        if (revision1.equals((Object)revision2)) {
            return 0;
        }
        if (SVNRevision.WORKING.equals((Object)revision1)) {
            return 1;
        }
        if (SVNRevision.WORKING.equals((Object)revision2)) {
            return -1;
        }
        if (SVNRevision.HEAD.equals((Object)revision1)) {
            return 1;
        }
        if (SVNRevision.HEAD.equals((Object)revision2)) {
            return -1;
        }
        return revision1.getNumber() > revision2.getNumber() ? 1 : -1;
    }

    @NotNull
    private static String revisionToString(@Nullable SVNRevision revision) {
        String string = revision == null ? "not exists" : revision.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "revisionToString"));
        }
        return string;
    }

    @NotNull
    private static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @Nullable ContentRevision contentRevision, @Nullable SVNRevision revision) throws SVNException, VcsException {
        SvnTarget target;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        if (contentRevision == null) {
            List<PropertyData> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
            }
            return list;
        }
        if (contentRevision instanceof SvnRepositoryContentRevision) {
            SvnRepositoryContentRevision svnRevision = (SvnRepositoryContentRevision)contentRevision;
            target = SvnTarget.fromURL((SVNURL)SVNURL.parseURIEncoded((String)svnRevision.getFullPath()), (SVNRevision)revision);
        } else {
            File ioFile = contentRevision.getFile().getIOFile();
            target = SvnTarget.fromFile((File)ioFile, (SVNRevision)revision);
        }
        List<PropertyData> list = AbstractShowPropertiesDiffAction.getPropertyList(vcs, target, revision);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        return list;
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull SVNURL url, @Nullable SVNRevision revision) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        List<PropertyData> list = AbstractShowPropertiesDiffAction.getPropertyList(vcs, SvnTarget.fromURL((SVNURL)url, (SVNRevision)revision), revision);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        return list;
    }

    @NotNull
    public static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull File ioFile, @Nullable SVNRevision revision) throws SVNException {
        List<PropertyData> list;
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        if (ioFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ioFile", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        try {
            list = AbstractShowPropertiesDiffAction.getPropertyList(vcs, SvnTarget.fromFile((File)ioFile, (SVNRevision)revision), revision);
        }
        catch (VcsException e) {
            throw new SVNException(SVNErrorMessage.create((SVNErrorCode)SVNErrorCode.FS_GENERAL, (Throwable)e), (Throwable)e);
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        return list;
    }

    @NotNull
    private static List<PropertyData> getPropertyList(@NotNull SvnVcs vcs, @NotNull SvnTarget target, @Nullable SVNRevision revision) throws VcsException {
        if (vcs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vcs", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        ArrayList<PropertyData> lines = new ArrayList<PropertyData>();
        PropertyConsumer propertyHandler = AbstractShowPropertiesDiffAction.createHandler(revision, lines);
        vcs.getFactory(target).createPropertyClient().list(target, revision, Depth.EMPTY, propertyHandler);
        ArrayList<PropertyData> arrayList = lines;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "getPropertyList"));
        }
        return arrayList;
    }

    @NotNull
    private static PropertyConsumer createHandler(SVNRevision revision, final @NotNull List<PropertyData> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "createHandler"));
        }
        final ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        if (indicator != null) {
            indicator.checkCanceled();
            indicator.setText(SvnBundle.message("show.properties.diff.progress.text.revision.information", revision.toString()));
        }
        PropertyConsumer propertyConsumer = new PropertyConsumer(){

            @Override
            public void handleProperty(File path, PropertyData property) throws SVNException {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(SVNURL url, PropertyData property) throws SVNException {
                this.registerProperty(property);
            }

            @Override
            public void handleProperty(long revision, PropertyData property) throws SVNException {
            }

            private void registerProperty(@NotNull PropertyData property) {
                if (property == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction$2", "registerProperty"));
                }
                if (indicator != null) {
                    indicator.checkCanceled();
                    indicator.setText2(SvnBundle.message("show.properties.diff.progress.text2.property.information", property.getName()));
                }
                lines.add(property);
            }
        };
        if (propertyConsumer == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "createHandler"));
        }
        return propertyConsumer;
    }

    @NotNull
    public static String toSortedStringPresentation(@NotNull List<PropertyData> lines) {
        if (lines == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "lines", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "toSortedStringPresentation"));
        }
        StringBuilder sb = new StringBuilder();
        Collections.sort(lines, new Comparator<PropertyData>(){

            @Override
            public int compare(PropertyData o1, PropertyData o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        for (PropertyData line : lines) {
            AbstractShowPropertiesDiffAction.addPropertyPresentation(line, sb);
        }
        String string = sb.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "toSortedStringPresentation"));
        }
        return string;
    }

    private static void addPropertyPresentation(@NotNull PropertyData property, @NotNull StringBuilder sb) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "addPropertyPresentation"));
        }
        if (sb == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sb", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction", "addPropertyPresentation"));
        }
        if (sb.length() != 0) {
            sb.append(ourPropertiesDelimiter);
        }
        sb.append(property.getName()).append("=").append(StringUtil.notNullize((String)PropertyValue.toString(property.getValue())));
    }

    private class CalculateAndShow
    extends Task.Backgroundable {
        private final Change myChange;
        private List<PropertyData> myBeforeContent;
        private List<PropertyData> myAfterContent;
        private SVNRevision myBeforeRevisionValue;
        private SVNRevision myAfterRevision;
        private Exception myException;
        private final String myErrorTitle;

        private CalculateAndShow(Project project, Change change, String errorTitle) {
            super(project, SvnBundle.message("fetching.properties.contents.progress.title", new Object[0]), true, PerformInBackgroundOption.DEAF);
            this.myChange = change;
            this.myErrorTitle = errorTitle;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/idea/svn/actions/AbstractShowPropertiesDiffAction$CalculateAndShow", "run"));
            }
            SvnVcs vcs = SvnVcs.getInstance(this.myProject);
            try {
                this.myBeforeRevisionValue = AbstractShowPropertiesDiffAction.this.getBeforeRevisionValue(this.myChange, vcs);
                this.myAfterRevision = AbstractShowPropertiesDiffAction.this.getAfterRevisionValue(this.myChange, vcs);
                this.myBeforeContent = AbstractShowPropertiesDiffAction.getPropertyList(vcs, this.myChange.getBeforeRevision(), this.myBeforeRevisionValue);
                indicator.checkCanceled();
                this.myAfterContent = AbstractShowPropertiesDiffAction.getPropertyList(vcs, this.myChange.getAfterRevision(), this.myAfterRevision);
            }
            catch (SVNException exc) {
                this.myException = exc;
            }
            catch (VcsException exc) {
                this.myException = exc;
            }
        }

        public void onSuccess() {
            if (this.myException != null) {
                Messages.showErrorDialog((String)this.myException.getMessage(), (String)this.myErrorTitle);
                return;
            }
            if (this.myBeforeContent != null && this.myAfterContent != null && this.myBeforeRevisionValue != null && this.myAfterRevision != null) {
                SvnPropertiesDiffRequest diffRequest = AbstractShowPropertiesDiffAction.compareRevisions(this.myBeforeRevisionValue, this.myAfterRevision) > 0 ? new SvnPropertiesDiffRequest(AbstractShowPropertiesDiffAction.getDiffWindowTitle(this.myChange), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myAfterContent), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myBeforeContent), AbstractShowPropertiesDiffAction.revisionToString(this.myAfterRevision), AbstractShowPropertiesDiffAction.revisionToString(this.myBeforeRevisionValue)) : new SvnPropertiesDiffRequest(AbstractShowPropertiesDiffAction.getDiffWindowTitle(this.myChange), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myBeforeContent), (DiffContent)new SvnPropertiesDiffRequest.PropertyContent(this.myAfterContent), AbstractShowPropertiesDiffAction.revisionToString(this.myBeforeRevisionValue), AbstractShowPropertiesDiffAction.revisionToString(this.myAfterRevision));
                DiffManager.getInstance().showDiff(this.myProject, (DiffRequest)diffRequest);
            }
        }
    }
}

