/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import javax.swing.text.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultCaret
extends Rectangle
implements Caret,
FocusListener,
MouseListener,
MouseMotionListener {
    static JTextComponent componentWithSelection;
    private static final long serialVersionUID = 4325555698756477346L;
    public static final int ALWAYS_UPDATE = 2;
    public static final int NEVER_UPDATE = 1;
    public static final int UPDATE_WHEN_ON_EDT = 0;
    int policy = 0;
    protected ChangeEvent changeEvent = new ChangeEvent(this);
    protected EventListenerList listenerList = new EventListenerList();
    DocumentListener documentListener;
    PropertyChangeListener propertyChangeListener;
    JTextComponent textComponent;
    private boolean selectionVisible = true;
    private int blinkRate = 500;
    private int dot = 0;
    private int mark = 0;
    private Point magicCaretPosition = null;
    boolean visible = false;
    boolean active = true;
    private Object highlightEntry;
    private Timer blinkTimer;
    private BlinkTimerListener blinkListener;
    NavigationFilter.FilterBypass bypass;

    private NavigationFilter.FilterBypass getBypass() {
        return this.bypass == null ? (this.bypass = new Bypass()) : this.bypass;
    }

    public void setUpdatePolicy(int policy) {
        if (policy != 2 && policy != 1 && policy != 0) {
            throw new IllegalArgumentException("policy must be ALWAYS_UPDATE, NEVER__UPDATE, or UPDATE_WHEN_ON_EDT");
        }
        this.policy = policy;
    }

    public int getUpdatePolicy() {
        return this.policy;
    }

    @Override
    public void mouseDragged(MouseEvent event) {
        if (event.getButton() == 1) {
            if (this.textComponent.isEnabled()) {
                this.moveCaret(event);
            } else {
                this.positionCaret(event);
            }
        }
    }

    @Override
    public void mouseMoved(MouseEvent event) {
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        if (!this.textComponent.isEnabled()) {
            return;
        }
        int count = event.getClickCount();
        if (event.getButton() == 1 && count >= 2) {
            int newDot = this.getComponent().viewToModel(event.getPoint());
            JTextComponent t = this.getComponent();
            try {
                if (count == 3) {
                    this.setDot(Utilities.getRowStart(t, newDot));
                    this.moveDot(Utilities.getRowEnd(t, newDot));
                } else {
                    int wordStart = Utilities.getWordStart(t, newDot);
                    if (newDot == wordStart) {
                        this.setDot(wordStart);
                        this.moveDot(Utilities.getWordEnd(t, wordStart));
                    } else {
                        int nextWord = Utilities.getNextWord(t, newDot);
                        int previousWord = Utilities.getPreviousWord(t, newDot);
                        int previousWordEnd = Utilities.getWordEnd(t, previousWord);
                        if (newDot >= previousWordEnd && newDot <= nextWord) {
                            this.setDot(previousWordEnd);
                            this.moveDot(nextWord);
                        } else {
                            this.setDot(previousWord);
                            this.moveDot(previousWordEnd);
                        }
                    }
                }
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void mousePressed(MouseEvent event) {
        if (SwingUtilities.isLeftMouseButton(event)) {
            if (event.isShiftDown() && this.getDot() != -1) {
                this.moveCaret(event);
            } else {
                this.positionCaret(event);
            }
            if (this.textComponent != null && this.textComponent.isEnabled() && this.textComponent.isRequestFocusEnabled()) {
                this.textComponent.requestFocus();
            }
        } else if (event.getButton() == 2 && !event.isShiftDown()) {
            this.positionCaret(event);
            this.textComponent.paste();
        }
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void focusGained(FocusEvent event) {
        if (this.textComponent.isEditable()) {
            this.setVisible(true);
            this.updateTimerStatus();
        }
    }

    @Override
    public void focusLost(FocusEvent event) {
        if (this.textComponent.isEditable() && !event.isTemporary()) {
            this.setVisible(false);
            if (this.blinkTimer != null && this.blinkTimer.isRunning()) {
                this.blinkTimer.stop();
            }
        }
    }

    private void updateTimerStatus() {
        if (this.textComponent.isEnabled() && this.textComponent.isEditable()) {
            if (this.blinkTimer == null) {
                this.initBlinkTimer();
            }
            if (!this.blinkTimer.isRunning()) {
                this.blinkTimer.start();
            }
        } else if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
    }

    protected void moveCaret(MouseEvent event) {
        int newDot = this.getComponent().viewToModel(event.getPoint());
        this.moveDot(newDot);
    }

    protected void positionCaret(MouseEvent event) {
        int newDot = this.getComponent().viewToModel(event.getPoint());
        this.setDot(newDot);
    }

    @Override
    public void deinstall(JTextComponent c) {
        this.textComponent.removeFocusListener(this);
        this.textComponent.removeMouseListener(this);
        this.textComponent.removeMouseMotionListener(this);
        this.textComponent.getDocument().removeDocumentListener(this.documentListener);
        this.documentListener = null;
        this.textComponent.removePropertyChangeListener(this.propertyChangeListener);
        this.propertyChangeListener = null;
        this.textComponent = null;
        if (this.blinkTimer != null) {
            this.blinkTimer.stop();
        }
        this.blinkTimer = null;
    }

    @Override
    public void install(JTextComponent c) {
        this.textComponent = c;
        this.textComponent.addFocusListener(this);
        this.textComponent.addMouseListener(this);
        this.textComponent.addMouseMotionListener(this);
        this.propertyChangeListener = new PropertyChangeHandler();
        this.textComponent.addPropertyChangeListener(this.propertyChangeListener);
        this.documentListener = new DocumentHandler();
        Document doc = this.textComponent.getDocument();
        if (doc != null) {
            doc.addDocumentListener(this.documentListener);
        }
        this.active = this.textComponent.isEditable() && this.textComponent.isEnabled();
        this.repaint();
    }

    @Override
    public void setMagicCaretPosition(Point p) {
        this.magicCaretPosition = p;
    }

    @Override
    public Point getMagicCaretPosition() {
        return this.magicCaretPosition;
    }

    @Override
    public int getMark() {
        return this.mark;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        if (this.selectionVisible) {
            try {
                if (this.highlightEntry != null) {
                    highlighter.changeHighlight(this.highlightEntry, 0, 0);
                }
                if (componentWithSelection != this.textComponent) return;
                componentWithSelection = null;
                return;
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError();
            }
        } else {
            if (this.highlightEntry == null) return;
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    private void handleHighlight() {
        Highlighter highlighter = this.textComponent.getHighlighter();
        if (highlighter == null) {
            return;
        }
        int p0 = Math.min(this.dot, this.mark);
        int p1 = Math.max(this.dot, this.mark);
        if (this.selectionVisible) {
            try {
                if (this.highlightEntry == null) {
                    this.highlightEntry = highlighter.addHighlight(p0, p1, this.getSelectionPainter());
                } else {
                    highlighter.changeHighlight(this.highlightEntry, p0, p1);
                }
                if (componentWithSelection != null && componentWithSelection != this.textComponent) {
                    Caret c = componentWithSelection.getCaret();
                    c.setDot(c.getDot());
                }
                componentWithSelection = this.textComponent;
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError();
            }
        } else if (this.highlightEntry != null) {
            highlighter.removeHighlight(this.highlightEntry);
            this.highlightEntry = null;
        }
    }

    @Override
    public void setSelectionVisible(boolean v) {
        if (this.selectionVisible == v) {
            return;
        }
        this.selectionVisible = v;
        this.handleHighlight();
        this.repaint();
    }

    @Override
    public boolean isSelectionVisible() {
        return this.selectionVisible;
    }

    protected final void repaint() {
        this.getComponent().repaint(this.x, this.y, this.width, this.height);
    }

    @Override
    public void paint(Graphics g) {
        JTextComponent comp = this.getComponent();
        if (comp == null) {
            return;
        }
        this.dot = Math.min(this.dot, this.textComponent.getDocument().getLength());
        this.dot = Math.max(this.dot, 0);
        Rectangle rect = null;
        try {
            rect = this.textComponent.modelToView(this.dot);
        }
        catch (BadLocationException badLocationException) {}
        if (rect == null) {
            return;
        }
        if (this.x != rect.x || this.y != rect.y) {
            this.repaint();
            this.x = rect.x;
            this.y = rect.y;
            this.width = 1;
            this.height = rect.height;
        }
        if (this.visible && this.active) {
            g.setColor(this.textComponent.getCaretColor());
            g.drawLine(rect.x, rect.y, rect.x, rect.y + rect.height - 1);
        }
    }

    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        return this.listenerList.getListeners(listenerType);
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listenerList.add(ChangeListener.class, listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listenerList.remove(ChangeListener.class, listener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        ChangeListener[] listeners = this.getChangeListeners();
        int index = 0;
        while (index < listeners.length) {
            listeners[index].stateChanged(this.changeEvent);
            ++index;
        }
    }

    protected final JTextComponent getComponent() {
        return this.textComponent;
    }

    @Override
    public int getBlinkRate() {
        return this.blinkRate;
    }

    @Override
    public void setBlinkRate(int rate) {
        if (this.blinkTimer != null) {
            this.blinkTimer.setDelay(rate);
        }
        this.blinkRate = rate;
    }

    @Override
    public int getDot() {
        return this.dot;
    }

    @Override
    public void moveDot(int dot) {
        NavigationFilter filter = this.textComponent.getNavigationFilter();
        if (filter != null) {
            filter.moveDot(this.getBypass(), dot, Position.Bias.Forward);
        } else {
            this.moveDotImpl(dot);
        }
    }

    void moveDotImpl(int dot) {
        if (dot >= 0) {
            Document doc = this.textComponent.getDocument();
            if (doc != null) {
                this.dot = Math.min(dot, doc.getLength());
            }
            this.dot = Math.max(this.dot, 0);
            this.handleHighlight();
            this.appear();
        }
    }

    @Override
    public void setDot(int dot) {
        NavigationFilter filter = this.textComponent.getNavigationFilter();
        if (filter != null) {
            filter.setDot(this.getBypass(), dot, Position.Bias.Forward);
        } else {
            this.setDotImpl(dot);
        }
    }

    void setDotImpl(int dot) {
        if (dot >= 0) {
            Document doc = this.textComponent.getDocument();
            if (doc != null) {
                this.dot = Math.min(dot, doc.getLength());
            }
            this.mark = this.dot = Math.max(this.dot, 0);
            this.clearHighlight();
            this.appear();
        }
    }

    void appear() {
        if (this.blinkListener != null) {
            this.blinkListener.ignoreNextEvent = true;
            if (this.visible) {
                this.repaint();
            }
            this.visible = true;
            Rectangle area = null;
            int dot = this.getDot();
            try {
                area = this.getComponent().modelToView(dot);
            }
            catch (BadLocationException badLocationException) {}
            if (area != null) {
                this.adjustVisibility(area);
                if (this.getMagicCaretPosition() == null) {
                    this.setMagicCaretPosition(new Point(area.x, area.y));
                }
                this.damage(area);
            }
        }
        this.repaint();
    }

    public boolean isActive() {
        if (this.blinkTimer != null) {
            return this.blinkTimer.isRunning();
        }
        return false;
    }

    @Override
    public boolean isVisible() {
        return this.visible && this.active;
    }

    @Override
    public void setVisible(boolean v) {
        if (v != this.visible) {
            this.visible = v;
            this.updateTimerStatus();
            Rectangle area = null;
            int dot = this.getDot();
            try {
                area = this.getComponent().modelToView(dot);
            }
            catch (BadLocationException e) {
                AssertionError ae = new AssertionError((Object)("Unexpected bad caret location: " + dot));
                ((Throwable)((Object)ae)).initCause(e);
                throw ae;
            }
            if (area != null) {
                this.damage(area);
            }
        }
    }

    protected Highlighter.HighlightPainter getSelectionPainter() {
        return DefaultHighlighter.DefaultPainter;
    }

    protected void damage(Rectangle r) {
        if (r == null) {
            return;
        }
        this.x = r.x;
        this.y = r.y;
        this.width = 1;
        if (this.height <= 0) {
            try {
                this.height = this.textComponent.modelToView((int)this.dot).height;
            }
            catch (BadLocationException badLocationException) {
                throw new InternalError("Caret location not within document range.");
            }
        }
        this.repaint();
    }

    protected void adjustVisibility(Rectangle rect) {
        this.getComponent().scrollRectToVisible(rect);
    }

    private void initBlinkTimer() {
        this.blinkListener = new BlinkTimerListener();
        this.blinkTimer = new Timer(this.getBlinkRate(), this.blinkListener);
        this.blinkTimer.setRepeats(true);
    }

    private class BlinkTimerListener
    implements ActionListener {
        boolean ignoreNextEvent;

        private BlinkTimerListener() {
        }

        public void actionPerformed(ActionEvent event) {
            if (this.ignoreNextEvent) {
                this.ignoreNextEvent = false;
            } else {
                DefaultCaret.this.visible = !DefaultCaret.this.visible;
                DefaultCaret.this.repaint();
            }
        }
    }

    class Bypass
    extends NavigationFilter.FilterBypass {
        Bypass() {
        }

        public Caret getCaret() {
            return DefaultCaret.this;
        }

        public void moveDot(int dot, Position.Bias bias) {
            DefaultCaret.this.moveDotImpl(dot);
        }

        public void setDot(int dot, Position.Bias bias) {
            DefaultCaret.this.setDotImpl(dot);
        }
    }

    private class DocumentHandler
    implements DocumentListener {
        private DocumentHandler() {
        }

        public void changedUpdate(DocumentEvent event) {
        }

        public void insertUpdate(DocumentEvent event) {
            if (DefaultCaret.this.policy == 2 || SwingUtilities.isEventDispatchThread() && DefaultCaret.this.policy == 0) {
                int dot = DefaultCaret.this.getDot();
                DefaultCaret.this.setDot(dot + event.getLength());
            }
        }

        public void removeUpdate(DocumentEvent event) {
            if (DefaultCaret.this.policy == 2 || SwingUtilities.isEventDispatchThread() && DefaultCaret.this.policy == 0) {
                int dot = DefaultCaret.this.getDot();
                DefaultCaret.this.setDot(dot - event.getLength());
            } else if (DefaultCaret.this.policy == 1 || !SwingUtilities.isEventDispatchThread() && DefaultCaret.this.policy == 0) {
                int docLength = event.getDocument().getLength();
                if (DefaultCaret.this.getDot() > docLength) {
                    DefaultCaret.this.setDot(docLength);
                }
            }
        }
    }

    private class PropertyChangeHandler
    implements PropertyChangeListener {
        private PropertyChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (name.equals("document")) {
                Document newDoc;
                Document oldDoc = (Document)e.getOldValue();
                if (oldDoc != null) {
                    oldDoc.removeDocumentListener(DefaultCaret.this.documentListener);
                }
                if ((newDoc = (Document)e.getNewValue()) != null) {
                    newDoc.addDocumentListener(DefaultCaret.this.documentListener);
                }
            } else if (name.equals("editable")) {
                DefaultCaret.this.active = (Boolean)e.getNewValue() != false && DefaultCaret.this.textComponent.isEnabled();
            } else if (name.equals("enabled")) {
                DefaultCaret.this.active = (Boolean)e.getNewValue() != false && DefaultCaret.this.textComponent.isEditable();
            }
        }
    }
}

