/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.validation.datatype;

import gnu.xml.validation.datatype.AtomicSimpleType;
import gnu.xml.validation.datatype.TypeLibrary;
import javax.xml.namespace.QName;
import org.relaxng.datatype.DatatypeException;
import org.relaxng.datatype.ValidationContext;

final class GDayType
extends AtomicSimpleType {
    static final int[] CONSTRAINING_FACETS = new int[]{4, 5, 6, 7, 8, 10, 9};

    GDayType() {
        super(new QName("http://www.w3.org/2001/XMLSchema", "gDay"), TypeLibrary.ANY_SIMPLE_TYPE);
    }

    public int[] getConstrainingFacets() {
        return CONSTRAINING_FACETS;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void checkValid(String value, ValidationContext context) throws DatatypeException {
        super.checkValid(value, context);
        int len = value.length();
        int state = 0;
        int start = 0;
        int i = 0;
        while (i < len) {
            block14: {
                char c = value.charAt(i);
                if (c < '0' || c > '9') {
                    switch (state) {
                        case 0: {
                            if (c != '-') break;
                            switch (i) {
                                case 0: {
                                    break block14;
                                }
                                case 1: {
                                    state = 1;
                                    start = i + 1;
                                    break block14;
                                }
                                default: {
                                    throw new DatatypeException(i, "invalid GDay value");
                                }
                            }
                        }
                        case 1: {
                            if (c != '-') break;
                            if (i - start != 0) {
                                throw new DatatypeException(i, "invalid GDay value");
                            }
                            state = 2;
                            start = i + 1;
                            break block14;
                        }
                    }
                    throw new DatatypeException(i, "invalid GDay value");
                }
            }
            ++i;
        }
        switch (state) {
            case 2: {
                if (len - start == 2) break;
                throw new DatatypeException("invalid GDay value");
            }
            default: {
                throw new DatatypeException("invalid GDay value");
            }
        }
    }

    public Object createValue(String literal, ValidationContext context) {
        try {
            GDay ret = new GDay();
            ret.day = Integer.parseInt(literal.substring(3));
            return ret;
        }
        catch (Exception exception) {
            return null;
        }
    }

    static class GDay
    implements Comparable {
        int day;

        GDay() {
        }

        public int hashCode() {
            return this.day;
        }

        public boolean equals(Object other) {
            if (other instanceof GDay) {
                return ((GDay)other).day == this.day;
            }
            return false;
        }

        public int compareTo(Object other) {
            if (other instanceof GDay) {
                GDay gd = (GDay)other;
                if (gd.day == this.day) {
                    return 0;
                }
                return this.day < gd.day ? -1 : 1;
            }
            return 0;
        }
    }
}

