/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.nio.charset;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;

final class UTF_16Decoder
extends CharsetDecoder {
    static final int BIG_ENDIAN = 0;
    static final int LITTLE_ENDIAN = 1;
    static final int UNKNOWN_ENDIAN = 2;
    static final int MAYBE_BIG_ENDIAN = 3;
    static final int MAYBE_LITTLE_ENDIAN = 4;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final char REVERSED_BYTE_ORDER_MARK = '\ufffe';
    private final int originalByteOrder;
    private int byteOrder;

    UTF_16Decoder(Charset cs, int byteOrder) {
        super(cs, 0.5f, 1.0f);
        this.originalByteOrder = byteOrder;
        this.byteOrder = byteOrder;
    }

    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        int inPos = in.position();
        try {
            while (in.remaining() >= 2) {
                char c;
                byte b1 = in.get();
                byte b2 = in.get();
                if (this.byteOrder == 2 || this.byteOrder == 3 || this.byteOrder == 4) {
                    c = (char)((b1 & 0xFF) << 8 | b2 & 0xFF);
                    if (c == '\ufeff') {
                        if (this.byteOrder == 4) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        this.byteOrder = 0;
                        inPos += 2;
                        continue;
                    }
                    if (c == '\ufffe') {
                        if (this.byteOrder == 3) {
                            CoderResult coderResult = CoderResult.malformedForLength(2);
                            return coderResult;
                        }
                        this.byteOrder = 1;
                        inPos += 2;
                        continue;
                    }
                    this.byteOrder = this.byteOrder == 4 ? 1 : 0;
                }
                char c2 = c = this.byteOrder == 0 ? (char)((b1 & 0xFF) << 8 | b2 & 0xFF) : (char)((b2 & 0xFF) << 8 | b1 & 0xFF);
                if ('\ud800' <= c && c <= '\udfff') {
                    char d;
                    if (c > '\udbff') {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    if (in.remaining() < 2) {
                        CoderResult coderResult = CoderResult.UNDERFLOW;
                        return coderResult;
                    }
                    byte b3 = in.get();
                    byte b4 = in.get();
                    char c3 = d = this.byteOrder == 0 ? (char)((b3 & 0xFF) << 8 | b4 & 0xFF) : (char)((b4 & 0xFF) << 8 | b3 & 0xFF);
                    if (d < '\udc00' || d > '\udfff') {
                        CoderResult coderResult = CoderResult.malformedForLength(2);
                        return coderResult;
                    }
                    out.put(c);
                    out.put(d);
                    inPos += 4;
                    continue;
                }
                if (!out.hasRemaining()) {
                    CoderResult coderResult = CoderResult.UNDERFLOW;
                    return coderResult;
                }
                out.put(c);
                inPos += 2;
            }
            CoderResult coderResult = CoderResult.UNDERFLOW;
            return coderResult;
        }
        finally {
            in.position(inPos);
        }
    }

    protected void implReset() {
        this.byteOrder = this.originalByteOrder;
    }
}

