/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.debug;

import gnu.java.security.action.GetPropertyAction;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.AccessController;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class Simple1LineFormatter
extends Formatter {
    private static final String DAT_PATTERN = "yyyy-MM-dd HH:mm:ss.SSSS Z ";
    private static final String THREAD_PATTERN = " #########0;-#########0";
    private static final String SPACES_32 = "                                ";
    private static final String SPACES_6 = "      ";
    private static final String LS = AccessController.doPrivileged(new GetPropertyAction("line.separator"));
    private DateFormat dateFormat;
    private NumberFormat threadFormat;

    public String format(LogRecord record) {
        if (this.dateFormat == null) {
            this.dateFormat = new SimpleDateFormat(DAT_PATTERN);
        }
        if (this.threadFormat == null) {
            this.threadFormat = new DecimalFormat(THREAD_PATTERN);
        }
        StringBuilder sb = new StringBuilder(180).append(this.dateFormat.format(new Date(record.getMillis()))).append(this.threadFormat.format(record.getThreadID())).append(" ");
        String s = record.getSourceClassName();
        if (s == null) {
            sb.append(SPACES_32);
        } else {
            int i = (s = s.trim()).lastIndexOf(".");
            if (i != -1) {
                s = s.substring(i + 1);
            }
            s = (String.valueOf(s) + SPACES_32).substring(0, 32);
        }
        sb.append(s).append(" ");
        s = record.getSourceMethodName();
        if (s == null) {
            sb.append(SPACES_32);
        } else {
            s = (s = s.trim()).endsWith("()") ? (String.valueOf(s.trim()) + SPACES_32).substring(0, 32) : (String.valueOf(s.trim()) + "()" + SPACES_32).substring(0, 32);
        }
        sb.append(s).append(" ");
        s = String.valueOf(record.getLevel());
        if (s == null) {
            sb.append(SPACES_6);
        } else {
            s = (String.valueOf(s.trim()) + SPACES_6).substring(0, 6);
        }
        sb.append(s).append(" - ").append(this.formatMessage(record)).append(LS);
        Throwable cause = record.getThrown();
        if (cause != null) {
            StringWriter sw = new StringWriter();
            cause.printStackTrace(new PrintWriter(sw, true));
            sb.append(sw.toString());
        }
        return sb.toString();
    }
}

