/*
 * Decompiled with CFR 0.152.
 */
package gnu.awt.xlib;

import gnu.awt.LightweightRedirector;
import gnu.awt.xlib.XCanvasPeer;
import gnu.awt.xlib.XFramePeer;
import gnu.gcj.xlib.Display;
import gnu.gcj.xlib.XAnyEvent;
import gnu.gcj.xlib.XButtonEvent;
import gnu.gcj.xlib.XConfigureEvent;
import gnu.gcj.xlib.XExposeEvent;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.awt.event.PaintEvent;

public class XEventLoop
implements Runnable {
    Display display;
    EventQueue queue;
    XAnyEvent anyEvent;
    private Thread eventLoopThread;
    LightweightRedirector lightweightRedirector = new LightweightRedirector();
    volatile boolean idle = false;

    public XEventLoop(Display display, EventQueue queue) {
        this.display = display;
        this.queue = queue;
        this.anyEvent = new XAnyEvent(display);
        this.eventLoopThread = new Thread(this, "AWT thread for XEventLoop");
        this.eventLoopThread.start();
    }

    public void run() {
        while (true) {
            this.postNextEvent(true);
        }
    }

    boolean postNextEvent(boolean block) {
        AWTEvent evt = this.getNextEvent(block);
        if (evt != null) {
            this.queue.postEvent(evt);
        }
        return evt != null;
    }

    public AWTEvent getNextEvent(boolean block) {
        if (this.isIdle()) {
            throw new Error("should not be idle");
        }
        AWTEvent event = null;
        if (this.loadNextEvent(block)) {
            event = this.createEvent();
            event = this.lightweightRedirector.redirect(event);
        }
        return event;
    }

    boolean loadNextEvent(boolean block) {
        boolean gotEvent = false;
        try {
            try {
                this.setIdle(true);
                gotEvent = this.anyEvent.loadNext(block);
            }
            catch (RuntimeException re) {
                System.err.println("Exception thrown on event thread:" + re);
                this.setIdle(false);
            }
        }
        finally {
            this.setIdle(false);
        }
        return gotEvent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    AWTEvent createEvent() {
        Object peer;
        int type = this.anyEvent.getType();
        switch (type) {
            case 14: 
            case 18: 
            case 19: 
            case 21: {
                return null;
            }
        }
        XEventLoop xEventLoop = this;
        synchronized (xEventLoop) {
            peer = this.anyEvent.getWindow().getClientData();
        }
        Component source = null;
        if (peer instanceof XCanvasPeer) {
            source = ((XCanvasPeer)peer).getComponent();
        }
        if (source == null) {
            String msg = "unable to locate source for event (" + this.anyEvent + "): peer=" + peer;
            throw new RuntimeException(msg);
        }
        switch (type) {
            case 12: {
                return this.createPaintEvent(source);
            }
            case 4: 
            case 5: {
                return this.createMouseEvent(type, source);
            }
            case 22: {
                this.configureNotify(peer);
                return null;
            }
        }
        String msg = "Do not know how to handle event (" + this.anyEvent + ")";
        throw new RuntimeException(msg);
    }

    AWTEvent createPaintEvent(Component src) {
        XExposeEvent expose = new XExposeEvent(this.anyEvent);
        PaintEvent pe = new PaintEvent(src, 800, expose.getBounds());
        return pe;
    }

    AWTEvent createMouseEvent(int type, Component src) {
        XButtonEvent buttonEvt = new XButtonEvent(this.anyEvent);
        int modifiers = 0;
        switch (buttonEvt.button) {
            case 1: {
                modifiers = 1024;
                break;
            }
            case 2: {
                modifiers = 2048;
                break;
            }
            case 3: {
                modifiers = 2048;
            }
        }
        int state = buttonEvt.state;
        if ((state & 1) != 0) {
            modifiers |= 1;
        }
        if ((state & 4) != 0) {
            modifiers |= 2;
        }
        int clickCount = 1;
        boolean popupTrigger = false;
        int cfr_ignored_0 = buttonEvt.x;
        int cfr_ignored_1 = buttonEvt.y;
        int id = type == 4 ? 501 : 502;
        MouseEvent me = new MouseEvent(src, id, buttonEvt.time, modifiers, buttonEvt.x, buttonEvt.y, clickCount, popupTrigger);
        return me;
    }

    void configureNotify(Object peerObj) {
        XConfigureEvent configEvent = new XConfigureEvent(this.anyEvent);
        XFramePeer peer = (XFramePeer)peerObj;
        peer.configureNotify(configEvent);
    }

    public void flushIfIdle() {
        if (this.isIdle()) {
            this.display.flush();
        }
    }

    final synchronized void setIdle(boolean idle) {
        this.idle = idle;
    }

    final synchronized boolean isIdle() {
        return this.idle;
    }
}

