/*
 * Decompiled with CFR 0.152.
 */
package org.armedbear.lisp;

import java.util.concurrent.locks.ReentrantLock;
import org.armedbear.lisp.BuiltInClass;
import org.armedbear.lisp.Cons;
import org.armedbear.lisp.Keyword;
import org.armedbear.lisp.Lisp;
import org.armedbear.lisp.LispObject;
import org.armedbear.lisp.LispThread;
import org.armedbear.lisp.PrintNotReadable;
import org.armedbear.lisp.Symbol;
import org.armedbear.lisp.protocol.Hashtable;

public class HashTable
extends LispObject
implements Hashtable {
    protected static final float loadFactor = 0.75f;
    protected final LispObject rehashSize;
    protected final LispObject rehashThreshold;
    protected int threshold;
    protected volatile HashEntry[] buckets;
    protected volatile int count;
    final Comparator comparator;
    private final ReentrantLock lock = new ReentrantLock();

    protected HashTable(Comparator c, int size, LispObject rehashSize, LispObject rehashThreshold) {
        this.rehashSize = rehashSize;
        this.rehashThreshold = rehashThreshold;
        this.buckets = new HashEntry[size];
        this.threshold = (int)((float)size * 0.75f);
        this.comparator = c;
    }

    protected static int calculateInitialCapacity(int size) {
        int capacity;
        for (capacity = 1; capacity < size; capacity <<= 1) {
        }
        return capacity;
    }

    public static HashTable newEqHashTable(int size, LispObject rehashSize, LispObject rehashThreshold) {
        return new HashTable(new Comparator(), size, rehashSize, rehashThreshold);
    }

    public static HashTable newEqlHashTable(int size, LispObject rehashSize, LispObject rehashThreshold) {
        return new HashTable(new EqlComparator(), size, rehashSize, rehashThreshold);
    }

    public static HashTable newEqualHashTable(int size, LispObject rehashSize, LispObject rehashThreshold) {
        return new HashTable(new EqualComparator(), size, rehashSize, rehashThreshold);
    }

    public static LispObject newEqualpHashTable(int size, LispObject rehashSize, LispObject rehashThreshold) {
        return new HashTable(new EqualpComparator(), size, rehashSize, rehashThreshold);
    }

    public final LispObject getRehashSize() {
        return this.rehashSize;
    }

    public final LispObject getRehashThreshold() {
        return this.rehashThreshold;
    }

    public int getSize() {
        return this.buckets.length;
    }

    public int getCount() {
        return this.count;
    }

    public LispObject typeOf() {
        return Symbol.HASH_TABLE;
    }

    public LispObject classOf() {
        return BuiltInClass.HASH_TABLE;
    }

    public LispObject typep(LispObject type) {
        if (type == Symbol.HASH_TABLE) {
            return Lisp.T;
        }
        if (type == BuiltInClass.HASH_TABLE) {
            return Lisp.T;
        }
        return super.typep(type);
    }

    public boolean equalp(LispObject obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof HashTable) {
            HashTable ht = (HashTable)obj;
            if (this.count != ht.count) {
                return false;
            }
            if (this.getTest() != ht.getTest()) {
                return false;
            }
            for (LispObject entries = this.ENTRIES(); entries != Lisp.NIL; entries = entries.cdr()) {
                LispObject entry = entries.car();
                LispObject key = entry.car();
                LispObject value = entry.cdr();
                if (value.equalp(ht.get(key))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public LispObject getParts() {
        HashEntry[] b = this.buckets;
        LispObject parts = Lisp.NIL;
        for (int i = 0; i < b.length; ++i) {
            HashEntry e = b[i];
            while (e != null) {
                parts = parts.push(new Cons("KEY [bucket " + i + "]", e.key));
                parts = parts.push(new Cons("VALUE", e.value));
                e = e.next;
            }
        }
        return parts.nreverse();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        this.lock.lock();
        try {
            this.buckets = new HashEntry[this.buckets.length];
            this.count = 0;
        }
        finally {
            this.lock.unlock();
        }
    }

    public LispObject gethash(LispObject key) {
        Symbol presentp;
        LispObject value = this.get(key);
        if (value == null) {
            presentp = Lisp.NIL;
            value = presentp;
        } else {
            presentp = Lisp.T;
        }
        return LispThread.currentThread().setValues(value, presentp);
    }

    public LispObject gethash(LispObject key, LispObject defaultValue) {
        Symbol presentp;
        LispObject value = this.get(key);
        if (value == null) {
            value = defaultValue;
            presentp = Lisp.NIL;
        } else {
            presentp = Lisp.T;
        }
        return LispThread.currentThread().setValues(value, presentp);
    }

    public LispObject gethash1(LispObject key) {
        LispObject value = this.get(key);
        return value != null ? value : Lisp.NIL;
    }

    public LispObject puthash(LispObject key, LispObject newValue) {
        this.put(key, newValue);
        return newValue;
    }

    public LispObject remhash(LispObject key) {
        return this.remove(key) != null ? Lisp.T : Lisp.NIL;
    }

    public String printObject() {
        if (Symbol.PRINT_READABLY.symbolValue(LispThread.currentThread()) != Lisp.NIL) {
            Lisp.error(new PrintNotReadable(Lisp.list(Keyword.OBJECT, this)));
            return null;
        }
        StringBuilder sb = new StringBuilder(this.getTest().princToString());
        sb.append(' ');
        sb.append(Symbol.HASH_TABLE.princToString());
        sb.append(' ');
        sb.append(this.count);
        if (this.count == 1) {
            sb.append(" entry");
        } else {
            sb.append(" entries");
        }
        sb.append(", ");
        sb.append(this.buckets.length);
        sb.append(" buckets");
        return this.unreadableString(sb.toString());
    }

    public Symbol getTest() {
        return this.comparator.getTest();
    }

    protected HashEntry getEntry(LispObject key) {
        HashEntry[] b = this.buckets;
        int hash = this.comparator.hash(key);
        HashEntry e = b[hash & b.length - 1];
        while (e != null) {
            if (hash == e.hash && (key == e.key || this.comparator.keysEqual(key, e.key))) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject get(LispObject key) {
        LispObject v;
        HashEntry e = this.getEntry(key);
        LispObject lispObject = v = e == null ? null : e.value;
        if (e == null || v != null) {
            return v;
        }
        this.lock.lock();
        try {
            LispObject lispObject2 = e.value;
            return lispObject2;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(LispObject key, LispObject value) {
        this.lock.lock();
        try {
            HashEntry e = this.getEntry(key);
            if (e != null) {
                e.value = value;
            } else {
                if (++this.count > this.threshold) {
                    this.rehash();
                }
                int hash = this.comparator.hash(key);
                int index = hash & this.buckets.length - 1;
                this.buckets[index] = new HashEntry(key, hash, value, this.buckets[index]);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LispObject remove(LispObject key) {
        this.lock.lock();
        try {
            int index = this.comparator.hash(key) & this.buckets.length - 1;
            HashEntry e = this.buckets[index];
            HashEntry last2 = null;
            while (e != null) {
                if (this.comparator.keysEqual(key, e.key)) {
                    if (last2 == null) {
                        this.buckets[index] = e.next;
                    } else {
                        last2.next = e.next;
                    }
                    --this.count;
                    LispObject lispObject = e.value;
                    return lispObject;
                }
                last2 = e;
                e = e.next;
            }
            LispObject lispObject = null;
            return lispObject;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void rehash() {
        this.lock.lock();
        try {
            int newCapacity = this.buckets.length * 2;
            this.threshold = (int)((float)newCapacity * 0.75f);
            int mask = newCapacity - 1;
            HashEntry[] newBuckets = new HashEntry[newCapacity];
            int i = this.buckets.length;
            while (i-- > 0) {
                HashEntry e = this.buckets[i];
                while (e != null) {
                    int index = this.comparator.hash(e.key) & mask;
                    newBuckets[index] = new HashEntry(e.key, e.hash, e.value, newBuckets[index]);
                    e = e.next;
                }
            }
            this.buckets = newBuckets;
        }
        finally {
            this.lock.unlock();
        }
    }

    public LispObject ENTRIES() {
        return this.getEntries();
    }

    public LispObject getEntries() {
        HashEntry[] b = this.buckets;
        LispObject list = Lisp.NIL;
        int i = b.length;
        while (i-- > 0) {
            HashEntry e = b[i];
            while (e != null) {
                list = new Cons(new Cons(e.key, e.value), list);
                e = e.next;
            }
        }
        return list;
    }

    public LispObject MAPHASH(LispObject function) {
        HashEntry[] b = this.buckets;
        int i = b.length;
        while (i-- > 0) {
            HashEntry e = b[i];
            while (e != null) {
                function.execute(e.key, e.value);
                e = e.next;
            }
        }
        return Lisp.NIL;
    }

    public int psxhash() {
        long result = 2062775257L;
        result = Lisp.mix(result, this.count);
        result = Lisp.mix(result, this.getTest().sxhash());
        return (int)(result & Integer.MAX_VALUE);
    }

    protected static class HashEntry {
        LispObject key;
        int hash;
        volatile LispObject value;
        HashEntry next;

        HashEntry(LispObject key, int hash, LispObject value, HashEntry next) {
            this.key = key;
            this.hash = hash;
            this.value = value;
            this.next = next;
        }
    }

    protected static class EqualpComparator
    extends Comparator {
        protected EqualpComparator() {
        }

        Symbol getTest() {
            return Symbol.EQUALP;
        }

        boolean keysEqual(LispObject key1, LispObject key2) {
            return key1.equalp(key2);
        }

        int hash(LispObject key) {
            return key.psxhash();
        }
    }

    protected static class EqualComparator
    extends Comparator {
        protected EqualComparator() {
        }

        Symbol getTest() {
            return Symbol.EQUAL;
        }

        boolean keysEqual(LispObject key1, LispObject key2) {
            return key1.equal(key2);
        }
    }

    protected static class EqlComparator
    extends Comparator {
        protected EqlComparator() {
        }

        Symbol getTest() {
            return Symbol.EQL;
        }

        boolean keysEqual(LispObject key1, LispObject key2) {
            return key1.eql(key2);
        }
    }

    protected static class Comparator {
        protected Comparator() {
        }

        Symbol getTest() {
            return Symbol.EQ;
        }

        boolean keysEqual(LispObject key1, LispObject key2) {
            return key1 == key2;
        }

        int hash(LispObject key) {
            return key.sxhash();
        }
    }
}

