package exos;
##
## $Id: exos.pm.in 3399 2016-05-24 11:36:20Z heas $
##
## rancid 3.6.1
## Copyright (c) 1997-2016 by Henry Kilmer and John Heasley
## All rights reserved.
##
## This code is derived from software contributed to and maintained by
## Henry Kilmer, John Heasley, Andrew Partan,
## Pete Whiting, Austin Schutz, and Andrew Fort.
##
## Redistribution and use in source and binary forms, with or without
## modification, are permitted provided that the following conditions
## are met:
## 1. Redistributions of source code must retain the above copyright
##    notice, this list of conditions and the following disclaimer.
## 2. Redistributions in binary form must reproduce the above copyright
##    notice, this list of conditions and the following disclaimer in the
##    documentation and/or other materials provided with the distribution.
## 3. All advertising materials mentioning features or use of this software
##    must display the following acknowledgement:
##        This product includes software developed by Henry Kilmer and John
##        Heasley and its contributors for RANCID.
## 4. Neither the name of RANCID nor the names of its
##    contributors may be used to endorse or promote products derived from
##    this software without specific prior written permission.
## 5. It is requested that non-binding fixes and modifications be contributed
##    back to RANCID.
##
## THIS SOFTWARE IS PROVIDED BY Henry Kilmer, John Heasley AND CONTRIBUTORS
## ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED
## TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
## PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COMPANY OR CONTRIBUTORS
## BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
## CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
## SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
## INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
## CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
## POSSIBILITY OF SUCH DAMAGE.
##
## It is the request of the authors, but not a condition of license, that
## parties packaging or redistributing RANCID NOT distribute altered versions
## of the etc/rancid.types.base file nor alter how this file is processed nor
## when in relation to etc/rancid.types.conf.  The goal of this is to help
## suppress our support costs.  If it becomes a problem, this could become a
## condition of license.
# 
#  The expect login scripts were based on Erik Sherk's gwtn, by permission.
# 
#  The original looking glass software was written by Ed Kern, provided by
#  permission and modified beyond recognition.
#
#  RANCID - Really Awesome New Cisco confIg Differ
#
#  exos.pm - Extreme ExtremeXOS rancid procedures

use 5.010;
use strict 'vars';
use warnings;
no warnings 'uninitialized';
require(Exporter);
our @ISA = qw(Exporter);

use rancid 3.6.1;

@ISA = qw(Exporter rancid main);
#XXX @Exporter::EXPORT = qw($VERSION @commandtable %commands @commands);

# load-time initialization
sub import {
    0;
}

# post-open(collection file) initialization
sub init {
    # add content lines and separators
    ProcessHistory("","","","#RANCID-CONTENT-TYPE: $devtype\n#\n");
    ProcessHistory("COMMENTS","keysort","B0","#\n");	# chassis info
    ProcessHistory("COMMENTS","keysort","C0","#\n");	# power supply info
    ProcessHistory("COMMENTS","keysort","D0","#\n");	# image name
    ProcessHistory("COMMENTS","keysort","E0","#\n");	# h/w info
    ProcessHistory("COMMENTS","keysort","F0","#\n");	# slot info
    ProcessHistory("COMMENTS","keysort","H0","#\n");	# config
    ProcessHistory("COMMENTS","keysort","X0","#\n");

    0;
}

# main loop of input of device output
sub inloop {
    my($INPUT, $OUTPUT) = @_;
    my($cmd, $rval);

TOP: while(<$INPUT>) {
	tr/\015//d;
	# note: this match sucks rocks, but currently the extreme bits are
	# unreliable about echoing the 'exit\n' command.  this match might
	# really be a bad idea, but instead rely upon WriteTerm's found_end?
	if (/($prompt\s?(quit|exit)|Connection( to \S+)? closed)/ && $found_end) {
	    $clean_run = 1;
	    last;
	}
	if (/^Error:/) {
	    print STDOUT ("$host clogin error: $_");
	    print STDERR ("$host clogin error: $_") if ($debug);
	    $clean_run = 0;
	    last;
	}
	while (/$prompt\s*($cmds_regexp)\s*$/) {
	    $cmd = $1;
	    if (!defined($prompt)) {
		$prompt = ($_ =~ /^([^#]+#)/)[0];
		$prompt =~ s/([][}{)(\\])/\\$1/g;
		$prompt =~ s/[:.](\d+ ?)#/[:.]\\d+ ?#/;
		$prompt =~ s/\*/\\\*/;
		print STDERR ("PROMPT MATCH: $prompt\n") if ($debug);
	    }
	    print STDERR ("HIT COMMAND:$_") if ($debug);
	    if (! defined($commands{$cmd})) {
		print STDERR "$host: found unexpected command - \"$cmd\"\n";
		$clean_run = 0;
		last TOP;
	    }
	    $rval = &{$commands{$cmd}}($INPUT, $OUTPUT, $cmd);
	    delete($commands{$cmd});
	    if ($rval == -1) {
		printf STDERR "rval = -1\n" if ($debug);
		$clean_run = 0;
		last TOP;
	    }
	}
    }
}

# This routine parses "show version"
sub ShowVersion {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowVersion: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if(/^$prompt/);
	next if(/^(\s*|\s*$cmd\s*)$/);

	/^\S+ Serial Number:/i &&
	    ProcessHistory("COMMENTS","keysort","B0","#$_") && next;
	/^(\S+) Power Supply ([^:]+):\s+(.*)/i &&
	    ProcessHistory("COMMENTS","keysort","C0","#Power: $1 $2 $3\n")
	    && next;
	/^image\s*:\s*(.*)\s+by\s+/i &&
	    ProcessHistory("COMMENTS","keysort","D0","#Image: $1\n")
	    && next;
	/^bootrom\s+:\s+(.*)/i &&
	    ProcessHistory("COMMENTS","keysort","D1","#\n#Bootrom: $1\n")
	    && next;

#XXX: need to collect this from show vers for ShowSlot where rev #s are excluded
#SLOT 1 :  702005-06  0025S-00877 CPLD Rev <FF>
#SLOT 2 :  702005-06  0021S-00131 CPLD Rev 02
#SLOT 3 :  702009-06  0024S-00170 CPLD Rev <FF>
#SLOT 4 :  702009-06  0024S-00319 CPLD Rev <FF>
    }
    return(0);
}

# This routine parses "show memory"
sub ShowMemory {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowMemory: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if(/^$prompt/);
	next if(/^(\s*|\s*$cmd\s*)$/);

	/^Total DRAM (Size|\(KB\)): (.*)/ &&
	    ProcessHistory("COMMENTS","keysort","B1","#\n#Memory: $2\n")
    }
    return(0);
}

# This routine parses "show diag"
sub ShowDiag {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowDiag: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if (/^$prompt/);
	last if (/^Syntax error at token/);
	next if (/^(\s*|\s*$cmd\s*)$/);

	/platform\s+:\s+(.*)$/i &&
	    ProcessHistory("COMMENTS","keysort","A0","#Chassis type: $1\n") &&
	    next;
	/(\S+) part no\s+:\s+(.*)$/i &&
	    ProcessHistory("COMMENTS","keysort","E0","#$1 PN: $2\n") &&
	    next;
	/(\S+ \S+) no\s+:\s+(.*)$/i &&
	    ProcessHistory("COMMENTS","keysort","E0","#$1 PN: $2\n") &&
	    next;
	/(mac address)\s+:\s+(.*)$/i &&
	    ProcessHistory("COMMENTS","keysort","B0","#$1: $2\n") &&
	    next;
    }
    return(0);
}

# This routine parses "show slot"
sub ShowSlot {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowSlot: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if (/^$prompt/);
	next if (/^(\s*|\s*$cmd\s*)$/);

	if (/^Slot\s+(\d+)\s+/i) {
	    my($slot) = $1;
	    my($hwtype, $conftype, $sn, $state);
	    ProcessHistory("COMMENTS","keysort","F$slot","#\n");
	    while (<$INPUT>) {
		tr/\015//d;
		last if (/^$prompt/ || /^\s*$/);
		if (/State:\s+(.*)$/i) { $state = $1; }
		if (/serial number:\s+(.*)$/i) { $sn = $1; }
		if (/hw module type:\s+(.*)$/i) { $hwtype = $1; }
		if (/configured type:\s+(.*)$/i) { $conftype = $1; }
	    }
	    ProcessHistory("COMMENTS","keysort","F$slot","#Slot $slot: type "
		. "$hwtype,"
		. " $conftype\n#Slot $slot: serial $sn\n#Slot $slot: state "
		. " $state\n");
	    return if (/^$prompt/);
	    next;
	}
    }
    return(0);
}

# This routine parses "show switch"
sub ShowSwitch {
    my($INPUT, $OUTPUT, $cmd) = @_;
    print STDERR "    In ShowSwitch: $_" if ($debug);

    while (<$INPUT>) {
	tr/\015//d;
	last if(/^$prompt/);
	next if(/^(\s*|\s*$cmd\s*)$/);

	/^\s*$/i && next;
	/^(primary|secondary) configuration:/i && next;
	/^(boot |next reboot)/i && next;
	/^(auto |qos mode|sys\S*:|temperature|time)/i && next;

	/^power supply: (.*)/i &&
		ProcessHistory("COMMENTS","keysort","C0","#$1") && next;
	/^license/i && ProcessHistory("COMMENTS","keysort","D0","#Image: $_")
		&& next;
	s/^software image (\S+):/Image: $1:/i &&
		ProcessHistory("COMMENTS","keysort","D0","#$_") && next;
	/^\S+ software version:/i &&
		ProcessHistory("COMMENTS","keysort","D0","#Image: $_") && next;
	/^(\S+ )?software/i &&
		ProcessHistory("COMMENTS","keysort","D0","# $_") && next;
	/System MAC:\s+(.*)$/ &&
		ProcessHistory("COMMENTS","keysort","B0","#MAC: $1\n") &&
		next;
	/System Type:\s+(.*)$/ &&
		ProcessHistory("COMMENTS","keysort","A0","#Chassis type: $1\n")
		&& next;
	/^(Image Selected):\s+(\S+)/ &&
		ProcessHistory("COMMENTS","keysort","A0","#$1: $2\n") && next;
	/^(Image Booted):\s+(\S+)/ &&
		ProcessHistory("COMMENTS","keysort","A0","#$1: $2\n") && next;
	/^(Primary (\S+ )?ver):\s+(\S+)/i &&
		ProcessHistory("COMMENTS","keysort","A0","#$1: $3\n") && next;
	/^(Secondary (\S+ )?ver):\s+(\S+)/i &&
		ProcessHistory("COMMENTS","keysort","A0","#$1: $3\n") && next;
	/^(Config Selected):\s+(\S+)/ &&
		ProcessHistory("COMMENTS","keysort","A0","#$1: $2\n") && next;
	/^(Config Booted):\s+(\S+)/ &&
		ProcessHistory("COMMENTS","keysort","A0","#$1: $2\n") && next;
    }
    return(0);
}

# This routine processes a "show configuration {detail}"
sub WriteTerm {
    my($INPUT, $OUTPUT, $cmd) = @_;
    my($lines) = 0;
    print STDERR "    In WriteTerm: $_" if ($debug);
    my($comment) = 1;	# strip extra comments, esp to preserve chassis type

    while (<$INPUT>) {
	tr/\015//d;
	last if(/^$prompt/);
	next if(/^\s*$/);
	return(0) if (/^syntax error at token /i);
	return(0) if (/^%% Invalid input detected at /i);
	return(0) if (/^%% Ambiguous command:/i);
	# the pager can not be disabled per-session on the PIX
	s/^<-+ More -+>\s*//;
	return(0) if ($found_end);

	s/^\s*$/#/;
	next if (/full detail configuration/i);

	# filter extra comments and lead comments in config so we can preserve
	# the chassis type at the top of muched o/p before the process history
	# key changes.
	if (/^#\s*$/) {
	   if ($comment) {
		next;
	   } else {
		$comment++;
	   }
	} else {
	   $comment = 0;
	}
	$lines++;

	# Dog gone Cool matches to process the rest of the config
	# some chassis report their chassis type in show diag...oh, but
	# others do not.  grab it here, if available.  so, nothing else
	# can change the keysort key until this is grabbed.  sigh.
	/# (\S+) configuration generated/i &&
	    ProcessHistory("COMMENTS","keysort","A0","#Chassis type: $1\n") &&
	    ($comment = 0) && next;
	/configuration generated/i && next;
	/# system name/i && next;
	/# software version/i && next;

	if (/((create|configure) account \S+ \S+) / && $filter_pwds >= 2) {
	    ProcessHistory("COMMENTS","keysort","H0","# $1 <key removed>\n");
	    next;
	}
	if (/configure ssh2 key/ && $filter_pwds >= 1) {
	    ProcessHistory("COMMENTS","keysort","H0","# $_# <key removed>\n");
	    while (<$INPUT>) {
		if (/^(#|enable|conf|disable|unconf)/) {
		    tr/\015//d;
		    last;
		}
	    }
	}

	# filter out any RCS/CVS tags to avoid confusing local CVS storage
	s/\$(Revision|Id):/ $1:/;
	if (/^((config|configure) bgp (neighbor|peer-group) \S+ password encrypted)/i && $filter_pwds >= 1) {
	    ProcessHistory("COMMENTS","keysort","H0","# $1 <removed>\n");
	    next;
	}

	# order logging statements
	/^configure syslog add logging (\d+\.\d+\.\d+\.\d+)/ &&
	    ProcessHistory("LOGGING","ipsort","$1","$_") && next;
	# order/prune snmp-server host statements
	# we only prune lines of the form

	# configure snmp add trapreceiver a.b.c.d <community>
	if (/^(configure snmp add trapreceiver )(\d+\.\d+\.\d+\.\d+) (community) \S+/) {
	    if ($filter_commstr) {
		ProcessHistory("SNMPSVRHOST","ipsort","$2","# $1$2 $3 <removed> $'\n");
	    } else {
		ProcessHistory("SNMPSVRHOST","ipsort","$2","$_\n");
	    }
	    next;
	}
	if (/^(configure snmp community (readonly|readwrite)( encrypted)?) (\S+)/) {
	    if ($filter_commstr) {
		ProcessHistory("SNMPSVRCOMM","keysort","$_","#$1 <removed>$'");
		next;
	    } else {
		ProcessHistory("SNMPSVRCOMM","keysort","$_","$_") && next;
	    }
	}
	# order/prune tacacs/radius server statements
	if (/^(configure radius (primary|secondary) (tacacs-server|radius-server) shared-secret encrypted)/ && $filter_pwds >= 1) {
	    ProcessHistory("COMMENTS","keysort","H0","# $1 <removed>\n");
	    next;
	}

	# catch anything that wasnt match above.
	ProcessHistory("COMMENTS","keysort","H0","$_");
	# end of config
	if (/^# End of configuration file/i) {
	    printf STDERR "    End WriteTerm: $_" if ($debug);
	    $found_end = 1;
	    return(0);
	}
    }

    printf STDERR "    End WriteTerm: $_" if ($debug);

    if ($lines < 3) {
	printf(STDERR "ERROR: $host configuration appears to be truncated.\n");
	$found_end = 0;
	return(-1);
    }
    $found_end = 1;

    return(0);
}

1;
