require '_h2ph_pre.ph';

no warnings qw(redefine misc);

eval 'sub BBSIZE () {8192;}' unless defined(&BBSIZE);
eval 'sub SBSIZE () {8192;}' unless defined(&SBSIZE);
eval 'sub BBOFF () {(( &off_t)(0));}' unless defined(&BBOFF);
eval 'sub SBOFF () {(( &off_t)( &BBOFF +  &BBSIZE));}' unless defined(&SBOFF);
eval 'sub BBLOCK () {(( &daddr_t)(0));}' unless defined(&BBLOCK);
eval 'sub SBLOCK () {(( &daddr_t)( &BBLOCK +  &BBSIZE /  &DEV_BSIZE));}' unless defined(&SBLOCK);
eval 'sub SBLOCK_UFS1 () {8192;}' unless defined(&SBLOCK_UFS1);
eval 'sub SBLOCK_UFS2 () {65536;}' unless defined(&SBLOCK_UFS2);
eval 'sub SBLOCK_PIGGY () {262144;}' unless defined(&SBLOCK_PIGGY);
eval 'sub SBLOCKSIZE () {8192;}' unless defined(&SBLOCKSIZE);
eval 'sub SBLOCKSEARCH () {{  &SBLOCK_UFS2,  &SBLOCK_UFS1,  &SBLOCK_PIGGY, -1};}' unless defined(&SBLOCKSEARCH);
eval 'sub MAXFRAG () {8;}' unless defined(&MAXFRAG);
eval 'sub MINBSIZE () {4096;}' unless defined(&MINBSIZE);
eval 'sub MAXMNTLEN () {468;}' unless defined(&MAXMNTLEN);
eval 'sub MAXVOLLEN () {32;}' unless defined(&MAXVOLLEN);
eval 'sub NOCSPTRS () {((128/ $sizeof{ &void }) - 4);}' unless defined(&NOCSPTRS);
eval 'sub FS_MAXCONTIG () {16;}' unless defined(&FS_MAXCONTIG);
eval 'sub MINFREE () {5;}' unless defined(&MINFREE);
eval 'sub DEFAULTOPT () { &FS_OPTTIME;}' unless defined(&DEFAULTOPT);
eval 'sub AVFILESIZ () {16384;}' unless defined(&AVFILESIZ);
eval 'sub AFPDIR () {64;}' unless defined(&AFPDIR);
eval 'sub FSMAXSNAP () {20;}' unless defined(&FSMAXSNAP);
eval 'sub FS_MAGIC () {0x11954;}' unless defined(&FS_MAGIC);
eval 'sub FS_UFS1_MAGIC () {0x11954;}' unless defined(&FS_UFS1_MAGIC);
eval 'sub FS_UFS2_MAGIC () {0x19540119;}' unless defined(&FS_UFS2_MAGIC);
eval 'sub FS_OKAY () {0x7c269d38;}' unless defined(&FS_OKAY);
eval 'sub FS_42INODEFMT () {-1;}' unless defined(&FS_42INODEFMT);
eval 'sub FS_44INODEFMT () {2;}' unless defined(&FS_44INODEFMT);
eval 'sub FS_ISCLEAN () {0x1;}' unless defined(&FS_ISCLEAN);
eval 'sub FS_WASCLEAN () {0x2;}' unless defined(&FS_WASCLEAN);
eval 'sub FS_OPTTIME () {0;}' unless defined(&FS_OPTTIME);
eval 'sub FS_OPTSPACE () {1;}' unless defined(&FS_OPTSPACE);
eval 'sub FS_UNCLEAN () {0x1;}' unless defined(&FS_UNCLEAN);
eval 'sub FS_DOSOFTDEP () {0x2;}' unless defined(&FS_DOSOFTDEP);
eval 'sub FS_FLAGS_UPDATED () {0x80;}' unless defined(&FS_FLAGS_UPDATED);
eval 'sub FS_42POSTBLFMT () {-1;}' unless defined(&FS_42POSTBLFMT);
eval 'sub FS_DYNAMICPOSTBLFMT () {1;}' unless defined(&FS_DYNAMICPOSTBLFMT);
unless(defined(&fs_rotbl)) {
    sub fs_rotbl {
	my($fs) = @_;
	eval q(((($fs)-> &fs_postblformat ==  &FS_42POSTBLFMT) ? (($fs)-> &fs_space) : (( &u_int8_t *)(( &u_int8_t *)($fs) + ($fs)-> &fs_rotbloff))));
    }
}
unless(defined(&CGSIZE)) {
    sub CGSIZE {
	my($fs) = @_;
	eval q(($sizeof{'struct cg'} + $sizeof{ &int32_t} + ($fs)-> &fs_cpg * $sizeof{ &int32_t} + ($fs)-> &fs_cpg * ($fs)-> &fs_nrpos * $sizeof{ &int16_t} +  &howmany(($fs)-> &fs_ipg,  &NBBY) +  &howmany(($fs)-> &fs_fpg,  &NBBY) + (($fs)-> &fs_contigsumsize <= 0? 0: ($fs)-> &fs_contigsumsize * $sizeof{ &int32_t} +  &howmany( &fragstoblks($fs, ($fs)-> &fs_fpg),  &NBBY))));
    }
}
unless(defined(&fs_cs)) {
    sub fs_cs {
	my($fs, $indx) = @_;
	eval q( $fs_csp[$indx]);
    }
}
eval 'sub CG_MAGIC () {0x90255;}' unless defined(&CG_MAGIC);
unless(defined(&cg_blktot)) {
    sub cg_blktot {
	my($cgp) = @_;
	eval q(((($cgp)-> &cg_magic !=  &CG_MAGIC) ? ((($cgp))-> &cg_btot) : (( &int32_t *)(( &u_int8_t *)($cgp) + ($cgp)-> &cg_btotoff))));
    }
}
unless(defined(&cg_blks)) {
    sub cg_blks {
	my($fs, $cgp, $cylno) = @_;
	eval q(((($cgp)-> &cg_magic !=  &CG_MAGIC) ? ((($cgp))-> $cg_b[$cylno]) : (( &int16_t *)(( &u_int8_t *)($cgp) + ($cgp)-> &cg_boff) + ($cylno) * ($fs)-> &fs_nrpos)));
    }
}
unless(defined(&cg_inosused)) {
    sub cg_inosused {
	my($cgp) = @_;
	eval q(((($cgp)-> &cg_magic !=  &CG_MAGIC) ? ((($cgp))-> &cg_iused) : (( &u_int8_t *)(( &u_int8_t *)($cgp) + ($cgp)-> &cg_iusedoff))));
    }
}
unless(defined(&cg_blksfree)) {
    sub cg_blksfree {
	my($cgp) = @_;
	eval q(((($cgp)-> &cg_magic !=  &CG_MAGIC) ? ((($cgp))-> &cg_free) : (( &u_int8_t *)(( &u_int8_t *)($cgp) + ($cgp)-> &cg_freeoff))));
    }
}
unless(defined(&cg_chkmagic)) {
    sub cg_chkmagic {
	my($cgp) = @_;
	eval q((($cgp)-> &cg_magic ==  &CG_MAGIC || (($cgp))-> &cg_magic ==  &CG_MAGIC));
    }
}
unless(defined(&cg_clustersfree)) {
    sub cg_clustersfree {
	my($cgp) = @_;
	eval q((( &u_int8_t *)(( &u_int8_t *)($cgp) + ($cgp)-> &cg_clusteroff)));
    }
}
unless(defined(&cg_clustersum)) {
    sub cg_clustersum {
	my($cgp) = @_;
	eval q((( &int32_t *)(( &u_int8_t *)($cgp) + ($cgp)-> &cg_clustersumoff)));
    }
}
unless(defined(&fsbtodb)) {
    sub fsbtodb {
	my($fs, $b) = @_;
	eval q((($b) << ($fs)-> &fs_fsbtodb));
    }
}
unless(defined(&dbtofsb)) {
    sub dbtofsb {
	my($fs, $b) = @_;
	eval q((($b) >> ($fs)-> &fs_fsbtodb));
    }
}
unless(defined(&cgbase)) {
    sub cgbase {
	my($fs, $c) = @_;
	eval q((( &daddr_t)($fs)-> &fs_fpg * ($c)));
    }
}
unless(defined(&cgdata)) {
    sub cgdata {
	my($fs, $c) = @_;
	eval q(( &cgdmin($fs, $c) + ($fs)-> &fs_minfree));
    }
}
unless(defined(&cgmeta)) {
    sub cgmeta {
	my($fs, $c) = @_;
	eval q(( &cgdmin($fs, $c)));
    }
}
unless(defined(&cgdmin)) {
    sub cgdmin {
	my($fs, $c) = @_;
	eval q(( &cgstart($fs, $c) + ($fs)-> &fs_dblkno));
    }
}
unless(defined(&cgimin)) {
    sub cgimin {
	my($fs, $c) = @_;
	eval q(( &cgstart($fs, $c) + ($fs)-> &fs_iblkno));
    }
}
unless(defined(&cgsblock)) {
    sub cgsblock {
	my($fs, $c) = @_;
	eval q(( &cgstart($fs, $c) + ($fs)-> &fs_sblkno));
    }
}
unless(defined(&cgtod)) {
    sub cgtod {
	my($fs, $c) = @_;
	eval q(( &cgstart($fs, $c) + ($fs)-> &fs_cblkno));
    }
}
unless(defined(&cgstart)) {
    sub cgstart {
	my($fs, $c) = @_;
	eval q(( &cgbase($fs, $c) + ($fs)-> &fs_cgoffset * (($c) & ~(($fs)-> &fs_cgmask))));
    }
}
unless(defined(&ino_to_cg)) {
    sub ino_to_cg {
	my($fs, $x) = @_;
	eval q((($x) / ($fs)-> &fs_ipg));
    }
}
unless(defined(&ino_to_fsba)) {
    sub ino_to_fsba {
	my($fs, $x) = @_;
	eval q((( &daddr_t)( &cgimin($fs,  &ino_to_cg($fs, $x)) + ( &blkstofrags(($fs), ((($x) % ($fs)-> &fs_ipg) /  &INOPB($fs)))))));
    }
}
unless(defined(&ino_to_fsbo)) {
    sub ino_to_fsbo {
	my($fs, $x) = @_;
	eval q((($x) %  &INOPB($fs)));
    }
}
unless(defined(&dtog)) {
    sub dtog {
	my($fs, $d) = @_;
	eval q((($d) / ($fs)-> &fs_fpg));
    }
}
unless(defined(&dtogd)) {
    sub dtogd {
	my($fs, $d) = @_;
	eval q((($d) % ($fs)-> &fs_fpg));
    }
}
unless(defined(&blkmap)) {
    sub blkmap {
	my($fs, $map, $loc) = @_;
	eval q(((($map)[($loc) /  &NBBY] >> (($loc) %  &NBBY)) & (0xff >> ( &NBBY - ($fs)-> &fs_frag))));
    }
}
unless(defined(&cbtocylno)) {
    sub cbtocylno {
	my($fs, $bno) = @_;
	eval q(( &fsbtodb($fs, $bno) / ($fs)-> &fs_spc));
    }
}
unless(defined(&cbtorpos)) {
    sub cbtorpos {
	my($fs, $bno) = @_;
	eval q((($fs)-> &fs_nrpos <= 1? 0: ( &fsbtodb($fs, $bno) % ($fs)-> &fs_spc / ($fs)-> &fs_nsect * ($fs)-> &fs_trackskew +  &fsbtodb($fs, $bno) % ($fs)-> &fs_spc % ($fs)-> &fs_nsect * ($fs)-> &fs_interleave) % ($fs)-> &fs_nsect * ($fs)-> &fs_nrpos / ($fs)-> &fs_npsect));
    }
}
unless(defined(&blkoff)) {
    sub blkoff {
	my($fs, $loc) = @_;
	eval q((($loc) & ($fs)-> &fs_qbmask));
    }
}
unless(defined(&fragoff)) {
    sub fragoff {
	my($fs, $loc) = @_;
	eval q((($loc) & ($fs)-> &fs_qfmask));
    }
}
unless(defined(&lblktosize)) {
    sub lblktosize {
	my($fs, $blk) = @_;
	eval q((( &off_t)($blk) << ($fs)-> &fs_bshift));
    }
}
unless(defined(&lblkno)) {
    sub lblkno {
	my($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &fs_bshift));
    }
}
unless(defined(&numfrags)) {
    sub numfrags {
	my($fs, $loc) = @_;
	eval q((($loc) >> ($fs)-> &fs_fshift));
    }
}
unless(defined(&blkroundup)) {
    sub blkroundup {
	my($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &fs_qbmask) & ($fs)-> &fs_bmask));
    }
}
unless(defined(&fragroundup)) {
    sub fragroundup {
	my($fs, $size) = @_;
	eval q(((($size) + ($fs)-> &fs_qfmask) & ($fs)-> &fs_fmask));
    }
}
unless(defined(&fragstoblks)) {
    sub fragstoblks {
	my($fs, $frags) = @_;
	eval q((($frags) >> ($fs)-> &fs_fragshift));
    }
}
unless(defined(&blkstofrags)) {
    sub blkstofrags {
	my($fs, $blks) = @_;
	eval q((($blks) << ($fs)-> &fs_fragshift));
    }
}
unless(defined(&fragnum)) {
    sub fragnum {
	my($fs, $fsb) = @_;
	eval q((($fsb) & (($fs)-> &fs_frag - 1)));
    }
}
unless(defined(&blknum)) {
    sub blknum {
	my($fs, $fsb) = @_;
	eval q((($fsb) &~ (($fs)-> &fs_frag - 1)));
    }
}
unless(defined(&freespace)) {
    sub freespace {
	my($fs, $percentreserved) = @_;
	eval q(( &blkstofrags(($fs), ($fs)-> ($fs_cstotal->{cs_nbfree})) + ($fs)-> ($fs_cstotal->{cs_nffree}) - (($fs)-> &fs_dsize * ($percentreserved) / 100)));
    }
}
unless(defined(&blksize)) {
    sub blksize {
	my($fs, $ip, $lbn) = @_;
	eval q(((($lbn) >=  &NDADDR ||  &DIP(($ip),  &size) >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : ( &fragroundup($fs,  &blkoff($fs,  &DIP(($ip),  &size))))));
    }
}
unless(defined(&dblksize)) {
    sub dblksize {
	my($fs, $dip, $lbn) = @_;
	eval q(((($lbn) >=  &NDADDR || ($dip)-> &di_size >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($dip)-> &di_size)))));
    }
}
unless(defined(&sblksize)) {
    sub sblksize {
	my($fs, $size, $lbn) = @_;
	eval q(((($lbn) >=  &NDADDR || ($size) >= (($lbn) + 1) << ($fs)-> &fs_bshift) ? ($fs)-> &fs_bsize : ( &fragroundup($fs,  &blkoff($fs, ($size))))));
    }
}
unless(defined(&NSPB)) {
    sub NSPB {
	my($fs) = @_;
	eval q((($fs)-> &fs_nspf << ($fs)-> &fs_fragshift));
    }
}
unless(defined(&NSPF)) {
    sub NSPF {
	my($fs) = @_;
	eval q((($fs)-> &fs_nspf));
    }
}
unless(defined(&INOPB)) {
    sub INOPB {
	my($fs) = @_;
	eval q((($fs)-> &fs_inopb));
    }
}
unless(defined(&INOPF)) {
    sub INOPF {
	my($fs) = @_;
	eval q((($fs)-> &fs_inopb >> ($fs)-> &fs_fragshift));
    }
}
unless(defined(&NINDIR)) {
    sub NINDIR {
	my($fs) = @_;
	eval q((($fs)-> &fs_nindir));
    }
}
unless(defined(&FS_KERNMAXFILESIZE)) {
    sub FS_KERNMAXFILESIZE {
	my($pgsiz, $fs) = @_;
	eval q((( &u_int64_t)0x80000000 *  &MIN(($pgsiz), ($fs)-> &fs_bsize) - 1));
    }
}
1;
