require '_h2ph_pre.ph';

no warnings qw(redefine misc);

unless(defined(&_MIPS64_PARAM_H_)) {
    eval 'sub _MIPS64_PARAM_H_ () {1;}' unless defined(&_MIPS64_PARAM_H_);
    if(defined(&_KERNEL)) {
	require 'machine/cpu.ph';
    }
    eval 'sub PAGE_SIZE () {(1<<  &PAGE_SHIFT);}' unless defined(&PAGE_SIZE);
    eval 'sub PAGE_MASK () {( &PAGE_SIZE - 1);}' unless defined(&PAGE_MASK);
    if(defined(&_KERNEL)) {
	unless(defined(&KERNBASE)) {
	    eval 'sub KERNBASE () {0xffffffff80000000;}' unless defined(&KERNBASE);
	}
	eval 'sub NBPG () { &PAGE_SIZE;}' unless defined(&NBPG);
	eval 'sub PGSHIFT () { &PAGE_SHIFT;}' unless defined(&PGSHIFT);
	eval 'sub PGOFSET () { &PAGE_MASK;}' unless defined(&PGOFSET);
	eval 'sub USPACE () {16384;}' unless defined(&USPACE);
	eval 'sub UPAGES () {( &USPACE >>  &PAGE_SHIFT);}' unless defined(&UPAGES);
	if((defined(&PAGE_SHIFT) ? &PAGE_SHIFT : undef) > 12) {
	    eval 'sub USPACE_ALIGN () {0;}' unless defined(&USPACE_ALIGN);
	} else {
	    eval 'sub USPACE_ALIGN () {(2*  &PAGE_SIZE);}' unless defined(&USPACE_ALIGN);
	}
	eval 'sub NMBCLUSTERS () {4096;}' unless defined(&NMBCLUSTERS);
	unless(defined(&MSGBUFSIZE)) {
	    if((defined(&PAGE_SHIFT) ? &PAGE_SHIFT : undef) > 12) {
		eval 'sub MSGBUFSIZE () { &PAGE_SIZE;}' unless defined(&MSGBUFSIZE);
	    } else {
		eval 'sub MSGBUFSIZE () {8192;}' unless defined(&MSGBUFSIZE);
	    }
	}
	eval 'sub NKMEMPAGES_MAX_DEFAULT () {((128* 1024* 1024) >>  &PAGE_SHIFT);}' unless defined(&NKMEMPAGES_MAX_DEFAULT);
	unless(defined(&_LOCORE)) {
	    eval 'sub DELAY {
	        my($n) = @_;
    		eval q( &delay($n));
	    }' unless defined(&DELAY);
	}
    }
}
1;
