/*
 * Decompiled with CFR 0.152.
 */
package java.security.cert;

import gnu.classpath.SystemProperties;
import gnu.java.lang.CPStringBuilder;
import gnu.java.security.OID;
import gnu.java.security.x509.GnuPKIExtension;
import gnu.java.security.x509.ext.CertificatePolicies;
import gnu.java.security.x509.ext.Extension;
import gnu.java.security.x509.ext.GeneralName;
import gnu.java.security.x509.ext.GeneralSubtree;
import gnu.java.security.x509.ext.NameConstraints;
import java.io.IOException;
import java.math.BigInteger;
import java.net.InetAddress;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.cert.CertSelector;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.security.auth.x500.X500Principal;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509CertSelector
implements CertSelector,
Cloneable {
    private static final String AUTH_KEY_ID = "2.5.29.35";
    private static final String SUBJECT_KEY_ID = "2.5.29.14";
    private static final String NAME_CONSTRAINTS_ID = "2.5.29.30";
    private int basicConstraints = -1;
    private X509Certificate cert;
    private BigInteger serialNo;
    private X500Principal issuer;
    private X500Principal subject;
    private byte[] subjectKeyId;
    private byte[] authKeyId;
    private boolean[] keyUsage;
    private Date certValid;
    private OID sigId;
    private PublicKey subjectKey;
    private X509EncodedKeySpec subjectKeySpec;
    private Set<String> keyPurposeSet;
    private List<GeneralName> altNames;
    private boolean matchAllNames;
    private byte[] nameConstraints;
    private Set<OID> policy;
    private List<GeneralName> pathToNames;

    private static boolean checkOid(int[] oid) {
        return oid != null && oid.length > 2 && oid[0] >= 0 && oid[0] <= 2 && oid[1] >= 0 && oid[1] <= 39;
    }

    private static GeneralName makeName(int id, String name) throws IOException {
        byte[] nameBytes = null;
        GeneralName.Kind kind = GeneralName.Kind.forTag(id);
        switch (GeneralName.Kind.forTag(id)) {
            case rfc822Name: 
            case dNSName: 
            case uniformResourceIdentifier: {
                nameBytes = name.getBytes("ASCII");
                break;
            }
            case iPAddress: {
                InetAddress addr = InetAddress.getByName(name);
                nameBytes = addr.getAddress();
                break;
            }
            case registeredId: {
                OID oid = new OID(name);
                nameBytes = oid.getDER();
                break;
            }
            case directoryName: {
                X500Principal xname = new X500Principal(name);
                nameBytes = xname.getEncoded();
                break;
            }
            case otherName: 
            case x400Address: 
            case ediPartyName: {
                throw new IOException("cannot decode string representation of " + (Object)((Object)kind));
            }
        }
        return new GeneralName(kind, nameBytes);
    }

    public void addPathToName(int id, byte[] name) throws IOException {
        GeneralName generalName = new GeneralName(GeneralName.Kind.forTag(id), name);
        if (this.pathToNames == null) {
            this.pathToNames = new LinkedList<GeneralName>();
        }
        this.pathToNames.add(generalName);
    }

    public void addPathToName(int id, String name) throws IOException {
        GeneralName generalName = X509CertSelector.makeName(id, name);
        if (this.pathToNames == null) {
            this.pathToNames = new LinkedList<GeneralName>();
        }
        this.pathToNames.add(generalName);
    }

    public void addSubjectAlternativeName(int id, byte[] name) throws IOException {
        GeneralName generalName = new GeneralName(GeneralName.Kind.forTag(id), name);
        if (this.altNames == null) {
            this.altNames = new LinkedList<GeneralName>();
        }
        this.altNames.add(generalName);
    }

    public void addSubjectAlternativeName(int id, String name) throws IOException {
        GeneralName generalName = X509CertSelector.makeName(id, name);
        if (this.altNames == null) {
            this.altNames = new LinkedList<GeneralName>();
        }
        this.altNames.add(generalName);
    }

    @Override
    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException shouldNotHappen) {
            throw new Error(shouldNotHappen);
        }
    }

    public byte[] getAuthorityKeyIdentifier() {
        if (this.authKeyId != null) {
            return (byte[])this.authKeyId.clone();
        }
        return null;
    }

    public int getBasicConstraints() {
        return this.basicConstraints;
    }

    public X509Certificate getCertificate() {
        return this.cert;
    }

    public Date getCertificateValid() {
        if (this.certValid != null) {
            return (Date)this.certValid.clone();
        }
        return null;
    }

    public Set<String> getExtendedKeyUsage() {
        if (this.keyPurposeSet != null) {
            return Collections.unmodifiableSet(this.keyPurposeSet);
        }
        return null;
    }

    public byte[] getIssuerAsBytes() throws IOException {
        if (this.issuer != null) {
            return this.issuer.getEncoded();
        }
        return null;
    }

    public String getIssuerAsString() {
        if (this.issuer != null) {
            return this.issuer.getName();
        }
        return null;
    }

    public boolean[] getKeyUsage() {
        if (this.keyUsage != null) {
            return (boolean[])this.keyUsage.clone();
        }
        return null;
    }

    public boolean getMatchAllSubjectAltNames() {
        return this.matchAllNames;
    }

    public byte[] getNameConstraints() {
        if (this.nameConstraints != null) {
            return (byte[])this.nameConstraints.clone();
        }
        return null;
    }

    public Collection<List<?>> getPathToNames() {
        if (this.pathToNames != null) {
            ArrayList names = new ArrayList(this.pathToNames.size());
            for (GeneralName name : this.pathToNames) {
                ArrayList<Object> n = new ArrayList<Object>(2);
                n.add(name.kind().tag());
                n.add(name.name());
                names.add(n);
            }
            return names;
        }
        return null;
    }

    public Set<String> getPolicy() {
        Set<OID> p = this.policy;
        if (p != null) {
            HashSet<String> strings = new HashSet<String>(p.size());
            for (OID o : p) {
                strings.add(o.toString());
            }
            return strings;
        }
        return null;
    }

    public Date getPrivateKeyValid() {
        return null;
    }

    public BigInteger getSerialNumber() {
        return this.serialNo;
    }

    public Collection<List<?>> getSubjectAlternativeNames() {
        if (this.altNames != null) {
            ArrayList names = new ArrayList(this.altNames.size());
            for (GeneralName name : this.altNames) {
                ArrayList<Object> n = new ArrayList<Object>(2);
                n.add(name.kind().tag());
                n.add(name.name());
                names.add(n);
            }
            return names;
        }
        return null;
    }

    public byte[] getSubjectAsBytes() throws IOException {
        if (this.subject != null) {
            return this.subject.getEncoded();
        }
        return null;
    }

    public String getSubjectAsString() {
        if (this.subject != null) {
            return this.subject.getName();
        }
        return null;
    }

    public byte[] getSubjectKeyIdentifier() {
        if (this.subjectKeyId != null) {
            return (byte[])this.subjectKeyId.clone();
        }
        return null;
    }

    public PublicKey getSubjectPublicKey() {
        return this.subjectKey;
    }

    public String getSubjectPublicKeyAlgID() {
        return String.valueOf(this.sigId);
    }

    @Override
    public boolean match(Certificate certificate) {
        Object nc;
        Object[] b;
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate cert = (X509Certificate)certificate;
        if (this.cert != null) {
            try {
                byte[] e1 = this.cert.getEncoded();
                byte[] e2 = cert.getEncoded();
                if (!Arrays.equals(e1, e2)) {
                    return false;
                }
            }
            catch (CertificateEncodingException certificateEncodingException) {
                return false;
            }
        }
        if (this.serialNo != null && !this.serialNo.equals(cert.getSerialNumber())) {
            return false;
        }
        if (this.certValid != null) {
            try {
                cert.checkValidity(this.certValid);
            }
            catch (CertificateException certificateException) {
                return false;
            }
        }
        if (this.issuer != null && !this.issuer.equals(cert.getIssuerX500Principal())) {
            return false;
        }
        if (this.subject != null && !this.subject.equals(cert.getSubjectX500Principal())) {
            return false;
        }
        if (this.sigId != null && !this.sigId.toString().equals(cert.getSigAlgOID())) {
            return false;
        }
        if (this.subjectKeyId != null && !Arrays.equals(b = cert.getExtensionValue(SUBJECT_KEY_ID), this.subjectKeyId)) {
            return false;
        }
        if (this.authKeyId != null && !Arrays.equals(b = cert.getExtensionValue(AUTH_KEY_ID), this.authKeyId)) {
            return false;
        }
        if (this.keyUsage != null && !Arrays.equals((boolean[])(b = (Object[])cert.getKeyUsage()), this.keyUsage)) {
            return false;
        }
        if (this.basicConstraints >= 0 && cert.getBasicConstraints() != this.basicConstraints) {
            return false;
        }
        if (this.keyPurposeSet != null) {
            List<String> kp = null;
            try {
                kp = cert.getExtendedKeyUsage();
            }
            catch (CertificateParsingException certificateParsingException) {
                return false;
            }
            if (kp == null) {
                return false;
            }
            Iterator<String> it = this.keyPurposeSet.iterator();
            while (it.hasNext()) {
                if (kp.contains(it.next())) continue;
                return false;
            }
        }
        if (this.altNames != null) {
            Collection<List<?>> an = null;
            try {
                an = cert.getSubjectAlternativeNames();
            }
            catch (CertificateParsingException certificateParsingException) {
                return false;
            }
            if (an == null) {
                return false;
            }
            int match = 0;
            for (GeneralName name : this.altNames) {
                for (List<?> list2 : an) {
                    try {
                        Integer id = (Integer)list2.get(0);
                        Object val = list2.get(1);
                        GeneralName n = null;
                        if (val instanceof String) {
                            n = X509CertSelector.makeName(id, (String)val);
                        } else {
                            if (!(val instanceof byte[])) continue;
                            n = new GeneralName(GeneralName.Kind.forTag(id), (byte[])val);
                        }
                        if (!name.equals(n)) continue;
                        ++match;
                    }
                    catch (Exception exception) {}
                }
                if (match != 0 && (!this.matchAllNames || match >= this.altNames.size())) continue;
                return false;
            }
        }
        if (this.nameConstraints != null && !Arrays.equals(this.nameConstraints, (byte[])(nc = cert.getExtensionValue(NAME_CONSTRAINTS_ID)))) {
            return false;
        }
        if (this.policy != null) {
            CertificatePolicies policies = null;
            if (cert instanceof GnuPKIExtension) {
                policies = (CertificatePolicies)((GnuPKIExtension)((Object)cert)).getExtension(CertificatePolicies.ID).getValue();
            } else {
                byte[] policiesDer = cert.getExtensionValue(CertificatePolicies.ID.toString());
                try {
                    policies = new CertificatePolicies(policiesDer);
                }
                catch (IOException iOException) {}
            }
            if (policies == null) {
                return false;
            }
            if (!policies.getPolicies().containsAll(this.policy)) {
                return false;
            }
        }
        if (this.pathToNames != null) {
            nc = null;
            if (cert instanceof GnuPKIExtension) {
                Extension e = ((GnuPKIExtension)((Object)cert)).getExtension(NameConstraints.ID);
                if (e != null) {
                    nc = (NameConstraints)e.getValue();
                }
            } else {
                byte[] b2 = cert.getExtensionValue(NameConstraints.ID.toString());
                if (b2 != null) {
                    try {
                        nc = new NameConstraints(b2);
                    }
                    catch (IOException iOException) {}
                }
            }
            if (nc == null) {
                return false;
            }
            int match = 0;
            for (GeneralName name : this.pathToNames) {
                for (GeneralSubtree subtree : ((NameConstraints)nc).permittedSubtrees()) {
                    if (!name.equals(subtree.base())) continue;
                    ++match;
                }
            }
            if (match == 0 || this.matchAllNames && match < this.pathToNames.size()) {
                return false;
            }
        }
        return true;
    }

    public void setAuthorityKeyIdentifier(byte[] authKeyId) {
        this.authKeyId = authKeyId != null ? (byte[])authKeyId.clone() : null;
    }

    public void setBasicConstraints(int basicConstraints) {
        if (basicConstraints < -1) {
            basicConstraints = -1;
        }
        this.basicConstraints = basicConstraints;
    }

    public void setCertificate(X509Certificate cert) {
        this.cert = cert;
    }

    public void setCertificateValid(Date certValid) {
        this.certValid = certValid != null ? (Date)certValid.clone() : null;
    }

    public void setExtendedKeyUsage(Set<String> keyPurposeSet) throws IOException {
        if (keyPurposeSet == null) {
            this.keyPurposeSet = null;
            return;
        }
        HashSet<String> s = new HashSet<String>();
        for (String o : keyPurposeSet) {
            if (!(o instanceof String)) {
                throw new IOException("not a string: " + o);
            }
            try {
                OID oid = new OID(o);
                int[] comp = oid.getIDs();
                if (X509CertSelector.checkOid(comp)) continue;
                throw new IOException("malformed OID: " + o);
            }
            catch (IllegalArgumentException iae) {
                IOException ioe = new IOException("malformed OID: " + o);
                ioe.initCause(iae);
                throw ioe;
            }
        }
        this.keyPurposeSet = s;
    }

    public void setIssuer(byte[] name) throws IOException {
        if (name != null) {
            try {
                this.issuer = new X500Principal(name);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        } else {
            this.issuer = null;
        }
    }

    public void setIssuer(String name) throws IOException {
        if (name != null) {
            try {
                this.issuer = new X500Principal(name);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        } else {
            this.issuer = null;
        }
    }

    public void setKeyUsage(boolean[] keyUsage) {
        this.keyUsage = keyUsage != null ? (boolean[])keyUsage.clone() : null;
    }

    public void setMatchAllSubjectAltNames(boolean matchAllNames) {
        this.matchAllNames = matchAllNames;
    }

    public void setNameConstraints(byte[] nameConstraints) throws IOException {
        new NameConstraints(nameConstraints);
        this.nameConstraints = nameConstraints != null ? (byte[])nameConstraints.clone() : null;
    }

    public void setPathToNames(Collection<List<?>> names) throws IOException {
        if (names == null || names.size() == 0) {
            this.pathToNames = null;
        } else {
            this.pathToNames = new ArrayList<GeneralName>(names.size());
            for (List<?> name : names) {
                Integer id = (Integer)name.get(0);
                Object name2 = name.get(1);
                if (name2 instanceof String) {
                    this.addPathToName((int)id, (String)name2);
                    continue;
                }
                if (name2 instanceof byte[]) {
                    this.addPathToName((int)id, (byte[])name2);
                    continue;
                }
                throw new IOException("invalid name type: " + name2.getClass().getName());
            }
        }
    }

    public void setPolicy(Set<String> policy) throws IOException {
        if (policy != null) {
            HashSet<OID> p = new HashSet<OID>(policy.size());
            for (String s : policy) {
                try {
                    OID oid = new OID(s);
                    int[] i = oid.getIDs();
                    if (!X509CertSelector.checkOid(i)) {
                        throw new IOException("invalid OID");
                    }
                    p.add(oid);
                }
                catch (IOException ioe) {
                    throw ioe;
                }
                catch (Exception x) {
                    IOException ioe = new IOException("invalid OID");
                    ioe.initCause(x);
                    throw ioe;
                }
            }
            this.policy = p;
        } else {
            this.policy = null;
        }
    }

    public void setPrivateKeyValid(Date UNUSED) {
    }

    public void setSerialNumber(BigInteger serialNo) {
        this.serialNo = serialNo;
    }

    public void setSubject(byte[] name) throws IOException {
        if (name != null) {
            try {
                this.subject = new X500Principal(name);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        } else {
            this.subject = null;
        }
    }

    public void setSubject(String name) throws IOException {
        if (name != null) {
            try {
                this.subject = new X500Principal(name);
            }
            catch (IllegalArgumentException iae) {
                throw new IOException(iae.getMessage());
            }
        } else {
            this.subject = null;
        }
    }

    public void setSubjectAlternativeNames(Collection<List<?>> altNames) throws IOException {
        if (altNames == null || altNames.isEmpty()) {
            this.altNames = null;
            return;
        }
        ArrayList<GeneralName> l = new ArrayList<GeneralName>(altNames.size());
        for (List<?> list2 : altNames) {
            Integer id = (Integer)list2.get(0);
            Object value = list2.get(1);
            GeneralName name = null;
            if (value instanceof String) {
                name = X509CertSelector.makeName(id, (String)value);
            } else if (value instanceof byte[]) {
                name = new GeneralName(GeneralName.Kind.forTag(id), (byte[])value);
            } else {
                throw new IOException("invalid name type: " + value.getClass().getName());
            }
            l.add(name);
        }
        this.altNames = l;
    }

    public void setSubjectKeyIdentifier(byte[] subjectKeyId) {
        this.subjectKeyId = subjectKeyId != null ? (byte[])subjectKeyId.clone() : null;
    }

    public void setSubjectPublicKey(byte[] key) throws IOException {
        if (key == null) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
            return;
        }
        try {
            this.subjectKeySpec = new X509EncodedKeySpec(key);
            KeyFactory enc = KeyFactory.getInstance("X.509");
            this.subjectKey = enc.generatePublic(this.subjectKeySpec);
        }
        catch (Exception x) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
            IOException ioe = new IOException(x.getMessage());
            ioe.initCause(x);
            throw ioe;
        }
    }

    public void setSubjectPublicKey(PublicKey key) {
        this.subjectKey = key;
        if (key == null) {
            this.subjectKeySpec = null;
            return;
        }
        try {
            KeyFactory enc = KeyFactory.getInstance("X.509");
            this.subjectKeySpec = enc.getKeySpec(key, X509EncodedKeySpec.class);
        }
        catch (Exception exception) {
            this.subjectKey = null;
            this.subjectKeySpec = null;
        }
    }

    public void setSubjectPublicKeyAlgID(String sigId) throws IOException {
        if (sigId != null) {
            try {
                OID oid = new OID(sigId);
                int[] comp = oid.getIDs();
                if (!X509CertSelector.checkOid(comp)) {
                    throw new IOException("malformed OID: " + sigId);
                }
                this.sigId = oid;
            }
            catch (IllegalArgumentException iae) {
                IOException ioe = new IOException("malformed OID: " + sigId);
                ioe.initCause(iae);
                throw ioe;
            }
        } else {
            this.sigId = null;
        }
    }

    public String toString() {
        int i;
        CPStringBuilder str = new CPStringBuilder(X509CertSelector.class.getName());
        String nl = SystemProperties.getProperty("line.separator");
        String eol = ";" + nl;
        str.append(" {").append(nl);
        if (this.cert != null) {
            str.append("  certificate = ").append(this.cert).append(eol);
        }
        if (this.basicConstraints >= 0) {
            str.append("  basic constraints = ").append(this.basicConstraints).append(eol);
        }
        if (this.serialNo != null) {
            str.append("  serial number = ").append(this.serialNo).append(eol);
        }
        if (this.certValid != null) {
            str.append("  valid date = ").append(this.certValid).append(eol);
        }
        if (this.issuer != null) {
            str.append("  issuer = ").append(this.issuer).append(eol);
        }
        if (this.subject != null) {
            str.append("  subject = ").append(this.subject).append(eol);
        }
        if (this.sigId != null) {
            str.append("  signature OID = ").append(this.sigId).append(eol);
        }
        if (this.subjectKey != null) {
            str.append("  subject public key = ").append(this.subjectKey).append(eol);
        }
        if (this.subjectKeyId != null) {
            str.append("  subject key ID = ");
            i = 0;
            while (i < this.subjectKeyId.length) {
                str.append(Character.forDigit((this.subjectKeyId[i] & 0xF0) >>> 8, 16));
                str.append(Character.forDigit(this.subjectKeyId[i] & 0xF, 16));
                if (i < this.subjectKeyId.length - 1) {
                    str.append(':');
                }
                ++i;
            }
            str.append(eol);
        }
        if (this.authKeyId != null) {
            str.append("  authority key ID = ");
            i = 0;
            while (i < this.authKeyId.length) {
                str.append(Character.forDigit((this.authKeyId[i] & 0xF0) >>> 8, 16));
                str.append(Character.forDigit(this.authKeyId[i] & 0xF, 16));
                if (i < this.authKeyId.length - 1) {
                    str.append(':');
                }
                ++i;
            }
            str.append(eol);
        }
        if (this.keyUsage != null) {
            str.append("  key usage = ");
            i = 0;
            while (i < this.keyUsage.length) {
                str.append(this.keyUsage[i] ? (char)'1' : '0');
                ++i;
            }
            str.append(eol);
        }
        if (this.keyPurposeSet != null) {
            str.append("  key purpose = ").append(this.keyPurposeSet).append(eol);
        }
        if (this.altNames != null) {
            str.append("  alternative names = ").append(this.altNames).append(eol);
        }
        if (this.nameConstraints != null) {
            str.append("  name constraints = <blob of data>").append(eol);
        }
        if (this.policy != null) {
            str.append("  policy = ").append(this.policy).append(eol);
        }
        if (this.pathToNames != null) {
            str.append("  pathToNames = ").append(this.pathToNames).append(eol);
        }
        str.append("}").append(nl);
        return str.toString();
    }
}

