/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.gtk;

import gnu.classpath.Pointer;
import gnu.java.awt.peer.gtk.GtkImageConsumer;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.ImageObserver;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GtkImage
extends Image {
    int width = -1;
    int height = -1;
    Hashtable<?, ?> props;
    boolean isLoaded;
    Pointer pixbuf;
    Vector<ImageObserver> observers;
    boolean errorLoading;
    ImageProducer source;
    static ColorModel nativeModel = new DirectColorModel(32, 255, 65280, 0xFF0000, -16777216);
    private static GtkImage errorImage;
    static Object pixbufLock;

    static {
        pixbufLock = new Object();
    }

    private native void initFromBuffer(long var1);

    native int[] getPixels();

    private native void setPixels(int[] var1);

    private native boolean loadPixbuf(String var1);

    private native boolean loadImageFromData(byte[] var1);

    private native void createPixbuf();

    private native void freePixbuf();

    private native void createScaledPixbuf(GtkImage var1, int var2);

    public GtkImage(ImageProducer producer) {
        this.isLoaded = false;
        this.observers = new Vector();
        this.source = producer;
        this.errorLoading = false;
        this.source.startProduction(new GtkImageConsumer(this, this.source));
    }

    public GtkImage() {
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtkImage(String filename) {
        File f = new File(filename);
        try {
            f.getCanonicalPath();
            Object object = pixbufLock;
            synchronized (object) {
                if (!this.loadPixbuf(f.getCanonicalPath())) {
                    throw new IllegalArgumentException("Couldn't load image: " + filename);
                }
            }
        }
        catch (IOException e) {
            IllegalArgumentException iae = new IllegalArgumentException("Couldn't load image: " + filename);
            iae.initCause(e);
            throw iae;
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtkImage(byte[] data) {
        Object object = pixbufLock;
        synchronized (object) {
            if (!this.loadImageFromData(data)) {
                throw new IllegalArgumentException("Couldn't load image.");
            }
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
        this.errorLoading = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GtkImage(URL url) {
        this.isLoaded = false;
        this.observers = new Vector();
        this.errorLoading = false;
        if (url == null) {
            return;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream(5000);
        try {
            BufferedInputStream bis = new BufferedInputStream(url.openStream());
            byte[] buf = new byte[5000];
            int n = 0;
            while ((n = bis.read(buf)) != -1) {
                baos.write(buf, 0, n);
            }
            bis.close();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("Couldn't load image.");
        }
        byte[] array = baos.toByteArray();
        Object object = pixbufLock;
        synchronized (object) {
            if (!this.loadImageFromData(array)) {
                throw new IllegalArgumentException("Couldn't load image.");
            }
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GtkImage(GtkImage src, int width, int height, int hints) {
        this.width = width;
        this.height = height;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        Object object = pixbufLock;
        synchronized (object) {
            this.createScaledPixbuf(src, hints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    GtkImage(Pointer pixbuf) {
        this.pixbuf = pixbuf;
        Object object = pixbufLock;
        synchronized (object) {
            this.createFromPixbuf();
        }
        this.isLoaded = true;
        this.observers = null;
        this.props = new Hashtable();
    }

    GtkImage(int width, int height, long bufferPointer) {
        this.width = width;
        this.height = height;
        this.props = new Hashtable();
        this.isLoaded = true;
        this.observers = null;
        this.initFromBuffer(bufferPointer);
    }

    static synchronized GtkImage getErrorImage() {
        if (errorImage == null) {
            errorImage = new GtkImage();
            GtkImage.errorImage.errorLoading = true;
        }
        return errorImage;
    }

    private native void createFromPixbuf();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setImage(int width, int height, int[] pixels, Hashtable<?, ?> properties) {
        this.width = width;
        this.height = height;
        Hashtable hashtable = this.props = properties != null ? properties : new Hashtable();
        if (width <= 0 || height <= 0 || pixels == null) {
            this.errorLoading = true;
            return;
        }
        Object object = pixbufLock;
        synchronized (object) {
            this.createPixbuf();
            this.setPixels(pixels);
        }
        this.isLoaded = true;
        this.deliver();
    }

    @Override
    public synchronized int getWidth(ImageObserver observer) {
        if (this.addObserver(observer)) {
            return -1;
        }
        return this.width;
    }

    @Override
    public synchronized int getHeight(ImageObserver observer) {
        if (this.addObserver(observer)) {
            return -1;
        }
        return this.height;
    }

    @Override
    public synchronized Object getProperty(String name, ImageObserver observer) {
        if (this.addObserver(observer)) {
            return UndefinedProperty;
        }
        Object value = this.props.get(name);
        return value == null ? UndefinedProperty : value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImageProducer getSource() {
        int[] pixels;
        if (!this.isLoaded) {
            return null;
        }
        Object object = pixbufLock;
        synchronized (object) {
            if (this.errorLoading) {
                return null;
            }
            pixels = this.getPixels();
        }
        return new MemoryImageSource(this.width, this.height, nativeModel, pixels, 0, this.width);
    }

    @Override
    public Graphics getGraphics() {
        throw new IllegalAccessError("This method only works for off-screen Images.");
    }

    @Override
    public Image getScaledInstance(int width, int height, int hints) {
        if (width <= 0 || height <= 0) {
            throw new IllegalArgumentException("Width and height of scaled bitmapmust be >= 0");
        }
        return new GtkImage(this, width, height, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void flush() {
        if (this.isLoaded && this.source != null) {
            this.observers = new Vector();
            this.isLoaded = false;
            Object object = pixbufLock;
            synchronized (object) {
                this.freePixbuf();
            }
            this.source.startProduction(new GtkImageConsumer(this, this.source));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finalize() {
        if (this.isLoaded) {
            Object object = pixbufLock;
            synchronized (object) {
                this.freePixbuf();
            }
        }
    }

    public int checkImage(ImageObserver observer) {
        if (this.addObserver(observer)) {
            if (this.errorLoading) {
                return 64;
            }
            return 0;
        }
        return 35;
    }

    private void deliver() {
        int flags = 39;
        if (this.observers != null) {
            int i = 0;
            while (i < this.observers.size()) {
                this.observers.elementAt(i).imageUpdate(this, flags, 0, 0, this.width, this.height);
                ++i;
            }
        }
        this.observers = null;
    }

    private boolean addObserver(ImageObserver observer) {
        if (!this.isLoaded) {
            if (observer != null && !this.observers.contains(observer)) {
                this.observers.addElement(observer);
            }
            return true;
        }
        return false;
    }
}

