/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt;

import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class GradientPaintContext
implements PaintContext {
    private final float x1;
    private final float y1;
    private final Color c1;
    private final float x2;
    private final float y2;
    private final Color c2;
    private final boolean cyclic;
    private final double length;

    public GradientPaintContext(float x1, float y1, Color c1, float x2, float y2, Color c2, boolean cyclic) {
        this.x1 = x1;
        this.y1 = y1;
        this.c1 = c1;
        this.x2 = x2;
        this.y2 = y2;
        this.c2 = c2;
        this.cyclic = cyclic;
        this.length = Point2D.distance(x1, y1, x2, y2);
    }

    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    public Raster getRaster(int x, int y, int w, int h) {
        ColorModel cm = this.getColorModel();
        WritableRaster raster = cm.createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        double pd2 = (this.x1 - this.x2) * (this.x1 - this.x2) + (this.y1 - this.y2) * (this.y1 - this.y2);
        int r = 0;
        while (r < h) {
            int c = 0;
            while (c < w) {
                double u = 0.0;
                if (pd2 != 0.0) {
                    u = (double)(((float)(x + c) - this.x1) * (this.x2 - this.x1) + ((float)(y + r) - this.y1) * (this.y2 - this.y1)) / Math.sqrt(pd2);
                }
                double ratio = u / this.length;
                ratio = this.cyclic ? Math.abs(ratio - Math.floor((ratio + 1.0) / 2.0) * 2.0) : Math.max(0.0, Math.min(1.0, ratio));
                int base = (r * w + c) * 4;
                data[base] = (int)((double)this.c1.getRed() + ratio * (double)(this.c2.getRed() - this.c1.getRed()));
                data[base + 1] = (int)((double)this.c1.getGreen() + ratio * (double)(this.c2.getGreen() - this.c1.getGreen()));
                data[base + 2] = (int)((double)this.c1.getBlue() + ratio * (double)(this.c2.getBlue() - this.c1.getBlue()));
                data[base + 3] = (int)((double)this.c1.getAlpha() + ratio * (double)(this.c2.getAlpha() - this.c1.getAlpha()));
                ++c;
            }
            ++r;
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    public void dispose() {
    }
}

